/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.awt.font;

import org.checkerframework.checker.interning.qual.UsesObjectEquals;
import org.checkerframework.framework.qual.AnnotatedFor;
import java.awt.geom.Rectangle2D;

@AnnotatedFor({ "interning" })
@UsesObjectEquals
public final class GlyphMetrics {

    public static final byte STANDARD;

    public static final byte LIGATURE;

    public static final byte COMBINING;

    public static final byte COMPONENT;

    public static final byte WHITESPACE;

    public GlyphMetrics(float advance, Rectangle2D bounds, byte glyphType) {
    }

    public GlyphMetrics(boolean horizontal, float advanceX, float advanceY, Rectangle2D bounds, byte glyphType) {
    }

    public float getAdvance();

    public float getAdvanceX();

    public float getAdvanceY();

    public Rectangle2D getBounds2D();

    public float getLSB();

    public float getRSB();

    public int getType();

    public boolean isStandard();

    public boolean isLigature();

    public boolean isCombining();

    public boolean isComponent();

    public boolean isWhitespace();
}
