/*
 * Copyright (c) 1996, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.sql;

import org.checkerframework.checker.sqlquotes.qual.SqlEvenQuotes;
import org.checkerframework.checker.tainting.qual.Untainted;
import java.util.regex.Pattern;
import static java.util.stream.Collectors.joining;

public interface Statement extends Wrapper, AutoCloseable {

    ResultSet executeQuery(@Untainted @SqlEvenQuotes @SqlEvenQuotes String sql) throws SQLException;

    int executeUpdate(@Untainted @SqlEvenQuotes String sql) throws SQLException;

    void close() throws SQLException;

    int getMaxFieldSize() throws SQLException;

    void setMaxFieldSize(int max) throws SQLException;

    int getMaxRows() throws SQLException;

    void setMaxRows(int max) throws SQLException;

    void setEscapeProcessing(boolean enable) throws SQLException;

    int getQueryTimeout() throws SQLException;

    void setQueryTimeout(int seconds) throws SQLException;

    void cancel() throws SQLException;

    SQLWarning getWarnings() throws SQLException;

    void clearWarnings() throws SQLException;

    void setCursorName(String name) throws SQLException;

    boolean execute(@Untainted @SqlEvenQuotes String sql) throws SQLException;

    ResultSet getResultSet() throws SQLException;

    int getUpdateCount() throws SQLException;

    boolean getMoreResults() throws SQLException;

    void setFetchDirection(int direction) throws SQLException;

    int getFetchDirection() throws SQLException;

    void setFetchSize(int rows) throws SQLException;

    int getFetchSize() throws SQLException;

    int getResultSetConcurrency() throws SQLException;

    int getResultSetType() throws SQLException;

    void addBatch(@Untainted @SqlEvenQuotes String sql) throws SQLException;

    void clearBatch() throws SQLException;

    int[] executeBatch() throws SQLException;

    Connection getConnection() throws SQLException;

    int CLOSE_CURRENT_RESULT;

    int KEEP_CURRENT_RESULT;

    int CLOSE_ALL_RESULTS;

    int SUCCESS_NO_INFO;

    int EXECUTE_FAILED;

    int RETURN_GENERATED_KEYS;

    int NO_GENERATED_KEYS;

    boolean getMoreResults(int current) throws SQLException;

    ResultSet getGeneratedKeys() throws SQLException;

    int executeUpdate(@Untainted @SqlEvenQuotes String sql, int autoGeneratedKeys) throws SQLException;

    int executeUpdate(@Untainted @SqlEvenQuotes String sql, int[] columnIndexes) throws SQLException;

    int executeUpdate(@Untainted @SqlEvenQuotes String sql, String[] columnNames) throws SQLException;

    boolean execute(@Untainted @SqlEvenQuotes String sql, int autoGeneratedKeys) throws SQLException;

    boolean execute(@Untainted @SqlEvenQuotes String sql, int[] columnIndexes) throws SQLException;

    boolean execute(@Untainted @SqlEvenQuotes String sql, String[] columnNames) throws SQLException;

    int getResultSetHoldability() throws SQLException;

    boolean isClosed() throws SQLException;

    void setPoolable(boolean poolable) throws SQLException;

    boolean isPoolable() throws SQLException;

    public void closeOnCompletion() throws SQLException;

    public boolean isCloseOnCompletion() throws SQLException;

    default long getLargeUpdateCount() throws SQLException;

    default void setLargeMaxRows(long max) throws SQLException;

    default long getLargeMaxRows() throws SQLException;

    default long[] executeLargeBatch() throws SQLException;

    default long executeLargeUpdate(@Untainted @SqlEvenQuotes String sql) throws SQLException;

    default long executeLargeUpdate(@Untainted @SqlEvenQuotes String sql, int autoGeneratedKeys) throws SQLException;

    default long executeLargeUpdate(@Untainted @SqlEvenQuotes String sql, int[] columnIndexes) throws SQLException;

    default long executeLargeUpdate(@Untainted @SqlEvenQuotes String sql, String[] columnNames) throws SQLException;

    default String enquoteLiteral(String val) throws SQLException;

    default String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException;

    default boolean isSimpleIdentifier(String identifier) throws SQLException;

    default String enquoteNCharLiteral(String val) throws SQLException;
}
