/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.dataflow.qual.Pure;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import com.sun.javadoc.*;
import com.sun.tools.javac.code.Source.Feature;
import com.sun.tools.javac.tree.JCTree.JCClassDecl;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Position;

@Deprecated()
@SuppressWarnings("removal")
public class RootDocImpl extends DocImpl implements RootDoc {

    public RootDocImpl(DocEnv env, List<JCClassDecl> classes, List<String> packages, List<String[]> options) {
    }

    public RootDocImpl(DocEnv env, List<String> classes, List<String[]> options) {
    }

    public String[][] options();

    public PackageDoc[] specifiedPackages();

    public ClassDoc[] specifiedClasses();

    public ClassDoc[] classes();

    public ClassDoc classNamed(String qualifiedName);

    public PackageDoc packageNamed(String name);

    public String name();

    public String qualifiedName();

    @Pure
    public boolean isIncluded();

    public void printError(String msg);

    public void printError(SourcePosition pos, String msg);

    public void printWarning(String msg);

    public void printWarning(SourcePosition pos, String msg);

    public void printNotice(String msg);

    public void printNotice(SourcePosition pos, String msg);

    @Override
    protected String documentation();

    @Override
    public SourcePosition position();

    public Locale getLocale();

    public JavaFileManager getFileManager();

    public void initDocLint(Collection<String> opts, Collection<String> customTagNames, String htmlVersion);

    public JavaScriptScanner initJavaScriptScanner(boolean allowScriptInComments);

    @Pure
    public boolean isFunctionalInterface(AnnotationDesc annotationDesc);

    public boolean showTagMessages();
}
