/*
 * Copyright (c) 1997, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.tools.javadoc.main;

import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.dataflow.qual.Pure;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager.Location;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import com.sun.javadoc.*;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Kinds.KindSelector;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symbol.*;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Type.ClassType;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.JCTree.JCFieldAccess;
import com.sun.tools.javac.tree.JCTree.JCImport;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import static com.sun.tools.javac.code.Kinds.Kind.*;
import static com.sun.tools.javac.code.Scope.LookupKind.NON_RECURSIVE;
import static com.sun.tools.javac.code.TypeTag.CLASS;
import static com.sun.tools.javac.tree.JCTree.Tag.*;

@Deprecated()
@SuppressWarnings("removal")
public class ClassDocImpl extends ProgramElementDocImpl implements ClassDoc {

    public final ClassType type;

    public final ClassSymbol tsym;

    public ClassDocImpl(DocEnv env, ClassSymbol sym) {
    }

    public ClassDocImpl(DocEnv env, ClassSymbol sym, TreePath treePath) {
    }

    public com.sun.javadoc.Type getElementType();

    protected long getFlags();

    static long getFlags(ClassSymbol clazz);

    static boolean isAnnotationType(ClassSymbol clazz);

    protected ClassSymbol getContainingClass();

    @Override
    @Pure
    public boolean isClass();

    @Override
    @Pure
    public boolean isOrdinaryClass();

    @Override
    @Pure
    public boolean isEnum();

    @Override
    @Pure
    public boolean isInterface();

    @Override
    @Pure
    public boolean isException();

    @Override
    @Pure
    public boolean isError();

    @Pure
    public boolean isThrowable();

    @Pure
    public boolean isAbstract();

    @Pure
    public boolean isSynthetic();

    @Pure
    public boolean isIncluded();

    @Override
    public PackageDoc containingPackage();

    public String name();

    @BinaryName
    public String qualifiedName();

    public String typeName();

    public String qualifiedTypeName();

    public String simpleTypeName();

    @Override
    public String toString();

    static String getClassName(ClassSymbol c, boolean full);

    static String classToString(DocEnv env, ClassSymbol c, boolean full);

    static boolean isGeneric(ClassSymbol c);

    public TypeVariable[] typeParameters();

    public ParamTag[] typeParamTags();

    @Override
    public String modifiers();

    @Override
    public int modifierSpecifier();

    public ClassDoc superclass();

    public com.sun.javadoc.Type superclassType();

    public boolean subclassOf(ClassDoc cd);

    public ClassDoc[] interfaces();

    public com.sun.javadoc.Type[] interfaceTypes();

    public FieldDoc[] fields(boolean filter);

    public FieldDoc[] fields();

    public FieldDoc[] enumConstants();

    public MethodDoc[] methods(boolean filter);

    public MethodDoc[] methods();

    public ConstructorDoc[] constructors(boolean filter);

    public ConstructorDoc[] constructors();

    void addAllClasses(ListBuffer<ClassDocImpl> l, boolean filtered);

    public ClassDoc[] innerClasses(boolean filter);

    public ClassDoc[] innerClasses();

    public ClassDoc findClass(String className);

    public MethodDocImpl findMethod(String methodName, String[] paramTypes);

    public ConstructorDoc findConstructor(String constrName, String[] paramTypes);

    public FieldDoc findField(String fieldName);

    @Deprecated()
    public ClassDoc[] importedClasses();

    @Deprecated()
    public PackageDoc[] importedPackages();

    public String dimension();

    public ClassDoc asClassDoc();

    public AnnotationTypeDoc asAnnotationTypeDoc();

    public ParameterizedType asParameterizedType();

    public TypeVariable asTypeVariable();

    public WildcardType asWildcardType();

    public AnnotatedType asAnnotatedType();

    @Pure
    public boolean isPrimitive();

    @Pure
    public boolean isSerializable();

    @Pure
    public boolean isExternalizable();

    public MethodDoc[] serializationMethods();

    public FieldDoc[] serializableFields();

    public boolean definesSerializableFields();

    boolean isRuntimeException();

    @Override
    public SourcePosition position();
}
