/*
 * Copyright (c) 2003, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.formats.html;

import org.checkerframework.dataflow.qual.Pure;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import jdk.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;
import jdk.javadoc.internal.doclets.toolkit.util.links.LinkInfo;

public class LinkInfoImpl extends LinkInfo {

    public enum Kind {

        DEFAULT,
        ALL_CLASSES_FRAME,
        CLASS,
        MEMBER,
        CLASS_USE,
        INDEX,
        CONSTANT_SUMMARY,
        SERIALIZED_FORM,
        SERIAL_MEMBER,
        PACKAGE,
        SEE_TAG,
        VALUE_TAG,
        TREE,
        PACKAGE_FRAME,
        CLASS_HEADER,
        CLASS_SIGNATURE,
        RETURN_TYPE,
        SUMMARY_RETURN_TYPE,
        EXECUTABLE_MEMBER_PARAM,
        SUPER_INTERFACES,
        IMPLEMENTED_INTERFACES,
        IMPLEMENTED_CLASSES,
        SUBINTERFACES,
        SUBCLASSES,
        CLASS_SIGNATURE_PARENT_NAME,
        EXECUTABLE_ELEMENT_COPY,
        METHOD_SPECIFIED_BY,
        METHOD_OVERRIDES,
        ANNOTATION,
        VARIABLE_ELEMENT_COPY,
        CLASS_TREE_PARENT,
        MEMBER_TYPE_PARAMS,
        CLASS_USE_HEADER,
        PROPERTY_COPY,
        RECEIVER_TYPE
    }

    public final HtmlConfiguration configuration;

    public Kind context;

    public String where;

    public String target;

    public final Utils utils;

    public LinkInfoImpl(HtmlConfiguration configuration, Kind context, ExecutableElement ee) {
    }

    @Override
    protected Content newContent();

    public LinkInfoImpl(HtmlConfiguration configuration, Kind context, TypeElement typeElement) {
    }

    public LinkInfoImpl(HtmlConfiguration configuration, Kind context, TypeMirror type) {
    }

    public LinkInfoImpl label(CharSequence label);

    public LinkInfoImpl label(Content label);

    public LinkInfoImpl strong(boolean strong);

    public LinkInfoImpl target(String target);

    public LinkInfoImpl varargs(boolean varargs);

    public LinkInfoImpl where(String where);

    public Kind getContext();

    public final void setContext(Kind c);

    @Override
    @Pure
    public boolean isLinkable();

    @Override
    public String toString();
}
