/*
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package com.sun.java.util.jar.pack;

import org.checkerframework.checker.nullness.qual.PolyNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

final class FixedList<E> implements List<E> {

    protected FixedList(int capacity) {
    }

    @Override
    public int size();

    @Override
    public boolean isEmpty();

    @Override
    public boolean contains(Object o);

    @Override
    public Iterator<E> iterator();

    @Override
    @PolyNull
    public Object[] toArray(FixedList<@PolyNull E> this);

    @Override
    public <T> T[] toArray(T[] a);

    @Override
    public boolean add(E e) throws UnsupportedOperationException;

    @Override
    public boolean remove(Object o) throws UnsupportedOperationException;

    @Override
    public boolean containsAll(Collection<?> c);

    @Override
    public boolean addAll(Collection<? extends E> c) throws UnsupportedOperationException;

    @Override
    public boolean addAll(int index, Collection<? extends E> c) throws UnsupportedOperationException;

    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException;

    @Override
    public boolean retainAll(Collection<?> c) throws UnsupportedOperationException;

    @Override
    public void clear() throws UnsupportedOperationException;

    @Override
    public E get(int index);

    @Override
    public E set(int index, E element);

    @Override
    public void add(int index, E element) throws UnsupportedOperationException;

    @Override
    public E remove(int index) throws UnsupportedOperationException;

    @Override
    public int indexOf(Object o);

    @Override
    public int lastIndexOf(Object o);

    @Override
    public ListIterator<E> listIterator();

    @Override
    public ListIterator<E> listIterator(int index);

    @Override
    public List<E> subList(int fromIndex, int toIndex);

    @Override
    public String toString();
}
