/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.mavenplugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.CompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavacErrorMessagesParser {
    protected static final String EOL = System.getProperty("line.separator");
    private static final String ERROR_PREFIX = "error: ";
    private static final String WARNING_PREFIX = "warning: ";

    private JavacErrorMessagesParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompilerError> parseMessages(String input) {
        ArrayList<CompilerError> arrayList;
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        BufferedReader reader = new BufferedReader(new StringReader(input));
        try {
            String line;
            StringBuilder errorBuffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty() || Character.isDigit(line.charAt(0))) continue;
                if (errorBuffer.length() > 0 && !Character.isWhitespace(line.charAt(0))) {
                    errors.add(JavacErrorMessagesParser.parseMessage(errorBuffer.toString()));
                    errorBuffer.setLength(0);
                }
                errorBuffer.append(line).append(EOL);
            }
            if (errorBuffer.length() > 0) {
                errors.add(JavacErrorMessagesParser.parseMessage(errorBuffer.toString()));
            }
            arrayList = errors;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return arrayList;
    }

    public static CompilerError parseMessage(String message) {
        StringTokenizer tokens = new StringTokenizer(message, ":");
        boolean isError = true;
        try {
            int endColumn;
            String file = tokens.nextToken();
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(tokens.nextToken());
            StringBuilder buffer = new StringBuilder();
            String description = tokens.nextToken(EOL).substring(2);
            if (description.startsWith(ERROR_PREFIX)) {
                description = description.substring(ERROR_PREFIX.length());
            } else if (description.startsWith(WARNING_PREFIX)) {
                isError = false;
                description = description.substring(WARNING_PREFIX.length());
            }
            buffer.append(description);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            int startColumn = pointer.indexOf("^");
            int n = endColumn = context == null ? startColumn : context.indexOf(" ", startColumn);
            if (endColumn == -1) {
                endColumn = context.length();
            }
            if (tokens.hasMoreTokens()) {
                do {
                    buffer.append(EOL).append(tokens.nextToken(EOL));
                } while (tokens.hasMoreTokens());
            }
            return new CompilerError(file, isError, line, startColumn, line, endColumn, buffer.toString());
        }
        catch (NoSuchElementException e) {
            return new CompilerError("no more tokens - could not parse error message: " + message, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerError("could not parse error message: " + message, isError);
        }
        catch (Exception e) {
            return new CompilerError("could not parse error message: " + message, isError);
        }
    }
}

