/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.expression;

import java.math.BigInteger;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.Store;
import org.checkerframework.nullaway.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.nullaway.dataflow.expression.JavaExpression;
import org.checkerframework.nullaway.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.nullaway.javacutil.AnnotationProvider;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.TypesUtils;

public class ValueLiteral
extends JavaExpression {
    protected final @Nullable Object value;
    private final BigInteger NEGATIVE_LONG_MIN_VALUE = new BigInteger("9223372036854775808");

    public ValueLiteral(TypeMirror type, ValueLiteralNode node) {
        super(type);
        this.value = node.getValue();
    }

    public ValueLiteral(TypeMirror type, Object value) {
        super(type);
        this.value = value;
    }

    public ValueLiteral negate() {
        if (TypesUtils.isIntegralPrimitive(this.type)) {
            if (this.value == null) {
                throw new BugInCF("null value of integral type " + this.type);
            }
            return new ValueLiteral(this.type, this.negateBoxedPrimitive(this.value));
        }
        throw new BugInCF(String.format("cannot negate: %s type=%s", this, this.type));
    }

    private Object negateBoxedPrimitive(Object o) {
        if (this.value instanceof Byte) {
            return -((Byte)this.value).byteValue();
        }
        if (this.value instanceof Short) {
            return -((Short)this.value).shortValue();
        }
        if (this.value instanceof Integer) {
            return -((Integer)this.value).intValue();
        }
        if (this.value instanceof Long) {
            return -((Long)this.value).longValue();
        }
        if (this.value instanceof Float) {
            return Float.valueOf(-((Float)this.value).floatValue());
        }
        if (this.value instanceof Double) {
            return -((Double)this.value).doubleValue();
        }
        if (this.value instanceof BigInteger) {
            assert (this.value.equals(this.NEGATIVE_LONG_MIN_VALUE));
            return Long.MIN_VALUE;
        }
        throw new BugInCF("Cannot be negated: " + o + " " + o.getClass());
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        return this.getClass() == clazz;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return true;
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return true;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return true;
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        return this.equals(je);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ValueLiteral)) {
            return false;
        }
        ValueLiteral other = (ValueLiteral)obj;
        return this.type.toString().equals(other.type.toString()) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        if (TypesUtils.isString(this.type)) {
            return "\"" + this.value + "\"";
        }
        if (this.type.getKind() == TypeKind.LONG) {
            assert (this.value != null) : "@AssumeAssertion(nullness): invariant";
            return this.value.toString() + "L";
        }
        if (this.type.getKind() == TypeKind.CHAR) {
            return "'" + this.value + "'";
        }
        return this.value == null ? "null" : this.value.toString();
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type.toString());
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitValueLiteral(this, p);
    }
}

