/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.javacutil;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;
import org.checkerframework.nullaway.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.signature.qual.BinaryName;
import org.checkerframework.nullaway.checker.signature.qual.CanonicalName;
import org.checkerframework.nullaway.javacutil.AnnotationUtils;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.SystemUtil;
import org.checkerframework.nullaway.javacutil.TypesUtils;
import org.checkerframework.nullaway.org.plumelib.util.CollectionsPlume;

public class ElementUtils {
    private static final Set<ElementKind> typeElementKinds = EnumSet.noneOf(ElementKind.class);
    private static @MonotonicNonNull Method getRecordComponentsMethod;

    private ElementUtils() {
        throw new AssertionError((Object)"Class ElementUtils cannot be instantiated.");
    }

    @Deprecated
    public static @Nullable TypeElement enclosingClass(Element elem) {
        return ElementUtils.enclosingTypeElement(elem);
    }

    public static @Nullable TypeElement enclosingTypeElement(Element elem) {
        Element result;
        for (result = elem; result != null && !ElementUtils.isTypeElement(result); result = result.getEnclosingElement()) {
        }
        return (TypeElement)result;
    }

    public static @Nullable TypeElement strictEnclosingTypeElement(Element elem) {
        Element enclosingElement = elem.getEnclosingElement();
        if (enclosingElement == null) {
            return null;
        }
        return ElementUtils.enclosingTypeElement(enclosingElement);
    }

    public static TypeElement toplevelEnclosingTypeElement(Element element) {
        TypeElement result = ElementUtils.enclosingTypeElement(element);
        if (result == null) {
            return (TypeElement)element;
        }
        TypeElement enclosing = ElementUtils.strictEnclosingTypeElement(result);
        while (enclosing != null) {
            result = enclosing;
            enclosing = ElementUtils.strictEnclosingTypeElement(enclosing);
        }
        return result;
    }

    public static @BinaryName String getEnclosingClassName(ExecutableElement executableElement) {
        return ElementUtils.getBinaryName(((Symbol.MethodSymbol)executableElement).enclClass());
    }

    public static @BinaryName String getEnclosingClassName(VariableElement variableElement) {
        TypeElement enclosingType = ElementUtils.enclosingTypeElement(variableElement);
        if (enclosingType == null) {
            throw new BugInCF("enclosingTypeElement(%s) is null", variableElement);
        }
        return ElementUtils.getBinaryName(enclosingType);
    }

    public static PackageElement enclosingPackage(Element elem) {
        Element result = elem;
        while (result != null && result.getKind() != ElementKind.PACKAGE) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (PackageElement)result;
    }

    public static @Nullable PackageElement parentPackage(PackageElement elem, Elements e) {
        int dotPos;
        String fqnstart = elem.getQualifiedName().toString();
        String fqn = fqnstart;
        if (fqn != null && !fqn.isEmpty() && (dotPos = fqn.lastIndexOf(46)) != -1) {
            return e.getPackageElement(fqn.substring(0, dotPos));
        }
        return null;
    }

    public static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isEffectivelyFinal(Element element) {
        Symbol sym = (Symbol)element;
        if (sym.getEnclosingElement().getKind() == ElementKind.METHOD && (sym.getEnclosingElement().flags() & 0x400L) != 0L) {
            return true;
        }
        return (sym.flags() & 0x20000000010L) != 0L;
    }

    public static TypeMirror getType(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            return ((ExecutableElement)element).getReturnType();
        }
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            return ElementUtils.enclosingClass(element).asType();
        }
        return element.asType();
    }

    public static @Nullable Name getQualifiedClassName(Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            PackageElement elem = (PackageElement)element;
            return elem.getQualifiedName();
        }
        TypeElement elem = ElementUtils.enclosingClass(element);
        if (elem == null) {
            return null;
        }
        return elem.getQualifiedName();
    }

    public static String getQualifiedName(Element elt) {
        if (elt.getKind() == ElementKind.PACKAGE || ElementUtils.isTypeElement(elt)) {
            Name n = ElementUtils.getQualifiedClassName(elt);
            if (n == null) {
                return "Unexpected element: " + elt;
            }
            return n.toString();
        }
        return ElementUtils.getQualifiedName(elt.getEnclosingElement()) + "." + elt;
    }

    public static @BinaryName String getBinaryName(TypeElement te) {
        Element enclosing = te.getEnclosingElement();
        String simpleName = te.getSimpleName().toString();
        if (enclosing == null) {
            return simpleName;
        }
        if (ElementUtils.isTypeElement(enclosing)) {
            return ElementUtils.getBinaryName((TypeElement)enclosing) + "$" + simpleName;
        }
        if (enclosing.getKind() == ElementKind.PACKAGE) {
            PackageElement pe = (PackageElement)enclosing;
            if (pe.isUnnamed()) {
                return simpleName;
            }
            return pe.getQualifiedName() + "." + simpleName;
        }
        return ((Symbol.ClassSymbol)te).flatName().toString();
    }

    public static String getSimpleSignature(ExecutableElement element) {
        StringJoiner sj = new StringJoiner(",", element.getSimpleName() + "(", ")");
        Iterator<? extends VariableElement> i = element.getParameters().iterator();
        while (i.hasNext()) {
            sj.add(TypesUtils.simpleTypeName(i.next().asType()));
        }
        return sj.toString();
    }

    public static CharSequence getSimpleNameOrDescription(ExecutableElement element) {
        Name result = element.getSimpleName();
        switch (result.toString()) {
            case "<init>": {
                return element.getEnclosingElement().getSimpleName();
            }
            case "<clinit>": {
                return "class initializer";
            }
        }
        return result;
    }

    public static boolean isObject(TypeElement element) {
        return element.getQualifiedName().contentEquals("java.lang.Object");
    }

    public static boolean isString(TypeElement element) {
        return element.getQualifiedName().contentEquals("java.lang.String");
    }

    public static boolean isCompileTimeConstant(Element elt) {
        return elt != null && (elt.getKind() == ElementKind.FIELD || elt.getKind() == ElementKind.LOCAL_VARIABLE) && ((VariableElement)elt).getConstantValue() != null;
    }

    public static boolean isElementFromSourceCode(@Nullable Element element) {
        if (element == null) {
            return false;
        }
        TypeElement enclosingClass = ElementUtils.enclosingClass(element);
        if (enclosingClass == null) {
            throw new BugInCF("enclosingClass(%s) is null", element);
        }
        return ElementUtils.isElementFromSourceCodeImpl((Symbol.ClassSymbol)enclosingClass);
    }

    private static boolean isElementFromSourceCodeImpl(Symbol.ClassSymbol symbol) {
        return symbol.sourcefile != null && symbol.sourcefile.getKind() == JavaFileObject.Kind.SOURCE && symbol.sourcefile.toUri().toString().startsWith("file:");
    }

    public static boolean isElementFromByteCode(@Nullable Element elt) {
        if (elt == null) {
            return false;
        }
        if (elt instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clss = (Symbol.ClassSymbol)elt;
            if (null != clss.classfile) {
                return clss.classfile.getKind() == JavaFileObject.Kind.CLASS;
            }
            return elt.asType().getKind().isPrimitive();
        }
        return ElementUtils.isElementFromByteCode(elt.getEnclosingElement());
    }

    public static String getSourceFilePath(TypeElement element) {
        return ((Symbol.ClassSymbol)element).sourcefile.toUri().getPath();
    }

    public static @Nullable VariableElement findFieldInType(TypeElement type, String name) {
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!field.getSimpleName().contentEquals(name)) continue;
            return field;
        }
        return null;
    }

    public static Set<VariableElement> findFieldsInType(TypeElement type, Collection<String> names) {
        HashSet<VariableElement> results = new HashSet<VariableElement>();
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!names.contains(field.getSimpleName().toString())) continue;
            results.add(field);
        }
        return results;
    }

    public static Set<VariableElement> findFieldsInTypeOrSuperType(TypeMirror type, Collection<String> names) {
        int origCardinality = names.size();
        HashSet<VariableElement> elements = new HashSet<VariableElement>();
        ElementUtils.findFieldsInTypeOrSuperType(type, names, elements);
        if (origCardinality != names.size() + elements.size()) {
            throw new BugInCF("Bad sizes: %d != %d + %d", origCardinality, names.size(), elements.size());
        }
        return elements;
    }

    private static void findFieldsInTypeOrSuperType(TypeMirror type, Collection<String> notFound, Set<VariableElement> foundFields) {
        if (TypesUtils.isObject(type)) {
            return;
        }
        TypeElement elt = TypesUtils.getTypeElement(type);
        assert (elt != null) : "@AssumeAssertion(nullness): assumption";
        Set<VariableElement> fieldElts = ElementUtils.findFieldsInType(elt, notFound);
        for (VariableElement field : new HashSet<VariableElement>(fieldElts)) {
            if (!field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                notFound.remove(field.getSimpleName().toString());
                continue;
            }
            fieldElts.remove(field);
        }
        foundFields.addAll(fieldElts);
        if (!notFound.isEmpty()) {
            ElementUtils.findFieldsInTypeOrSuperType(elt.getSuperclass(), notFound, foundFields);
        }
    }

    public static boolean isError(Element element) {
        return element.getClass().getName() == "com.sun.tools.javac.comp.Resolve$SymbolNotFoundError";
    }

    public static boolean hasReceiver(Element element) {
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            TypeMirror t2 = element.getEnclosingElement().asType();
            return TypesUtils.hasEnclosingType(t2);
        }
        if (element.getKind() == ElementKind.FIELD) {
            if (ElementUtils.isStatic(element) || element.getEnclosingElement().getKind().isInterface()) {
                return false;
            }
            return !element.getSimpleName().contentEquals("this");
        }
        return element.getKind() == ElementKind.METHOD && !ElementUtils.isStatic(element);
    }

    public static @Nullable TypeElement getSuperClass(TypeElement typeElt) {
        TypeMirror superTypeMirror;
        try {
            superTypeMirror = typeElt.getSuperclass();
        }
        catch (Symbol.CompletionFailure cf) {
            return null;
        }
        if (superTypeMirror == null || superTypeMirror.getKind() == TypeKind.NONE) {
            return null;
        }
        return (TypeElement)((DeclaredType)superTypeMirror).asElement();
    }

    public static List<TypeElement> getSuperTypes(TypeElement type, Elements elements) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeElement> superelems = new ArrayList<TypeElement>();
        ArrayDeque<TypeElement> stack = new ArrayDeque<TypeElement>();
        stack.push(type);
        while (!stack.isEmpty()) {
            TypeElement current = (TypeElement)stack.pop();
            TypeElement supercls = ElementUtils.getSuperClass(current);
            if (supercls != null && !superelems.contains(supercls)) {
                stack.push(supercls);
                superelems.add(supercls);
            }
            for (TypeMirror typeMirror : current.getInterfaces()) {
                TypeElement superitf = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (superelems.contains(superitf)) continue;
                stack.push(superitf);
                superelems.add(superitf);
            }
        }
        TypeElement jlobject = elements.getTypeElement("java.lang.Object");
        if (!superelems.contains(jlobject)) {
            superelems.add(jlobject);
        }
        return Collections.unmodifiableList(superelems);
    }

    public static List<VariableElement> getAllFieldsIn(TypeElement type, Elements elements) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>(ElementFilter.fieldsIn(type.getEnclosedElements()));
        List<TypeElement> alltypes = ElementUtils.getSuperTypes(type, elements);
        for (TypeElement atype : alltypes) {
            fields.addAll(ElementFilter.fieldsIn(atype.getEnclosedElements()));
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<ExecutableElement> getAllMethodsIn(TypeElement type, Elements elements) {
        ArrayList<ExecutableElement> meths = new ArrayList<ExecutableElement>(ElementFilter.methodsIn(type.getEnclosedElements()));
        List<TypeElement> alltypes = ElementUtils.getSuperTypes(type, elements);
        for (TypeElement atype : alltypes) {
            meths.addAll(ElementFilter.methodsIn(atype.getEnclosedElements()));
        }
        return Collections.unmodifiableList(meths);
    }

    public static List<TypeElement> getAllTypeElementsIn(TypeElement type) {
        return ElementFilter.typesIn(type.getEnclosedElements());
    }

    @Deprecated
    public static Set<ElementKind> classElementKinds() {
        return ElementUtils.typeElementKinds();
    }

    public static Set<ElementKind> typeElementKinds() {
        return typeElementKinds;
    }

    @Deprecated
    public static boolean isClassElement(Element element) {
        return ElementUtils.isTypeElement(element);
    }

    public static boolean isTypeElement(Element element) {
        return ElementUtils.typeElementKinds().contains((Object)element.getKind());
    }

    public static boolean isTypeDeclaration(Element elt) {
        return ElementUtils.isClassElement(elt) || elt.getKind() == ElementKind.TYPE_PARAMETER;
    }

    public static boolean isBindingVariable(Element element) {
        return "BINDING_VARIABLE".equals(element.getKind().name());
    }

    public static boolean isRecordAccessor(ExecutableElement methodElement) {
        TypeElement enclosing = (TypeElement)methodElement.getEnclosingElement();
        if (enclosing.getKind().toString().equals("RECORD")) {
            String methodName = methodElement.getSimpleName().toString();
            List<? extends Element> encloseds = enclosing.getEnclosedElements();
            for (Element element : encloseds) {
                if (!element.getKind().toString().equals("RECORD_COMPONENT") || !element.getSimpleName().toString().equals(methodName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchesElement(ExecutableElement method, String methodName, Class<?> ... parameters) {
        if (!method.getSimpleName().contentEquals(methodName)) {
            return false;
        }
        if (method.getParameters().size() != parameters.length) {
            return false;
        }
        for (int i = 0; i < method.getParameters().size(); ++i) {
            if (method.getParameters().get(i).asType().toString().equals(parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isMethod(ExecutableElement questioned, ExecutableElement method, ProcessingEnvironment env) {
        TypeElement enclosing = (TypeElement)questioned.getEnclosingElement();
        return questioned.equals(method) || env.getElementUtils().overrides(questioned, method, enclosing);
    }

    public static boolean hasAnnotation(Element element, String annotName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!AnnotationUtils.areSameByName(annotationMirror, annotName)) continue;
            return true;
        }
        return false;
    }

    public static TypeElement getTypeElement(ProcessingEnvironment processingEnv, Class<?> clazz) {
        @CanonicalName String className = clazz.getCanonicalName();
        if (className == null) {
            throw new Error("Anonymous class " + clazz + " has no canonical name");
        }
        return processingEnv.getElementUtils().getTypeElement(className);
    }

    public static List<TypeElement> getAllSupertypes(TypeElement type, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        com.sun.tools.javac.code.Types javacTypes = com.sun.tools.javac.code.Types.instance(ctx);
        return CollectionsPlume.mapList(t2 -> (TypeElement)((Object)t2.tsym), javacTypes.closure(((Symbol)((Object)type)).type));
    }

    public static Set<? extends ExecutableElement> getOverriddenMethods(ExecutableElement m4, Types types) {
        JavacTypes t2 = (JavacTypes)types;
        return t2.getOverriddenMethods(m4);
    }

    public static boolean inSameClass(Element e1, Element e2) {
        return e1.getEnclosingElement().equals(e2.getEnclosingElement());
    }

    public static ElementKind getKindRecordAsClass(Element elt) {
        ElementKind kind = elt.getKind();
        if (kind.name().equals("RECORD")) {
            kind = ElementKind.CLASS;
        }
        return kind;
    }

    public static List<? extends Element> getRecordComponents(TypeElement element) {
        try {
            return (List)getRecordComponentsMethod.invoke((Object)element, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new Error("Cannot call TypeElement.getRecordComponents()", e);
        }
    }

    public static boolean isCompactCanonicalRecordConstructor(Element elt) {
        if (!(elt instanceof Symbol)) {
            return false;
        }
        return elt.getKind() == ElementKind.CONSTRUCTOR && (((Symbol)elt).flags() & 0x8000000000000L) != 0L;
    }

    static {
        for (ElementKind kind : ElementKind.values()) {
            if (!kind.isClass() && !kind.isInterface()) continue;
            typeElementKinds.add(kind);
        }
        getRecordComponentsMethod = null;
        if (SystemUtil.jreVersion >= 16) {
            try {
                getRecordComponentsMethod = TypeElement.class.getMethod("getRecordComponents", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new Error("Cannot find TypeElement.getRecordComponents()", e);
            }
        }
    }
}

