/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.node;

import com.sun.source.tree.InstanceOfTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.nullaway.javacutil.TypesUtils;

public class InstanceOfNode
extends Node {
    protected final Node operand;
    protected final TypeMirror refType;
    protected final InstanceOfTree tree;
    protected final @Nullable LocalVariableNode bindingVariable;
    protected final Types types;

    public InstanceOfNode(InstanceOfTree tree, Node operand, TypeMirror refType, Types types) {
        this(tree, operand, null, refType, types);
    }

    public InstanceOfNode(InstanceOfTree tree, Node operand, @Nullable LocalVariableNode bindingVariable, TypeMirror refType, Types types) {
        super(types.getPrimitiveType(TypeKind.BOOLEAN));
        this.tree = tree;
        this.operand = operand;
        this.refType = refType;
        this.types = types;
        this.bindingVariable = bindingVariable;
    }

    public Node getOperand() {
        return this.operand;
    }

    public @Nullable LocalVariableNode getBindingVariable() {
        return this.bindingVariable;
    }

    public TypeMirror getRefType() {
        return this.refType;
    }

    @Override
    public InstanceOfTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitInstanceOf(this, p);
    }

    public String toString() {
        return "(" + this.getOperand() + " instanceof " + TypesUtils.simpleTypeName(this.getRefType()) + (this.bindingVariable == null ? "" : " " + this.getBindingVariable()) + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof InstanceOfNode)) {
            return false;
        }
        InstanceOfNode other = (InstanceOfNode)obj;
        return this.getOperand().equals(other.getOperand()) && this.types.isSameType(this.getRefType(), other.getRefType());
    }

    public int hashCode() {
        return Objects.hash(InstanceOfNode.class, this.getOperand());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

