/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.javacutil;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;

public class SystemUtil {
    public static final int jreVersion = SystemUtil.getJreVersion();

    private SystemUtil() {
        throw new Error("Do not instantiate.");
    }

    public static @Nullable Integer available(InputStream is) {
        try {
            return is.available();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable Boolean isWhitespaceOnly(InputStream is, int readLimit) {
        if (!is.markSupported()) {
            return null;
        }
        try {
            is.mark(readLimit * 4);
            for (int bytesRead = 0; bytesRead < readLimit; ++bytesRead) {
                int nextCodePoint = SystemUtil.readCodePoint(is);
                if (nextCodePoint == -1) {
                    Boolean bl = true;
                    return bl;
                }
                if (Character.isWhitespace(nextCodePoint)) continue;
                Boolean bl = false;
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        finally {
            try {
                is.reset();
            }
            catch (IOException iOException) {}
        }
    }

    public static int readCodePoint(InputStream is) {
        try {
            int nextByte = is.read();
            if (nextByte == -1) {
                return -1;
            }
            byte firstByte = (byte)nextByte;
            int byteCount = SystemUtil.getByteCount(firstByte);
            if (byteCount == 1) {
                return nextByte;
            }
            byte[] utf8Bytes = new byte[byteCount];
            utf8Bytes[0] = (byte)nextByte;
            for (int i = 1; i < byteCount; ++i) {
                nextByte = is.read();
                utf8Bytes[i] = (byte)nextByte;
            }
            int codePoint = new String(utf8Bytes, StandardCharsets.UTF_8).codePointAt(0);
            return codePoint;
        }
        catch (IOException e) {
            throw new Error("input stream = " + is, e);
        }
    }

    private static int getByteCount(byte b) throws IllegalArgumentException {
        if (b >= 0) {
            return 1;
        }
        if (b >= -64 && b <= -33) {
            return 2;
        }
        if (b >= -32 && b <= -17) {
            return 3;
        }
        if (b >= -16 && b <= -9) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    @Deprecated
    public static int getJreVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2, 3));
        }
        Pattern newVersionPattern = Pattern.compile("^(\\d+).*$");
        Matcher newVersionMatcher = newVersionPattern.matcher(version);
        if (newVersionMatcher.matches()) {
            String v = newVersionMatcher.group(1);
            assert (v != null) : "@AssumeAssertion(nullness): inspection";
            return Integer.parseInt(v);
        }
        throw new RuntimeException("Could not determine version from property java.version=" + version);
    }

    public static @Nullable String getReleaseValue(ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        Options options = Options.instance(ctx);
        return options.get(Option.RELEASE);
    }

    public static @Nullable String getToolsJar() {
        File toolsJarFile;
        if (jreVersion > 8) {
            return null;
        }
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            String javaHomeProperty = System.getProperty("java.home");
            if (javaHomeProperty.endsWith(File.separator + "jre")) {
                javaHome = javaHomeProperty.substring(javaHomeProperty.length() - 4);
            } else {
                throw new Error("Can't infer Java home; java.home=" + javaHomeProperty);
            }
        }
        if (!(toolsJarFile = new File(new File(javaHome, "lib"), "tools.jar")).exists()) {
            throw new Error(String.format("File does not exist: %s ; JAVA_HOME=%s ; java.home=%s", toolsJarFile, javaHome, System.getProperty("java.home")));
        }
        return toolsJarFile.toString();
    }
}

