/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.javacutil;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.interning.qual.PolyInterned;
import org.checkerframework.nullaway.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.signature.qual.FullyQualifiedName;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.ElementUtils;
import org.checkerframework.nullaway.javacutil.SystemUtil;
import org.checkerframework.nullaway.javacutil.TypeAnnotationUtils;
import org.checkerframework.nullaway.javacutil.TypesUtils;
import org.checkerframework.nullaway.javacutil.UserError;
import org.checkerframework.nullaway.org.plumelib.util.CollectionsPlume;
import org.checkerframework.nullaway.org.plumelib.util.UniqueIdMap;

public final class TreeUtils {
    public static final UniqueIdMap<Tree> treeUids;
    private static final boolean atLeastJava12;
    private static final boolean atLeastJava13;
    private static final boolean atLeastJava16;
    private static final boolean atLeastJava21;
    private static final @Nullable Method CASETREE_GETEXPRESSION;
    private static final @Nullable Method CASETREE_GETEXPRESSIONS;
    private static final @Nullable Method CASETREE_GETBODY;
    private static final @Nullable Method SWITCHEXPRTREE_GETEXPRESSION;
    private static final @Nullable Method SWITCHEXPRTREE_GETCASES;
    private static final @Nullable Method CASETREE_GETKIND;
    private static final @Nullable Enum<?> CASETREE_CASEKIND_RULE;
    private static final @Nullable Method YIELDTREE_GETVALUE;
    private static final @Nullable Method INSTANCEOFTREE_GETPATTERN;
    private static final @Nullable Method BINDINGPATTERNTREE_GETVARIABLE;
    private static final @Nullable Method TREEMAKER_SELECT;
    private static final long Flags_RECORD = 0x2000000000000000L;
    private static final Set<Tree.Kind> BINARY_COMPARISON_TREE_KINDS;
    private static final Set<Tree.Kind> classTreeKinds;
    private static final Set<Tree.Kind> classAndMethodTreeKinds;
    private static final Set<Tree.Kind> declarationTreeKinds;
    private static final Set<Tree.Kind> typeTreeKinds;

    private TreeUtils() {
        throw new AssertionError((Object)"Class TreeUtils cannot be instantiated.");
    }

    public static boolean isConstructor(MethodTree tree) {
        return tree.getName().contentEquals("<init>");
    }

    public static boolean isSuperConstructorCall(MethodInvocationTree tree) {
        return TreeUtils.isNamedMethodCall("super", tree);
    }

    public static boolean isThisConstructorCall(MethodInvocationTree tree) {
        return TreeUtils.isNamedMethodCall("this", tree);
    }

    private static boolean isNamedMethodCall(String name, MethodInvocationTree tree) {
        return TreeUtils.getMethodName(tree.getMethodSelect()).contentEquals(name);
    }

    public static boolean isSelfAccess(ExpressionTree tree) {
        ExpressionTree tr = TreeUtils.withoutParens(tree);
        if (tr.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return false;
        }
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            tr = ((MethodInvocationTree)tree).getMethodSelect();
        }
        if ((tr = TreeUtils.withoutParens(tr)).getKind() == Tree.Kind.TYPE_CAST) {
            tr = ((TypeCastTree)tr).getExpression();
        }
        if ((tr = TreeUtils.withoutParens(tr)).getKind() == Tree.Kind.IDENTIFIER) {
            return true;
        }
        if (tr.getKind() == Tree.Kind.MEMBER_SELECT && (tr = ((MemberSelectTree)tr).getExpression()).getKind() == Tree.Kind.IDENTIFIER) {
            javax.lang.model.element.Name ident = ((IdentifierTree)tr).getName();
            return ident.contentEquals("this") || ident.contentEquals("super");
        }
        return false;
    }

    public static @PolyInterned ExpressionTree withoutParens(@PolyInterned ExpressionTree tree) {
        ExpressionTree t2 = tree;
        while (t2.getKind() == Tree.Kind.PARENTHESIZED) {
            t2 = ((ParenthesizedTree)t2).getExpression();
        }
        return t2;
    }

    public static @PolyInterned ExpressionTree withoutParensOrCasts(@PolyInterned ExpressionTree tree) {
        ExpressionTree t2 = TreeUtils.withoutParens(tree);
        while (t2.getKind() == Tree.Kind.TYPE_CAST) {
            t2 = TreeUtils.withoutParens(((TypeCastTree)t2).getExpression());
        }
        return t2;
    }

    public static @Nullable TypeElement elementFromDeclaration(ClassTree tree) {
        TypeElement result = (TypeElement)((Object)TreeInfo.symbolFor((JCTree)((Object)tree)));
        return result;
    }

    @Deprecated
    @Pure
    public static @Nullable TypeElement elementFromTree(ClassTree tree) {
        return TreeUtils.elementFromDeclaration(tree);
    }

    @Deprecated
    @Pure
    public static @Nullable TypeElement elementFromUse(ClassTree tree) {
        return TreeUtils.elementFromDeclaration(tree);
    }

    @Pure
    @Deprecated
    public static @Nullable Element elementFromDeclaration(ExpressionTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Pure
    public static @Nullable Element elementFromTree(ExpressionTree tree) {
        return TreeUtils.elementFromTree((Tree)tree);
    }

    @Pure
    public static Element elementFromUse(ExpressionTree tree) {
        Element result = TreeUtils.elementFromTree(tree);
        if (result == null) {
            throw new BugInCF("argument to elementFromUse() has no element: %s [%s]", tree, tree.getClass());
        }
        return result;
    }

    @Pure
    public static VariableElement variableElementFromUse(ExpressionTree tree) {
        VariableElement result = TreeUtils.variableElementFromTree(tree);
        if (result == null) {
            throw new BugInCF("null element for %s [%s]", tree, tree.getClass());
        }
        return result;
    }

    @Deprecated
    @Pure
    public static @Nullable Element elementFromDeclaration(MemberSelectTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Deprecated
    @Pure
    public static @Nullable Element elementFromTree(MemberSelectTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Pure
    public static Element elementFromUse(MemberSelectTree tree) {
        Symbol result = TreeInfo.symbolFor((JCTree)((Object)tree));
        if (result == null) {
            throw new BugInCF("tree = " + tree);
        }
        return result;
    }

    @Deprecated
    @Pure
    public static @Nullable ExecutableElement elementFromDeclaration(MethodInvocationTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Deprecated
    @Pure
    public static @Nullable ExecutableElement elementFromTree(MethodInvocationTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Pure
    public static ExecutableElement elementFromUse(MethodInvocationTree tree) {
        Symbol result = TreeInfo.symbolFor((JCTree)((Object)tree));
        if (result == null) {
            throw new BugInCF("tree = %s [%s]", tree, tree.getClass());
        }
        if (!(result instanceof ExecutableElement)) {
            throw new BugInCF("Method elements should be ExecutableElement. Found: %s [%s]", result, result.getClass());
        }
        return (ExecutableElement)((Object)result);
    }

    public static @Nullable ExecutableElement elementFromDeclaration(MethodTree tree) {
        ExecutableElement result = (ExecutableElement)((Object)TreeInfo.symbolFor((JCTree)((Object)tree)));
        return result;
    }

    @Deprecated
    @Pure
    public static @Nullable ExecutableElement elementFromTree(MethodTree tree) {
        return TreeUtils.elementFromDeclaration(tree);
    }

    @Deprecated
    @Pure
    public static @Nullable ExecutableElement elementFromUse(MethodTree tree) {
        return TreeUtils.elementFromDeclaration(tree);
    }

    @Deprecated
    @Pure
    public static ExecutableElement elementFromDeclaration(NewClassTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Deprecated
    @Pure
    public static ExecutableElement elementFromTree(NewClassTree tree) {
        return TreeUtils.elementFromUse(tree);
    }

    @Pure
    public static ExecutableElement elementFromUse(NewClassTree tree) {
        Symbol result = TreeInfo.symbolFor((JCTree)((Object)tree));
        if (result == null) {
            throw new BugInCF("null element for %s", tree);
        }
        if (!(result instanceof ExecutableElement)) {
            throw new BugInCF("Constructor elements should be ExecutableElement. Found: %s [%s]", result, result.getClass());
        }
        return (ExecutableElement)((Object)result);
    }

    public static @Nullable VariableElement elementFromDeclaration(VariableTree tree) {
        VariableElement result = (VariableElement)((Object)TreeInfo.symbolFor((JCTree)((Object)tree)));
        return result;
    }

    @Deprecated
    @Pure
    public static @Nullable VariableElement elementFromTree(VariableTree tree) {
        return TreeUtils.elementFromDeclaration(tree);
    }

    @Deprecated
    @Pure
    public static @Nullable VariableElement elementFromUse(VariableTree tree) {
        return TreeUtils.elementFromDeclaration(tree);
    }

    @Pure
    public static VariableElement variableElementFromTree(Tree tree) {
        VariableElement result = (VariableElement)((Object)TreeInfo.symbolFor((JCTree)tree));
        if (result == null) {
            throw new BugInCF("null element for %s [%s]", tree, tree.getClass());
        }
        return result;
    }

    @Pure
    public static @Nullable Element elementFromTree(Tree tree) {
        if (tree == null) {
            throw new BugInCF("TreeUtils.elementFromTree: tree is null");
        }
        if (!(tree instanceof JCTree)) {
            throw new BugInCF("TreeUtils.elementFromTree: tree is not a valid Javac tree but a " + tree.getClass());
        }
        if (TreeUtils.isExpressionTree(tree)) {
            tree = TreeUtils.withoutParensOrCasts((ExpressionTree)tree);
        }
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return TreeInfo.symbol(((JCTree.JCMethodInvocation)tree).getMethodSelect());
            }
            case ASSIGNMENT: {
                return TreeInfo.symbol((JCTree)((Object)((AssignmentTree)tree).getVariable()));
            }
            case ARRAY_ACCESS: {
                return TreeUtils.elementFromTree(((ArrayAccessTree)tree).getExpression());
            }
            case NEW_CLASS: {
                return ((JCTree.JCNewClass)tree).constructor;
            }
            case MEMBER_REFERENCE: {
                ExecutableElement memberResult = (ExecutableElement)((Object)((JCTree.JCMemberReference)tree).sym);
                return memberResult;
            }
        }
        Symbol defaultResult = TreeUtils.isTypeDeclaration(tree) || tree.getKind() == Tree.Kind.VARIABLE || tree.getKind() == Tree.Kind.METHOD ? TreeInfo.symbolFor((JCTree)tree) : TreeInfo.symbol((JCTree)tree);
        return defaultResult;
    }

    public static ExecutableElement getSuperConstructor(NewClassTree newClassTree) {
        if (newClassTree.getClassBody() == null) {
            return TreeUtils.elementFromUse(newClassTree);
        }
        JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)newClassTree;
        JCTree.JCMethodDecl anonConstructor = (JCTree.JCMethodDecl)TreeInfo.declarationFor(jcNewClass.constructor, jcNewClass);
        assert (anonConstructor != null);
        assert (anonConstructor.body.stats.size() == 1);
        JCTree.JCExpressionStatement stmt = (JCTree.JCExpressionStatement)anonConstructor.body.stats.head;
        JCTree.JCMethodInvocation superInvok = (JCTree.JCMethodInvocation)stmt.expr;
        return (ExecutableElement)((Object)TreeInfo.symbol(superInvok.meth));
    }

    @Pure
    public static ExecutableType typeFromUse(MethodInvocationTree tree) {
        TypeMirror type = TreeUtils.typeOf(tree.getMethodSelect());
        if (!(type instanceof ExecutableType)) {
            throw new BugInCF("TreeUtils.typeFromUse(MethodInvocationTree): type of method select in method invocation should be ExecutableType. Found: %s", type);
        }
        return (ExecutableType)type;
    }

    @Pure
    public static ExecutableType typeFromUse(NewClassTree tree) {
        if (!(tree instanceof JCTree.JCNewClass)) {
            throw new BugInCF("TreeUtils.typeFromUse(NewClassTree): not a javac internal tree");
        }
        JCTree.JCNewClass newClassTree = (JCTree.JCNewClass)tree;
        Type type = newClassTree.constructorType;
        if (!(type instanceof ExecutableType)) {
            throw new BugInCF("TreeUtils.typeFromUse(NewClassTree): type of constructor in new class tree should be ExecutableType. Found: %s", type);
        }
        return (ExecutableType)((Object)type);
    }

    @Deprecated
    public static ExecutableElement constructor(NewClassTree tree) {
        return (ExecutableElement)((Object)((JCTree.JCNewClass)tree).constructor);
    }

    @EnsuresNonNullIf.List(value={@EnsuresNonNullIf(result=true, expression={"elementFromTree(#1)"}), @EnsuresNonNullIf(result=true, expression={"elementFromUse(#1)"})})
    @Pure
    public static boolean isUseOfElement(ExpressionTree tree) {
        ExpressionTree realnode = TreeUtils.withoutParens(tree);
        switch (realnode.getKind()) {
            case METHOD_INVOCATION: 
            case NEW_CLASS: 
            case IDENTIFIER: 
            case MEMBER_SELECT: {
                assert (TreeUtils.elementFromTree(tree) != null) : "@AssumeAssertion(nullness): inspection";
                assert (TreeUtils.elementFromUse(tree) != null) : "@AssumeAssertion(nullness): inspection";
                return true;
            }
        }
        return false;
    }

    public static boolean hasSyntheticArgument(NewClassTree tree) {
        if (tree.getClassBody() == null || tree.getEnclosingExpression() != null) {
            return false;
        }
        for (Tree tree2 : tree.getClassBody().getMembers()) {
            if (tree2.getKind() != Tree.Kind.METHOD || !TreeUtils.isConstructor((MethodTree)tree2)) continue;
            MethodTree methodTree = (MethodTree)tree2;
            StatementTree f = methodTree.getBody().getStatements().get(0);
            return TreeUtils.getReceiverTree(((ExpressionStatementTree)f).getExpression()) != null;
        }
        return false;
    }

    public static javax.lang.model.element.Name methodName(MethodInvocationTree tree) {
        ExpressionTree expr = tree.getMethodSelect();
        if (expr.getKind() == Tree.Kind.IDENTIFIER) {
            return ((IdentifierTree)expr).getName();
        }
        if (expr.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)expr).getIdentifier();
        }
        throw new BugInCF("TreeUtils.methodName: cannot be here: " + tree);
    }

    public static boolean containsThisConstructorInvocation(MethodTree tree) {
        if (!TreeUtils.isConstructor(tree) || tree.getBody().getStatements().isEmpty()) {
            return false;
        }
        StatementTree st = tree.getBody().getStatements().get(0);
        if (!(st instanceof ExpressionStatementTree) || !(((ExpressionStatementTree)st).getExpression() instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)((ExpressionStatementTree)st).getExpression();
        return "this".contentEquals(TreeUtils.methodName(invocation));
    }

    public static Tree firstStatement(Tree tree) {
        BlockTree block;
        Tree first = tree.getKind() == Tree.Kind.BLOCK ? ((block = (BlockTree)tree).getStatements().isEmpty() ? block : (Tree)block.getStatements().iterator().next()) : tree;
        return first;
    }

    public static boolean hasExplicitConstructor(ClassTree tree) {
        TypeElement elem = TreeUtils.elementFromDeclaration(tree);
        if (elem == null) {
            return false;
        }
        for (ExecutableElement constructorElt : ElementFilter.constructorsIn(elem.getEnclosedElements())) {
            if (TreeUtils.isSynthetic(constructorElt)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSynthetic(ExecutableElement ee) {
        Symbol.MethodSymbol ms = (Symbol.MethodSymbol)ee;
        long mod = ms.flags();
        return (mod & 0x1000001000L) != 0L;
    }

    public static boolean isSynthetic(MethodTree tree) {
        ExecutableElement ee = TreeUtils.elementFromDeclaration(tree);
        return ee != null && TreeUtils.isSynthetic(ee);
    }

    public static boolean isDiamondTree(Tree tree) {
        switch (tree.getKind()) {
            case ANNOTATED_TYPE: {
                return TreeUtils.isDiamondTree(((AnnotatedTypeTree)tree).getUnderlyingType());
            }
            case PARAMETERIZED_TYPE: {
                return ((ParameterizedTypeTree)tree).getTypeArguments().isEmpty();
            }
            case NEW_CLASS: {
                return TreeUtils.isDiamondTree(((NewClassTree)tree).getIdentifier());
            }
        }
        return false;
    }

    public static boolean isStringConcatenation(Tree tree) {
        return tree.getKind() == Tree.Kind.PLUS && TypesUtils.isString(TreeUtils.typeOf(tree));
    }

    public static boolean isStringCompoundConcatenation(CompoundAssignmentTree tree) {
        return tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT && TypesUtils.isString(TreeUtils.typeOf(tree));
    }

    public static boolean isVoidReturn(MethodTree tree) {
        return TreeUtils.typeOf(tree.getReturnType()).getKind() == TypeKind.VOID;
    }

    public static boolean isCompileTimeString(ExpressionTree tree) {
        if ((tree = TreeUtils.withoutParens(tree)) instanceof LiteralTree) {
            return true;
        }
        if (TreeUtils.isUseOfElement(tree)) {
            Element elt = TreeUtils.elementFromUse(tree);
            return ElementUtils.isCompileTimeConstant(elt);
        }
        if (TreeUtils.isStringConcatenation(tree)) {
            BinaryTree binOp = (BinaryTree)tree;
            return TreeUtils.isCompileTimeString(binOp.getLeftOperand()) && TreeUtils.isCompileTimeString(binOp.getRightOperand());
        }
        return false;
    }

    public static @Nullable ExpressionTree getReceiverTree(ExpressionTree expression) {
        ExpressionTree receiver;
        switch (expression.getKind()) {
            case METHOD_INVOCATION: {
                receiver = ((MethodInvocationTree)expression).getMethodSelect();
                if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
                    receiver = ((MemberSelectTree)receiver).getExpression();
                    break;
                }
                return null;
            }
            case NEW_CLASS: {
                receiver = ((NewClassTree)expression).getEnclosingExpression();
                break;
            }
            case ARRAY_ACCESS: {
                receiver = ((ArrayAccessTree)expression).getExpression();
                break;
            }
            case MEMBER_SELECT: {
                receiver = ((MemberSelectTree)expression).getExpression();
                if (!(receiver instanceof PrimitiveTypeTree)) break;
                return null;
            }
            case IDENTIFIER: {
                return null;
            }
            default: {
                return null;
            }
        }
        if (receiver == null) {
            return null;
        }
        return TreeUtils.withoutParens(receiver);
    }

    public static Set<Tree.Kind> classAndMethodTreeKinds() {
        return classAndMethodTreeKinds;
    }

    public static Set<Tree.Kind> classTreeKinds() {
        return classTreeKinds;
    }

    public static boolean isClassTree(Tree tree) {
        return TreeUtils.classTreeKinds().contains((Object)tree.getKind());
    }

    public static Set<Tree.Kind> declarationTreeKinds() {
        return declarationTreeKinds;
    }

    public static boolean isDeclarationTree(Tree tree) {
        return declarationTreeKinds.contains((Object)tree.getKind());
    }

    public static Set<Tree.Kind> typeTreeKinds() {
        return typeTreeKinds;
    }

    public static boolean isTypeTree(Tree tree) {
        return TreeUtils.typeTreeKinds().contains((Object)tree.getKind());
    }

    public static boolean isMethodInvocation(Tree tree, ExecutableElement method, ProcessingEnvironment env) {
        if (!(tree instanceof MethodInvocationTree)) {
            return false;
        }
        MethodInvocationTree methInvok = (MethodInvocationTree)tree;
        ExecutableElement invoked = TreeUtils.elementFromUse(methInvok);
        if (invoked == null) {
            return false;
        }
        return ElementUtils.isMethod(invoked, method, env);
    }

    public static boolean isMethodInvocation(Tree methodTree, List<ExecutableElement> methods, ProcessingEnvironment processingEnv) {
        if (!(methodTree instanceof MethodInvocationTree)) {
            return false;
        }
        for (ExecutableElement Method2 : methods) {
            if (!TreeUtils.isMethodInvocation(methodTree, Method2, processingEnv)) continue;
            return true;
        }
        return false;
    }

    public static ExecutableElement getMethod(Class<?> type, String methodName, int params, ProcessingEnvironment env) {
        String typeName = type.getCanonicalName();
        if (typeName == null) {
            throw new BugInCF("TreeUtils.getMethod: class %s has no canonical name", type);
        }
        return TreeUtils.getMethod(typeName, methodName, params, env);
    }

    public static ExecutableElement getMethod(@FullyQualifiedName String typeName, String methodName, int params, ProcessingEnvironment env) {
        List<ExecutableElement> methods = TreeUtils.getMethods(typeName, methodName, params, env);
        if (methods.size() == 1) {
            return methods.get(0);
        }
        throw new BugInCF("TreeUtils.getMethod(%s, %s, %d): expected 1 match, found %d", typeName, methodName, params, methods.size());
    }

    public static @Nullable ExecutableElement getMethodOrNull(@FullyQualifiedName String typeName, String methodName, int params, ProcessingEnvironment env) {
        List<ExecutableElement> methods = TreeUtils.getMethods(typeName, methodName, params, env);
        if (methods.size() == 0) {
            return null;
        }
        if (methods.size() == 1) {
            return methods.get(0);
        }
        throw new BugInCF("TreeUtils.getMethod(%s, %s, %d): expected 0 or 1 match, found %d", typeName, methodName, params, methods.size());
    }

    public static List<ExecutableElement> getMethods(@FullyQualifiedName String typeName, String methodName, int params, ProcessingEnvironment env) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>(1);
        TypeElement typeElt = env.getElementUtils().getTypeElement(typeName);
        if (typeElt == null) {
            throw new UserError("Configuration problem! Could not load type: " + typeName);
        }
        for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != params) continue;
            methods.add(exec);
        }
        return methods;
    }

    public static ExecutableElement getMethod(Class<?> type, String methodName, ProcessingEnvironment env, String ... paramTypes) {
        String typeName = type.getCanonicalName();
        if (typeName == null) {
            throw new BugInCF("TreeUtils.getMethod: class %s has no canonical name", type);
        }
        return TreeUtils.getMethod(typeName, methodName, env, paramTypes);
    }

    public static ExecutableElement getMethod(@FullyQualifiedName String typeName, String methodName, ProcessingEnvironment env, String ... paramTypes) {
        TypeElement typeElt = env.getElementUtils().getTypeElement(typeName);
        for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName) || exec.getParameters().size() != paramTypes.length) continue;
            boolean typesMatch = true;
            List<? extends VariableElement> params = exec.getParameters();
            for (int i = 0; i < paramTypes.length; ++i) {
                VariableElement ve = params.get(i);
                Type tm = TypeAnnotationUtils.unannotatedType(ve.asType());
                if (tm.toString().equals(paramTypes[i])) continue;
                typesMatch = false;
                break;
            }
            if (!typesMatch) continue;
            return exec;
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
            if (!exec.getSimpleName().contentEquals(methodName)) continue;
            candidates.add(TreeUtils.executableElementToString(exec));
        }
        if (candidates.isEmpty()) {
            for (ExecutableElement exec : ElementFilter.methodsIn(typeElt.getEnclosedElements())) {
                candidates.add(TreeUtils.executableElementToString(exec));
            }
        }
        throw new BugInCF("TreeUtils.getMethod: found no match for %s.%s(%s); candidates: %s", typeName, methodName, Arrays.toString(paramTypes), candidates);
    }

    private static String executableElementToString(ExecutableElement exec) {
        StringJoiner result = new StringJoiner(", ", exec.getSimpleName() + "(", ")");
        for (VariableElement variableElement : exec.getParameters()) {
            result.add(TypeAnnotationUtils.unannotatedType(variableElement.asType()).toString());
        }
        return result.toString();
    }

    public static boolean isExplicitThisDereference(ExpressionTree tree) {
        if (tree.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)tree).getName().contentEquals("this")) {
            return true;
        }
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree memSelTree = (MemberSelectTree)tree;
        return memSelTree.getIdentifier().contentEquals("this");
    }

    public static boolean isClassLiteral(Tree tree) {
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        return "class".equals(((MemberSelectTree)tree).getIdentifier().toString());
    }

    public static boolean isFieldAccess(Tree tree) {
        return TreeUtils.asFieldAccess(tree) != null;
    }

    public static @Nullable VariableElement asFieldAccess(Tree tree) {
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree memberSelect = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement(memberSelect)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(memberSelect);
            if (el.getKind().isField()) {
                return (VariableElement)el;
            }
        } else if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree ident = (IdentifierTree)tree;
            assert (TreeUtils.isUseOfElement(ident)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(ident);
            if (el.getKind().isField() && !ident.getName().contentEquals("this") && !ident.getName().contentEquals("super")) {
                return (VariableElement)el;
            }
        }
        return null;
    }

    public static String getFieldName(Tree tree) {
        assert (TreeUtils.isFieldAccess(tree));
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return mtree.getIdentifier().toString();
        }
        IdentifierTree itree = (IdentifierTree)tree;
        return itree.getName().toString();
    }

    public static boolean isMethodAccess(Tree tree) {
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree memberSelect = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement(memberSelect)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(memberSelect);
            return el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR;
        }
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            IdentifierTree ident = (IdentifierTree)tree;
            if (ident.getName().contentEquals("super") || ident.getName().contentEquals("this")) {
                return true;
            }
            assert (TreeUtils.isUseOfElement(ident)) : "@AssumeAssertion(nullness): tree kind";
            Element el = TreeUtils.elementFromUse(ident);
            return el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR;
        }
        return false;
    }

    public static String getMethodName(Tree tree) {
        assert (TreeUtils.isMethodAccess(tree));
        if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            MemberSelectTree mtree = (MemberSelectTree)tree;
            return mtree.getIdentifier().toString();
        }
        IdentifierTree itree = (IdentifierTree)tree;
        return itree.getName().toString();
    }

    public static boolean canHaveTypeAnnotation(Tree tree) {
        return ((JCTree)tree).type != null;
    }

    public static boolean isSpecificFieldAccess(Tree tree, VariableElement var) {
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memSel = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement(memSel)) : "@AssumeAssertion(nullness): tree kind";
            Element field = TreeUtils.elementFromUse(memSel);
            return field.equals(var);
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree idTree = (IdentifierTree)tree;
            assert (TreeUtils.isUseOfElement(idTree)) : "@AssumeAssertion(nullness): tree kind";
            Element field = TreeUtils.elementFromUse(idTree);
            return field.equals(var);
        }
        return false;
    }

    public static VariableElement getField(@FullyQualifiedName String typeName, String fieldName, ProcessingEnvironment env) {
        TypeElement mapElt = env.getElementUtils().getTypeElement(typeName);
        for (VariableElement var : ElementFilter.fieldsIn(mapElt.getEnclosedElements())) {
            if (!var.getSimpleName().contentEquals(fieldName)) continue;
            return var;
        }
        throw new BugInCF("TreeUtils.getField: shouldn't be here");
    }

    public static boolean isExpressionTree(Tree tree) {
        return tree instanceof ExpressionTree;
    }

    public static boolean isEnumSuperCall(MethodInvocationTree tree) {
        ExecutableElement ex = TreeUtils.elementFromUse(tree);
        assert (ex != null) : "@AssumeAssertion(nullness): tree kind";
        javax.lang.model.element.Name name = ElementUtils.getQualifiedClassName(ex);
        assert (name != null) : "@AssumeAssertion(nullness): assumption";
        boolean correctClass = "java.lang.Enum".contentEquals(name);
        boolean correctMethod = "<init>".contentEquals(ex.getSimpleName());
        return correctClass && correctMethod;
    }

    public static boolean isTypeDeclaration(Tree tree) {
        return TreeUtils.isClassTree(tree) || tree.getKind() == Tree.Kind.TYPE_PARAMETER;
    }

    public static boolean isArrayLengthAccess(Tree tree) {
        ExpressionTree expressionTree;
        return tree.getKind() == Tree.Kind.MEMBER_SELECT && TreeUtils.isFieldAccess(tree) && TreeUtils.getFieldName(tree).equals("length") && TreeUtils.typeOf(expressionTree = ((MemberSelectTree)tree).getExpression()).getKind() == TypeKind.ARRAY;
    }

    public static boolean isAnonymousConstructor(MethodTree method) {
        ExecutableElement e = TreeUtils.elementFromTree(method);
        if (e == null || e.getKind() != ElementKind.CONSTRUCTOR) {
            return false;
        }
        TypeElement typeElement = (TypeElement)e.getEnclosingElement();
        return typeElement.getNestingKind() == NestingKind.ANONYMOUS;
    }

    public static boolean isCompactCanonicalRecordConstructor(MethodTree method) {
        ExecutableElement e = TreeUtils.elementFromTree(method);
        if (!(e instanceof Symbol)) {
            return false;
        }
        return (((Symbol)((Object)e)).flags() & 0x2000000000000000L) != 0L;
    }

    public static boolean isAutoGeneratedRecordMember(Tree member) {
        Element e = TreeUtils.elementFromTree(member);
        return e != null && ElementUtils.isAutoGeneratedRecordMember(e);
    }

    public static List<AnnotationMirror> annotationsFromTypeAnnotationTrees(List<? extends AnnotationTree> annoTrees) {
        return CollectionsPlume.mapList(TreeUtils::annotationFromAnnotationTree, annoTrees);
    }

    public static AnnotationMirror annotationFromAnnotationTree(AnnotationTree tree) {
        return ((JCTree.JCAnnotation)tree).attribute;
    }

    public static List<? extends AnnotationMirror> annotationsFromTree(AnnotatedTypeTree tree) {
        return TreeUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCAnnotatedType)tree).annotations);
    }

    public static List<? extends AnnotationMirror> annotationsFromTree(TypeParameterTree tree) {
        return TreeUtils.annotationsFromTypeAnnotationTrees(((JCTree.JCTypeParameter)tree).annotations);
    }

    public static List<? extends AnnotationMirror> annotationsFromArrayCreation(NewArrayTree tree, int level) {
        assert (tree instanceof JCTree.JCNewArray);
        JCTree.JCNewArray newArray = (JCTree.JCNewArray)tree;
        if (level == -1) {
            return TreeUtils.annotationsFromTypeAnnotationTrees(newArray.annotations);
        }
        if (newArray.dimAnnotations.length() > 0 && level >= 0 && level < newArray.dimAnnotations.size()) {
            return TreeUtils.annotationsFromTypeAnnotationTrees((List<? extends AnnotationTree>)newArray.dimAnnotations.get(level));
        }
        return Collections.emptyList();
    }

    public static boolean isLocalVariable(Tree tree) {
        if (tree.getKind() == Tree.Kind.VARIABLE) {
            VariableElement varElt = TreeUtils.elementFromDeclaration((VariableTree)tree);
            return varElt != null && ElementUtils.isLocalVariable(varElt);
        }
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            ExpressionTree etree = (ExpressionTree)tree;
            assert (TreeUtils.isUseOfElement(etree)) : "@AssumeAssertion(nullness): tree kind";
            return ElementUtils.isLocalVariable(TreeUtils.elementFromUse(etree));
        }
        return false;
    }

    public static TypeMirror typeOf(Tree tree) {
        return ((JCTree)tree).type;
    }

    public static ExecutableElement findFunction(Tree tree, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        Types javacTypes = Types.instance(ctx);
        return (ExecutableElement)((Object)javacTypes.findDescriptorSymbol(((Type)TreeUtils.typeOf(tree)).asElement()));
    }

    public static boolean isImplicitlyTypedLambda(Tree tree) {
        return tree.getKind() == Tree.Kind.LAMBDA_EXPRESSION && ((JCTree.JCLambda)tree).paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT;
    }

    public static boolean isExprConstTrue(ExpressionTree tree) {
        assert (tree instanceof JCTree.JCExpression);
        if (((JCTree.JCExpression)tree).type.isTrue()) {
            return true;
        }
        if ((tree = TreeUtils.withoutParens(tree)) instanceof JCTree.JCBinary) {
            JCTree.JCBinary binTree = (JCTree.JCBinary)tree;
            JCTree.JCExpression ltree = binTree.lhs;
            JCTree.JCExpression rtree = binTree.rhs;
            switch (binTree.getTag()) {
                case AND: {
                    return TreeUtils.isExprConstTrue(ltree) && TreeUtils.isExprConstTrue(rtree);
                }
                case OR: {
                    return TreeUtils.isExprConstTrue(ltree) || TreeUtils.isExprConstTrue(rtree);
                }
            }
        }
        return false;
    }

    public static String toStringOneLine(Tree tree) {
        return tree.toString().trim().replaceAll("\\s+", " ");
    }

    public static String toStringTruncated(Tree tree, int length) {
        if (length < 6) {
            throw new BugInCF("TreeUtils.toStringTruncated: bad length " + length);
        }
        String result = TreeUtils.toStringOneLine(tree);
        if (result.length() > length) {
            result = "\"" + result.substring(0, length - 5) + "...\"";
        }
        return result;
    }

    public static String nameExpressionToString(ExpressionTree nameExpr) {
        SimpleTreeVisitor<String, Void> visitor = new SimpleTreeVisitor<String, Void>(){

            @Override
            public String visitIdentifier(IdentifierTree tree, Void p) {
                return tree.toString();
            }

            @Override
            public String visitMemberSelect(MemberSelectTree tree, Void p) {
                return tree.getExpression().accept(this, null) + "." + tree.getIdentifier().toString();
            }
        };
        return nameExpr.accept(visitor, null);
    }

    public static boolean isWideningBinary(BinaryTree tree) {
        switch (tree.getKind()) {
            case LEFT_SHIFT: 
            case LEFT_SHIFT_ASSIGNMENT: 
            case RIGHT_SHIFT: 
            case RIGHT_SHIFT_ASSIGNMENT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                return true;
            }
            case MULTIPLY: 
            case MULTIPLY_ASSIGNMENT: 
            case DIVIDE: 
            case DIVIDE_ASSIGNMENT: 
            case REMAINDER: 
            case REMAINDER_ASSIGNMENT: 
            case PLUS: 
            case PLUS_ASSIGNMENT: 
            case MINUS: 
            case MINUS_ASSIGNMENT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case AND: 
            case XOR: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    public static List<? extends AnnotationTree> getExplicitAnnotationTrees(@Nullable List<? extends AnnotationTree> annoTrees, Tree typeTree) {
        block8: while (true) {
            switch (typeTree.getKind()) {
                case IDENTIFIER: 
                case PRIMITIVE_TYPE: {
                    if (annoTrees == null) {
                        return Collections.emptyList();
                    }
                    return annoTrees;
                }
                case ANNOTATED_TYPE: {
                    return ((AnnotatedTypeTree)typeTree).getAnnotations();
                }
                case ARRAY_TYPE: 
                case TYPE_PARAMETER: 
                case UNBOUNDED_WILDCARD: 
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    return Collections.emptyList();
                }
                case MEMBER_SELECT: {
                    if (annoTrees == null) {
                        return Collections.emptyList();
                    }
                    typeTree = ((MemberSelectTree)typeTree).getExpression();
                    continue block8;
                }
                case PARAMETERIZED_TYPE: {
                    typeTree = ((ParameterizedTypeTree)typeTree).getType();
                    continue block8;
                }
                case UNION_TYPE: {
                    List<? extends Tree> alternatives = ((UnionTypeTree)typeTree).getTypeAlternatives();
                    ArrayList<? extends AnnotationTree> result = new ArrayList<AnnotationTree>(alternatives.size());
                    for (Tree tree : alternatives) {
                        result.addAll(TreeUtils.getExplicitAnnotationTrees(null, tree));
                    }
                    return result;
                }
            }
            break;
        }
        throw new BugInCF("TreeUtils.getExplicitAnnotationTrees: what typeTree? %s %s %s", new Object[]{typeTree.getKind(), typeTree.getClass(), typeTree});
    }

    public static LiteralTree getDefaultValueTree(TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        typeMirror = TypeAnnotationUtils.unannotatedType(typeMirror);
        switch (typeMirror.getKind()) {
            case BYTE: 
            case SHORT: 
            case INT: {
                return TreeUtils.createLiteral(TypeTag.INT, 0, typeMirror, processingEnv);
            }
            case CHAR: {
                return TreeUtils.createLiteral(TypeTag.CHAR, 0, typeMirror, processingEnv);
            }
            case LONG: {
                return TreeUtils.createLiteral(TypeTag.LONG, 0L, typeMirror, processingEnv);
            }
            case FLOAT: {
                return TreeUtils.createLiteral(TypeTag.FLOAT, Float.valueOf(0.0f), typeMirror, processingEnv);
            }
            case DOUBLE: {
                return TreeUtils.createLiteral(TypeTag.DOUBLE, 0.0, typeMirror, processingEnv);
            }
            case BOOLEAN: {
                return TreeUtils.createLiteral(TypeTag.BOOLEAN, 0, typeMirror, processingEnv);
            }
        }
        return TreeUtils.createLiteral(TypeTag.BOT, null, processingEnv.getTypeUtils().getNullType(), processingEnv);
    }

    public static LiteralTree createLiteral(TypeTag typeTag, @Nullable Object value, TypeMirror typeMirror, ProcessingEnvironment processingEnv) {
        Context context = ((JavacProcessingEnvironment)processingEnv).getContext();
        TreeMaker maker = TreeMaker.instance(context);
        JCTree.JCLiteral result = maker.Literal(typeTag, value);
        result.type = (Type)typeMirror;
        return result;
    }

    public static boolean isNullExpression(Tree t2) {
        block5: while (true) {
            switch (t2.getKind()) {
                case PARENTHESIZED: {
                    t2 = ((ParenthesizedTree)t2).getExpression();
                    continue block5;
                }
                case TYPE_CAST: {
                    t2 = ((TypeCastTree)t2).getExpression();
                    continue block5;
                }
                case NULL_LITERAL: {
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public static boolean sameTree(ExpressionTree expr1, ExpressionTree expr2) {
        expr1 = TreeUtils.withoutParens(expr1);
        expr2 = TreeUtils.withoutParens(expr2);
        return expr1.getKind() == expr2.getKind() && expr1.toString().equals(expr2.toString());
    }

    public static boolean isDefaultCaseTree(CaseTree caseTree) {
        return TreeUtils.caseTreeGetExpressions(caseTree).isEmpty();
    }

    public static boolean isCaseRule(CaseTree caseTree) {
        if (SystemUtil.jreVersion < 12) {
            return false;
        }
        try {
            @NonNull Enum caseKind = (Enum)CASETREE_GETKIND.invoke((Object)caseTree, new Object[0]);
            boolean result = caseKind == CASETREE_CASEKIND_RULE;
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.isCaseRule: cannot find and/or call method CaseTree.getKind()", e);
        }
    }

    public static List<? extends ExpressionTree> caseTreeGetExpressions(CaseTree caseTree) {
        try {
            if (atLeastJava12) {
                @NonNull List result = (List)CASETREE_GETEXPRESSIONS.invoke((Object)caseTree, new Object[0]);
                return result;
            }
            ExpressionTree expression = (ExpressionTree)CASETREE_GETEXPRESSION.invoke((Object)caseTree, new Object[0]);
            if (expression == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(expression);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new BugInCF("TreeUtils.caseTreeGetExpressions: reflection failed for tree: %s", caseTree, e);
        }
    }

    public static @Nullable Tree caseTreeGetBody(CaseTree caseTree) {
        if (atLeastJava12) {
            try {
                Tree ret = (Tree)CASETREE_GETBODY.invoke((Object)caseTree, new Object[0]);
                return ret;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.caseTreeGetBody: reflection failed for tree: %s", caseTree, e);
            }
        }
        throw new BugInCF("TreeUtils.caseTreeGetBody: requires at least Java 12");
    }

    public static VariableTree bindingPatternTreeGetVariable(Tree bindingPatternTree) {
        if (atLeastJava16) {
            VariableTree variableTree;
            try {
                VariableTree localVT;
                variableTree = localVT = (VariableTree)BINDINGPATTERNTREE_GETVARIABLE.invoke((Object)bindingPatternTree, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.bindingPatternTreeGetVariable: reflection failed for tree: %s", bindingPatternTree, e);
            }
            if (variableTree != null) {
                return variableTree;
            }
            throw new BugInCF("TreeUtils.bindingPatternTreeGetVariable: variable is null for tree: %s", bindingPatternTree);
        }
        throw new BugInCF("TreeUtils.bindingPatternTreeGetVariable: requires at least Java 16");
    }

    public static @Nullable Tree instanceOfTreeGetPattern(InstanceOfTree instanceOfTree) {
        if (atLeastJava16) {
            try {
                Tree ret = (Tree)INSTANCEOFTREE_GETPATTERN.invoke((Object)instanceOfTree, new Object[0]);
                return ret;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.instanceOfGetPattern: reflection failed for tree: %s", instanceOfTree, e);
            }
        }
        return null;
    }

    public static ExpressionTree switchExpressionTreeGetExpression(Tree switchExpressionTree) {
        if (atLeastJava12) {
            ExpressionTree expressionTree;
            try {
                ExpressionTree localET;
                expressionTree = localET = (ExpressionTree)SWITCHEXPRTREE_GETEXPRESSION.invoke((Object)switchExpressionTree, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.switchExpressionTreeGetExpression: reflection failed for tree: %s", switchExpressionTree, e);
            }
            if (expressionTree != null) {
                return expressionTree;
            }
            throw new BugInCF("TreeUtils.switchExpressionTreeGetExpression: expression is null for tree: %s", switchExpressionTree);
        }
        throw new BugInCF("TreeUtils.switchExpressionTreeGetExpression: requires at least Java 12");
    }

    public static List<? extends CaseTree> switchExpressionTreeGetCases(Tree switchExpressionTree) {
        if (atLeastJava12) {
            List cases;
            try {
                List localcases;
                cases = localcases = (List)SWITCHEXPRTREE_GETCASES.invoke((Object)switchExpressionTree, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.switchExpressionTreeGetCases: reflection failed for tree: %s", switchExpressionTree, e);
            }
            if (cases != null) {
                return cases;
            }
            throw new BugInCF("TreeUtils.switchExpressionTreeGetCases: cases is null for tree: %s", switchExpressionTree);
        }
        throw new BugInCF("TreeUtils.switchExpressionTreeGetCases: requires at least Java 12");
    }

    public static boolean isSwitchStatement(Tree tree) {
        return tree.getKind() == Tree.Kind.SWITCH;
    }

    public static ExpressionTree yieldTreeGetValue(Tree yieldTree) {
        if (atLeastJava13) {
            ExpressionTree expressionTree;
            try {
                ExpressionTree localET;
                expressionTree = localET = (ExpressionTree)YIELDTREE_GETVALUE.invoke((Object)yieldTree, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.yieldTreeGetValue: reflection failed for tree: %s", yieldTree, e);
            }
            if (expressionTree != null) {
                return expressionTree;
            }
            throw new BugInCF("TreeUtils.yieldTreeGetValue: expression is null for tree: %s", yieldTree);
        }
        throw new BugInCF("TreeUtils.yieldTreeGetValue: requires at least Java 13");
    }

    public static boolean isVariableTreeDeclaredUsingVar(VariableTree variableTree) {
        JCTree.JCExpression type = (JCTree.JCExpression)variableTree.getType();
        return type != null && type.pos == -1;
    }

    public static boolean isVarArgs(Tree tree) {
        switch (tree.getKind()) {
            case METHOD_INVOCATION: {
                return TreeUtils.isVarArgs((MethodInvocationTree)tree);
            }
            case NEW_CLASS: {
                return TreeUtils.isVarArgs((NewClassTree)tree);
            }
        }
        throw new BugInCF("TreeUtils.isVarArgs: unexpected kind of tree: " + tree);
    }

    public static boolean isVarArgs(MethodInvocationTree invok) {
        return TreeUtils.isVarArgs(TreeUtils.elementFromUse(invok), invok.getArguments());
    }

    public static boolean isVarArgs(NewClassTree newClassTree) {
        return TreeUtils.isVarArgs(TreeUtils.elementFromUse(newClassTree), newClassTree.getArguments());
    }

    private static boolean isVarArgs(ExecutableElement method, List<? extends ExpressionTree> args) {
        if (!method.isVarArgs()) {
            return false;
        }
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != args.size()) {
            return true;
        }
        TypeMirror lastArgType = TreeUtils.typeOf(args.get(args.size() - 1));
        if (lastArgType.getKind() == TypeKind.NULL) {
            return false;
        }
        if (lastArgType.getKind() != TypeKind.ARRAY) {
            return true;
        }
        TypeMirror varargsParamType = parameters.get(parameters.size() - 1).asType();
        return TypesUtils.getArrayDepth(varargsParamType) != TypesUtils.getArrayDepth(lastArgType);
    }

    public static Tree.Kind getKindRecordAsClass(Tree tree) {
        Tree.Kind kind = tree.getKind();
        if (kind.name().equals("RECORD")) {
            kind = Tree.Kind.CLASS;
        }
        return kind;
    }

    public static boolean isBinaryComparison(BinaryTree tree) {
        return BINARY_COMPARISON_TREE_KINDS.contains((Object)tree.getKind());
    }

    public static JCTree.JCFieldAccess Select(TreeMaker treeMaker, Tree base, Symbol sym) {
        if (atLeastJava21) {
            try {
                assert (TREEMAKER_SELECT != null) : "@AssumeAssertion(nullness): initialization";
                JCTree.JCFieldAccess jfa = (JCTree.JCFieldAccess)TREEMAKER_SELECT.invoke((Object)treeMaker, base, sym);
                if (jfa != null) {
                    return jfa;
                }
                throw new BugInCF("TreeUtils.Select: TreeMaker.Select returned null for tree: %s", base);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new BugInCF("TreeUtils.Select: reflection failed for tree: %s", base, e);
            }
        }
        JCTree.JCFieldAccess jfa = (JCTree.JCFieldAccess)treeMaker.Select((JCTree.JCExpression)base, sym);
        return jfa;
    }

    public static JCTree.JCFieldAccess Select(TreeMaker treeMaker, Tree base, Name name) {
        return treeMaker.Select((JCTree.JCExpression)base, name);
    }

    static {
        SourceVersion java21;
        SourceVersion java16;
        SourceVersion java13;
        SourceVersion java12;
        treeUids = new UniqueIdMap();
        BINARY_COMPARISON_TREE_KINDS = EnumSet.of(Tree.Kind.EQUAL_TO, new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL});
        SourceVersion latestSource = SourceVersion.latest();
        try {
            java12 = SourceVersion.valueOf("RELEASE_12");
        }
        catch (IllegalArgumentException e) {
            java12 = null;
        }
        atLeastJava12 = java12 != null && latestSource.ordinal() >= java12.ordinal();
        try {
            java13 = SourceVersion.valueOf("RELEASE_13");
        }
        catch (IllegalArgumentException e) {
            java13 = null;
        }
        atLeastJava13 = java13 != null && latestSource.ordinal() >= java13.ordinal();
        try {
            java16 = SourceVersion.valueOf("RELEASE_16");
        }
        catch (IllegalArgumentException e) {
            java16 = null;
        }
        atLeastJava16 = java16 != null && latestSource.ordinal() >= java16.ordinal();
        try {
            java21 = SourceVersion.valueOf("RELEASE_21");
        }
        catch (IllegalArgumentException e) {
            java21 = null;
        }
        atLeastJava21 = java21 != null && latestSource.ordinal() >= java21.ordinal();
        try {
            if (atLeastJava12) {
                CASETREE_GETEXPRESSIONS = CaseTree.class.getDeclaredMethod("getExpressions", new Class[0]);
                CASETREE_GETEXPRESSION = null;
                CASETREE_GETBODY = CaseTree.class.getDeclaredMethod("getBody", new Class[0]);
                Class<?> switchExpressionClass = Class.forName("com.sun.source.tree.SwitchExpressionTree");
                SWITCHEXPRTREE_GETEXPRESSION = switchExpressionClass.getMethod("getExpression", new Class[0]);
                SWITCHEXPRTREE_GETCASES = switchExpressionClass.getMethod("getCases", new Class[0]);
                CASETREE_GETKIND = CaseTree.class.getDeclaredMethod("getCaseKind", new Class[0]);
                Enum ruleTemp = null;
                block10: for (Class<?> nested : CaseTree.class.getDeclaredClasses()) {
                    ?[] enumConstants;
                    if (!nested.isEnum() || !nested.getSimpleName().equals("CaseKind")) continue;
                    for (Object enumConstant : enumConstants = nested.getEnumConstants()) {
                        if (!enumConstant.toString().equals("RULE")) continue;
                        ruleTemp = (Enum)enumConstant;
                        break block10;
                    }
                }
                CASETREE_CASEKIND_RULE = ruleTemp;
                assert (CASETREE_CASEKIND_RULE != null);
            } else {
                CASETREE_GETEXPRESSION = CaseTree.class.getDeclaredMethod("getExpression", new Class[0]);
                CASETREE_GETEXPRESSIONS = null;
                CASETREE_GETBODY = null;
                SWITCHEXPRTREE_GETEXPRESSION = null;
                SWITCHEXPRTREE_GETCASES = null;
                CASETREE_GETKIND = null;
                CASETREE_CASEKIND_RULE = null;
            }
            if (atLeastJava13) {
                Class<?> yieldTreeClass = Class.forName("com.sun.source.tree.YieldTree");
                YIELDTREE_GETVALUE = yieldTreeClass.getMethod("getValue", new Class[0]);
            } else {
                YIELDTREE_GETVALUE = null;
            }
            if (atLeastJava16) {
                INSTANCEOFTREE_GETPATTERN = InstanceOfTree.class.getMethod("getPattern", new Class[0]);
                Class<?> bindingPatternClass = Class.forName("com.sun.source.tree.BindingPatternTree");
                BINDINGPATTERNTREE_GETVARIABLE = bindingPatternClass.getMethod("getVariable", new Class[0]);
            } else {
                INSTANCEOFTREE_GETPATTERN = null;
                BINDINGPATTERNTREE_GETVARIABLE = null;
            }
            TREEMAKER_SELECT = atLeastJava21 ? TreeMaker.class.getMethod("Select", JCTree.JCExpression.class, Symbol.class) : null;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            AssertionError err = new AssertionError((Object)"Unexpected error in TreeUtils static initializer");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        classTreeKinds = EnumSet.noneOf(Tree.Kind.class);
        for (Tree.Kind kind : Tree.Kind.values()) {
            if (kind.asInterface() != ClassTree.class) continue;
            classTreeKinds.add(kind);
        }
        classAndMethodTreeKinds = EnumSet.copyOf(TreeUtils.classTreeKinds());
        classAndMethodTreeKinds.add(Tree.Kind.METHOD);
        declarationTreeKinds = EnumSet.noneOf(Tree.Kind.class);
        declarationTreeKinds.addAll(classTreeKinds);
        declarationTreeKinds.add(Tree.Kind.METHOD);
        declarationTreeKinds.add(Tree.Kind.VARIABLE);
        typeTreeKinds = EnumSet.of(Tree.Kind.PRIMITIVE_TYPE, new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.TYPE_PARAMETER, Tree.Kind.ARRAY_TYPE, Tree.Kind.UNBOUNDED_WILDCARD, Tree.Kind.EXTENDS_WILDCARD, Tree.Kind.SUPER_WILDCARD, Tree.Kind.ANNOTATED_TYPE});
    }

    public static enum MemberReferenceKind {
        SUPER(MemberReferenceTree.ReferenceMode.INVOKE, false),
        UNBOUND(MemberReferenceTree.ReferenceMode.INVOKE, true),
        STATIC(MemberReferenceTree.ReferenceMode.INVOKE, false),
        BOUND(MemberReferenceTree.ReferenceMode.INVOKE, false),
        IMPLICIT_INNER(MemberReferenceTree.ReferenceMode.NEW, false),
        TOPLEVEL(MemberReferenceTree.ReferenceMode.NEW, false),
        ARRAY_CTOR(MemberReferenceTree.ReferenceMode.NEW, false);

        final MemberReferenceTree.ReferenceMode mode;
        final boolean unbound;

        private MemberReferenceKind(MemberReferenceTree.ReferenceMode mode, boolean unbound) {
            this.mode = mode;
            this.unbound = unbound;
        }

        public boolean isUnbound() {
            return this.unbound;
        }

        public static MemberReferenceKind getMemberReferenceKind(MemberReferenceTree tree) {
            JCTree.JCMemberReference memberTree = (JCTree.JCMemberReference)tree;
            switch (memberTree.kind) {
                case SUPER: {
                    return SUPER;
                }
                case UNBOUND: {
                    return UNBOUND;
                }
                case STATIC: {
                    return STATIC;
                }
                case BOUND: {
                    return BOUND;
                }
                case IMPLICIT_INNER: {
                    return IMPLICIT_INNER;
                }
                case TOPLEVEL: {
                    return TOPLEVEL;
                }
                case ARRAY_CTOR: {
                    return ARRAY_CTOR;
                }
            }
            throw new BugInCF("Unexpected ReferenceKind: %s", new Object[]{memberTree.kind});
        }
    }
}

