/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.javacutil;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.nullaway.checker.interning.qual.EqualsMethod;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.signature.qual.BinaryName;
import org.checkerframework.nullaway.checker.signature.qual.CanonicalNameOrEmpty;
import org.checkerframework.nullaway.checker.signature.qual.DotSeparatedIdentifiers;
import org.checkerframework.nullaway.checker.signature.qual.FullyQualifiedName;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.javacutil.ElementUtils;
import org.checkerframework.nullaway.javacutil.InternalUtils;
import org.checkerframework.nullaway.javacutil.TypeAnnotationUtils;
import org.checkerframework.nullaway.javacutil.TypeKindUtils;
import org.checkerframework.nullaway.org.plumelib.util.CollectionsPlume;
import org.checkerframework.nullaway.org.plumelib.util.ImmutableTypes;
import org.checkerframework.nullaway.org.plumelib.util.StringsPlume;

public final class TypesUtils {
    private static Set<String> fqBoxedTypes = new HashSet<String>(Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float"));
    static final Set<@FullyQualifiedName String> numericBoxedTypes = new HashSet<String>(Arrays.asList("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float"));

    private TypesUtils() {
        throw new AssertionError((Object)"Class TypesUtils cannot be instantiated.");
    }

    public static TypeMirror typeFromClass(Class<?> clazz, Types types, Elements elements) {
        if (clazz == Void.TYPE) {
            return types.getNoType(TypeKind.VOID);
        }
        if (clazz.isPrimitive()) {
            String primitiveName = clazz.getName().toUpperCase(Locale.getDefault());
            TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
            return types.getPrimitiveType(primitiveKind);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = TypesUtils.typeFromClass(clazz.getComponentType(), types, elements);
            return types.getArrayType(componentType);
        }
        String name = clazz.getCanonicalName();
        assert (name != null) : "@AssumeAssertion(nullness): assumption";
        TypeElement element = elements.getTypeElement(name);
        if (element == null) {
            throw new BugInCF("No element for: " + clazz);
        }
        return element.asType();
    }

    public static ArrayType createArrayType(TypeMirror componentType, Types types) {
        JavacTypes t2 = (JavacTypes)types;
        return t2.getArrayType(componentType);
    }

    public static Class<?> getClassFromType(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case ARRAY: {
                Class<?> componentClass = TypesUtils.getClassFromType(((ArrayType)typeMirror).getComponentType());
                return Array.newInstance(componentClass, 0).getClass();
            }
            case DECLARED: {
                @DotSeparatedIdentifiers String typeString = TypesUtils.getQualifiedName((DeclaredType)typeMirror).toString();
                if (typeString.equals("<nulltype>")) {
                    return Void.TYPE;
                }
                try {
                    return Class.forName(typeString);
                }
                catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError e) {
                    return Object.class;
                }
            }
        }
        return Object.class;
    }

    public static @CanonicalNameOrEmpty String getQualifiedName(DeclaredType type) {
        TypeElement element = (TypeElement)type.asElement();
        @CanonicalNameOrEmpty javax.lang.model.element.Name name = element.getQualifiedName();
        return name.toString();
    }

    public static String simpleTypeName(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return TypesUtils.simpleTypeName(((ArrayType)type).getComponentType()) + "[]";
            }
            case TYPEVAR: {
                return ((TypeVariable)type).asElement().getSimpleName().toString();
            }
            case DECLARED: {
                return ((DeclaredType)type).asElement().getSimpleName().toString();
            }
            case INTERSECTION: {
                StringJoiner sjI = new StringJoiner(" & ");
                for (TypeMirror typeMirror : ((IntersectionType)type).getBounds()) {
                    sjI.add(TypesUtils.simpleTypeName(typeMirror));
                }
                return sjI.toString();
            }
            case NULL: {
                return "<nulltype>";
            }
            case VOID: {
                return "void";
            }
            case WILDCARD: {
                WildcardType wildcard = (WildcardType)type;
                TypeMirror typeMirror = wildcard.getExtendsBound();
                TypeMirror superBound = wildcard.getSuperBound();
                return "?" + (typeMirror != null ? " extends " + TypesUtils.simpleTypeName(typeMirror) : "") + (superBound != null ? " super " + TypesUtils.simpleTypeName(superBound) : "");
            }
            case UNION: {
                StringJoiner sj = new StringJoiner(" | ");
                for (TypeMirror typeMirror : ((UnionType)type).getAlternatives()) {
                    sj.add(TypesUtils.simpleTypeName(typeMirror));
                }
                return sj.toString();
            }
            case PACKAGE: {
                return "PACKAGE:" + type;
            }
        }
        if (type.getKind().isPrimitive()) {
            return TypeAnnotationUtils.unannotatedType(type).toString();
        }
        throw new BugInCF("simpleTypeName: unhandled type kind: %s, type: %s", new Object[]{type.getKind(), type});
    }

    public static @BinaryName String binaryName(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            throw new BugInCF("Only declared types have a binary name");
        }
        return ElementUtils.getBinaryName((TypeElement)((DeclaredType)type).asElement());
    }

    public static @Nullable TypeElement getTypeElement(TypeMirror type) {
        Symbol.TypeSymbol element = ((Type)type).asElement();
        if (element == null) {
            return null;
        }
        if (ElementUtils.isTypeElement(element)) {
            return (TypeElement)((Object)element);
        }
        return null;
    }

    public static TypeMirror getInnermostComponentType(ArrayType at) {
        TypeMirror result = at;
        while (result.getKind() == TypeKind.ARRAY) {
            result = result.getComponentType();
        }
        return result;
    }

    public static boolean areSameDeclaredTypes(Type.ClassType t1, Type.ClassType t2) {
        if (t1.tsym.name != t2.tsym.name) {
            return false;
        }
        return t1.toString().equals(t2.toString());
    }

    public static boolean areSamePrimitiveTypes(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isPrimitive(left) || !TypesUtils.isPrimitive(right)) {
            return false;
        }
        return left.getKind() == right.getKind();
    }

    public static boolean isObject(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Object");
    }

    public static boolean isClass(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Class");
    }

    public static boolean isString(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.String");
    }

    public static boolean isBooleanType(TypeMirror type) {
        return type.getKind() == TypeKind.BOOLEAN || TypesUtils.isDeclaredOfName(type, "java.lang.Boolean");
    }

    public static boolean isCharOrCharacter(TypeMirror type) {
        return type.getKind() == TypeKind.CHAR || TypesUtils.isDeclaredOfName(type, "java.lang.Character");
    }

    public static boolean isDeclaredOfName(TypeMirror type, CharSequence qualifiedName) {
        return type.getKind() == TypeKind.DECLARED && TypesUtils.getQualifiedName((DeclaredType)type).contentEquals(qualifiedName);
    }

    public static boolean isDeclaredOfName(TypeMirror type, Collection<String> qualifiedNames) {
        return type.getKind() == TypeKind.DECLARED && qualifiedNames.contains(TypesUtils.getQualifiedName((DeclaredType)type));
    }

    public static boolean isBoxedPrimitive(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, fqBoxedTypes);
    }

    public static boolean isImmutableTypeInJdk(TypeMirror type) {
        return TypesUtils.isPrimitive(type) || type.getKind() == TypeKind.DECLARED && ImmutableTypes.isImmutable(TypesUtils.getQualifiedName((DeclaredType)type).toString());
    }

    public static boolean isThrowable(TypeMirror type) {
        while (type != null && type.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            TypeElement elem = (TypeElement)dt.asElement();
            javax.lang.model.element.Name name = elem.getQualifiedName();
            if ("java.lang.Throwable".contentEquals(name)) {
                return true;
            }
            type = elem.getSuperclass();
        }
        return false;
    }

    public static boolean isAnonymous(TypeMirror type) {
        return type instanceof DeclaredType && ((TypeElement)((DeclaredType)type).asElement()).getNestingKind() == NestingKind.ANONYMOUS;
    }

    public static boolean isPrimitive(TypeMirror type) {
        switch (type.getKind()) {
            case INT: 
            case LONG: 
            case SHORT: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrimitiveOrBoxed(TypeMirror type) {
        switch (type.getKind()) {
            case INT: 
            case LONG: 
            case SHORT: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case BOOLEAN: {
                return true;
            }
            case DECLARED: {
                String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)type).toString();
                return qualifiedName.equals("java.lang.Boolean") || qualifiedName.equals("java.lang.Byte") || qualifiedName.equals("java.lang.Character") || qualifiedName.equals("java.lang.Short") || qualifiedName.equals("java.lang.Integer") || qualifiedName.equals("java.lang.Long") || qualifiedName.equals("java.lang.Double") || qualifiedName.equals("java.lang.Float");
            }
        }
        return false;
    }

    public static boolean isNumeric(TypeMirror type) {
        return TypeKindUtils.isNumeric(type.getKind());
    }

    public static boolean isNumericBoxed(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED && numericBoxedTypes.contains(TypesUtils.getQualifiedName((DeclaredType)type).toString());
    }

    public static boolean isIntegralPrimitive(TypeMirror type) {
        return TypesUtils.isIntegralPrimitive(type.getKind());
    }

    public static boolean isIntegralPrimitive(TypeKind typeKind) {
        switch (typeKind) {
            case INT: 
            case LONG: 
            case SHORT: 
            case BYTE: 
            case CHAR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegralPrimitiveOrBoxed(TypeMirror type) {
        TypeKind kind = TypeKindUtils.primitiveOrBoxedToTypeKind(type);
        return kind != null && TypeKindUtils.isIntegral(kind);
    }

    public static boolean isBoxOf(TypeMirror declaredType, TypeMirror primitiveType) {
        if (declaredType.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)declaredType).toString();
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                return qualifiedName.equals("java.lang.Boolean");
            }
            case BYTE: {
                return qualifiedName.equals("java.lang.Byte");
            }
            case CHAR: {
                return qualifiedName.equals("java.lang.Character");
            }
            case DOUBLE: {
                return qualifiedName.equals("java.lang.Double");
            }
            case FLOAT: {
                return qualifiedName.equals("java.lang.Float");
            }
            case INT: {
                return qualifiedName.equals("java.lang.Integer");
            }
            case LONG: {
                return qualifiedName.equals("java.lang.Long");
            }
            case SHORT: {
                return qualifiedName.equals("java.lang.Short");
            }
        }
        return false;
    }

    public static boolean isBoxedFloating(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)type).toString();
        return qualifiedName.equals("java.lang.Double") || qualifiedName.equals("java.lang.Float");
    }

    public static boolean isFloatingPrimitive(TypeMirror type) {
        switch (type.getKind()) {
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloatingPoint(TypeMirror type) {
        TypeKind kind = TypeKindUtils.primitiveOrBoxedToTypeKind(type);
        return kind != null && TypeKindUtils.isFloatingPoint(kind);
    }

    public static boolean isClassType(TypeMirror type) {
        return type instanceof Type.ClassType;
    }

    public static boolean isFunctionalInterface(TypeMirror type, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        com.sun.tools.javac.code.Types javacTypes = com.sun.tools.javac.code.Types.instance(ctx);
        return javacTypes.isFunctionalInterface((Type)type);
    }

    public static boolean isCompoundType(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: 
            case TYPEVAR: 
            case INTERSECTION: 
            case WILDCARD: 
            case UNION: 
            case EXECUTABLE: {
                return true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                return !declaredType.getTypeArguments().isEmpty();
            }
        }
        return false;
    }

    public static boolean hasEnclosingType(TypeMirror type) {
        Type e = ((Type)type).getEnclosingType();
        return e.getKind() != TypeKind.NONE;
    }

    public static TypeMirror upperBound(TypeMirror type) {
        while (true) {
            WildcardType wc;
            if (type instanceof TypeVariable) {
                TypeVariable tvar = (TypeVariable)type;
                if (tvar.getUpperBound() == null) break;
                type = tvar.getUpperBound();
                continue;
            }
            if (!(type instanceof WildcardType) || (wc = (WildcardType)type).getExtendsBound() == null) break;
            type = wc.getExtendsBound();
        }
        return type;
    }

    public static @Nullable TypeParameterElement wildcardToTypeParam(WildcardType wildcard) {
        return TypesUtils.wildcardToTypeParam((Type.WildcardType)wildcard);
    }

    public static @Nullable TypeParameterElement wildcardToTypeParam(Type.WildcardType wildcard) {
        Element typeParamElement = wildcard.bound != null ? wildcard.bound.asElement() : null;
        return (TypeParameterElement)typeParamElement;
    }

    public static Type wildUpperBound(TypeMirror tm, ProcessingEnvironment env) {
        Type t2 = (Type)tm;
        if (t2.hasTag(TypeTag.WILDCARD)) {
            Context context = ((JavacProcessingEnvironment)env).getContext();
            Type.WildcardType w = (Type.WildcardType)TypeAnnotationUtils.unannotatedType(t2);
            if (w.isSuperBound()) {
                Symtab syms = Symtab.instance(context);
                return w.bound == null ? syms.objectType : w.bound.getUpperBound();
            }
            return TypesUtils.wildUpperBound(w.type, env);
        }
        return TypeAnnotationUtils.unannotatedType(t2);
    }

    public static DeclaredType getObjectTypeMirror(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        Symtab syms = Symtab.instance(context);
        return (DeclaredType)((Object)syms.objectType);
    }

    public static TypeMirror getTypeVariableLowerBound(TypeVariable typeVariable, ProcessingEnvironment env) {
        TypeMirror lb = typeVariable.getLowerBound();
        if (lb != null) {
            return lb;
        }
        Context context = ((JavacProcessingEnvironment)env).getContext();
        Symtab syms = Symtab.instance(context);
        return syms.botType;
    }

    public static Type wildLowerBound(TypeMirror tm, ProcessingEnvironment env) {
        Type t2 = (Type)tm;
        if (t2.hasTag(TypeTag.WILDCARD)) {
            Context context = ((JavacProcessingEnvironment)env).getContext();
            Symtab syms = Symtab.instance(context);
            Type.WildcardType w = (Type.WildcardType)TypeAnnotationUtils.unannotatedType(t2);
            return w.isExtendsBound() ? syms.botType : TypesUtils.wildLowerBound(w.type, env);
        }
        return TypeAnnotationUtils.unannotatedType(t2);
    }

    public static @Nullable TypeMirror findConcreteUpperBound(TypeMirror boundedType) {
        TypeMirror effectiveUpper = boundedType;
        block4: while (true) {
            switch (effectiveUpper.getKind()) {
                case WILDCARD: {
                    if ((effectiveUpper = ((WildcardType)effectiveUpper).getExtendsBound()) != null) continue block4;
                    return null;
                }
                case TYPEVAR: {
                    effectiveUpper = ((TypeVariable)effectiveUpper).getUpperBound();
                    continue block4;
                }
            }
            break;
        }
        return effectiveUpper;
    }

    public static boolean hasNoExplicitBound(TypeMirror type) {
        return type.getKind() == TypeKind.WILDCARD && ((Type.WildcardType)type).kind == BoundKind.UNBOUND;
    }

    public static boolean hasExplicitSuperBound(TypeMirror type) {
        return type.getKind() == TypeKind.WILDCARD && !TypesUtils.hasNoExplicitBound(type) && ((Type.WildcardType)type).isSuperBound();
    }

    public static boolean hasExplicitExtendsBound(TypeMirror type) {
        return type.getKind() == TypeKind.WILDCARD && !TypesUtils.hasNoExplicitBound(type) && ((Type.WildcardType)type).isExtendsBound();
    }

    public static boolean isUnboundedOrSuperBounded(WildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType).isSuperBound();
    }

    public static boolean isUnboundedOrExtendsBounded(WildcardType wildcardType) {
        return ((Type.WildcardType)wildcardType).isExtendsBound();
    }

    public static boolean isErasedSubtype(TypeMirror subtype, TypeMirror supertype, Types types) {
        return types.isSubtype(types.erasure(subtype), types.erasure(supertype));
    }

    public static boolean isCapturedTypeVariable(TypeMirror type) {
        if (type.getKind() != TypeKind.TYPEVAR) {
            return false;
        }
        return ((Type.TypeVar)TypeAnnotationUtils.unannotatedType(type)).isCaptured();
    }

    public static @Nullable WildcardType getCapturedWildcard(TypeVariable typeVar) {
        if (TypesUtils.isCapturedTypeVariable(typeVar)) {
            return ((Type.CapturedType)TypeAnnotationUtils.unannotatedType((TypeMirror)typeVar)).wildcard;
        }
        return null;
    }

    public static TypeMirror leastUpperBound(TypeMirror tm1, TypeMirror tm2, ProcessingEnvironment processingEnv) {
        WildcardType wc2;
        WildcardType wc1;
        Type t1 = TypeAnnotationUtils.unannotatedType(tm1);
        Type t2 = TypeAnnotationUtils.unannotatedType(tm2);
        if (t1.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (t1.getKind() == TypeKind.WILDCARD && (t1 = (Type)(wc1 = (WildcardType)((Object)t1)).getExtendsBound()) == null) {
            Elements elements = processingEnv.getElementUtils();
            return elements.getTypeElement("java.lang.Object").asType();
        }
        if (t2.getKind() == TypeKind.WILDCARD && (t2 = (Type)(wc2 = (WildcardType)((Object)t2)).getExtendsBound()) == null) {
            Elements elements = processingEnv.getElementUtils();
            return elements.getTypeElement("java.lang.Object").asType();
        }
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (TypesUtils.isPrimitive(t1) && types.isAssignable(t1, t2)) {
                return t2;
            }
            if (TypesUtils.isPrimitive(t2) && types.isAssignable(t2, t1)) {
                return t1;
            }
            Elements elements = processingEnv.getElementUtils();
            return elements.getTypeElement("java.lang.Object").asType();
        }
        try {
            return types.lub(t1, t2);
        }
        catch (Exception e) {
            Elements elements = processingEnv.getElementUtils();
            return elements.getTypeElement("java.lang.Object").asType();
        }
    }

    public static TypeMirror greatestLowerBound(TypeMirror tm1, TypeMirror tm2, ProcessingEnvironment processingEnv) {
        Type t1 = TypeAnnotationUtils.unannotatedType(tm1);
        Type t2 = TypeAnnotationUtils.unannotatedType(tm2);
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t1;
            }
            if (types.isAssignable(t2, t1)) {
                return t2;
            }
            return processingEnv.getTypeUtils().getNoType(TypeKind.NONE);
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            return t2;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            return t1;
        }
        return types.glb(t1, t2);
    }

    public static @Nullable TypeMirror mostSpecific(java.util.List<TypeMirror> typeMirrors, ProcessingEnvironment processingEnv) {
        if (typeMirrors.size() == 1) {
            return typeMirrors.get(0);
        }
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        List<Type> typeList = TypesUtils.typeMirrorListToTypeList(typeMirrors);
        Type glb = types.glb(typeList);
        for (Type candidate : typeList) {
            if (!types.isSameType(glb, candidate)) continue;
            return candidate;
        }
        return null;
    }

    private static List<Type> typeMirrorListToTypeList(java.util.List<TypeMirror> typeMirrors) {
        java.util.List<Type> typeList = CollectionsPlume.mapList(Type.class::cast, typeMirrors);
        return List.from(typeList);
    }

    public static TypeMirror substituteMethodReturnType(Element methodElement, TypeMirror substitutedReceiverType, ProcessingEnvironment env) {
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(InternalUtils.getJavacContext(env));
        Type substitutedMethodType = types.memberType((Type)substitutedReceiverType, (Symbol)methodElement);
        return substitutedMethodType.getReturnType();
    }

    public static @Nullable TypeMirror asSuper(TypeMirror type, TypeMirror superType, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        com.sun.tools.javac.code.Types javacTypes = com.sun.tools.javac.code.Types.instance(ctx);
        return javacTypes.asSuper((Type)type, ((Type)superType).tsym);
    }

    public static @Nullable TypeMirror getSuperclass(TypeMirror type, Types types) {
        java.util.List<? extends TypeMirror> superTypes = types.directSupertypes(type);
        for (TypeMirror typeMirror : superTypes) {
            Type.ClassType tt;
            if (!(typeMirror instanceof Type.ClassType) || (tt = (Type.ClassType)typeMirror).isInterface()) continue;
            return typeMirror;
        }
        return null;
    }

    public static @Nullable DeclaredType getSuperClassOrInterface(TypeMirror type, Types types) {
        java.util.List<? extends TypeMirror> superTypes = types.directSupertypes(type);
        for (TypeMirror typeMirror : superTypes) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            return (DeclaredType)typeMirror;
        }
        return null;
    }

    public static TypeKindUtils.PrimitiveConversionKind getPrimitiveConversionKind(PrimitiveType from, PrimitiveType to) {
        return TypeKindUtils.getPrimitiveConversionKind(from.getKind(), to.getKind());
    }

    public static TypeMirror substitute(TypeMirror type, java.util.List<? extends TypeMirror> typeVariables, java.util.List<? extends TypeMirror> typeArgs, ProcessingEnvironment env) {
        java.util.List<Type> newP = CollectionsPlume.mapList(Type.class::cast, typeVariables);
        java.util.List<Type> newT = CollectionsPlume.mapList(Type.class::cast, typeArgs);
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)env;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        return types.subst((Type)type, List.from(newP), List.from(newT));
    }

    public static int getArrayDepth(TypeMirror arrayType) {
        int counter = 0;
        TypeMirror type = arrayType;
        while (type.getKind() == TypeKind.ARRAY) {
            ++counter;
            type = ((ArrayType)type).getComponentType();
        }
        return counter;
    }

    public static TypeMirror freshTypeVariable(TypeMirror typeMirror, ProcessingEnvironment env) {
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)env;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        return (TypeMirror)types.freshTypeVariables(List.of((Type)typeMirror)).head;
    }

    public static TypeMirror freshTypeVariable(@Nullable TypeMirror upper, @Nullable TypeMirror lower, ProcessingEnvironment env) {
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)env;
        Names names = Names.instance(javacEnv.getContext());
        Symtab syms = Symtab.instance(javacEnv.getContext());
        Name capturedName = names.fromString("<captured wildcard>");
        WildcardType wildcardType = null;
        wildcardType = lower != null && (lower.getKind() == TypeKind.ARRAY || lower.getKind() == TypeKind.DECLARED || lower.getKind() == TypeKind.TYPEVAR) ? env.getTypeUtils().getWildcardType(null, lower) : (upper != null && (upper.getKind() == TypeKind.ARRAY || upper.getKind() == TypeKind.DECLARED || upper.getKind() == TypeKind.TYPEVAR) ? env.getTypeUtils().getWildcardType(upper, null) : env.getTypeUtils().getWildcardType(null, null));
        if (lower == null) {
            lower = syms.botType;
        }
        if (upper == null) {
            upper = syms.objectType;
        }
        return new Type.CapturedType(capturedName, syms.noSymbol, (Type)upper, (Type)lower, (Type.WildcardType)wildcardType);
    }

    public static java.util.List<TypeVariable> order(Collection<TypeVariable> collection, Types types) {
        ArrayList<TypeVariable> list = new ArrayList<TypeVariable>(collection);
        ArrayList<TypeVariable> ordered = new ArrayList<TypeVariable>(list.size());
        while (!list.isEmpty()) {
            TypeVariable free = TypesUtils.doesNotContainOthers(list, types);
            list.remove(free);
            ordered.add(free);
        }
        return ordered;
    }

    private static TypeVariable doesNotContainOthers(Collection<? extends TypeVariable> collection, Types types) {
        for (TypeVariable typeVariable : collection) {
            boolean doesNotContain = true;
            for (TypeVariable typeVariable2 : collection) {
                if (typeVariable == typeVariable2 || !types.contains(typeVariable, typeVariable2)) continue;
                doesNotContain = false;
                break;
            }
            if (!doesNotContain) continue;
            return typeVariable;
        }
        throw new BugInCF("Not found: %s", StringsPlume.join((CharSequence)",", collection));
    }

    public static ExecutableElement findFunction(TypeMirror functionalInterfaceType, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        com.sun.tools.javac.code.Types javacTypes = com.sun.tools.javac.code.Types.instance(ctx);
        return (ExecutableElement)((Object)javacTypes.findDescriptorSymbol(((Type)functionalInterfaceType).asElement()));
    }

    public static ExecutableType findFunctionType(TypeMirror functionalInterfaceType, ProcessingEnvironment env) {
        return (ExecutableType)TypesUtils.findFunction(functionalInterfaceType, env).asType();
    }

    public static boolean isRaw(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        TypeElement typeelem = (TypeElement)((DeclaredType)type).asElement();
        DeclaredType declType = (DeclaredType)typeelem.asType();
        return !declType.getTypeArguments().isEmpty() && ((DeclaredType)type).getTypeArguments().isEmpty();
    }

    public static @Nullable TypeMirror getMostSpecificArrayType(TypeMirror type, Types types) {
        if (type.getKind() == TypeKind.ARRAY) {
            return type;
        }
        for (TypeMirror typeMirror : types.directSupertypes(type)) {
            TypeMirror arrayType = TypesUtils.getMostSpecificArrayType(typeMirror, types);
            if (arrayType == null) continue;
            return arrayType;
        }
        return null;
    }

    public static boolean isParameterizedType(TypeMirror type) {
        return ((Type)type).isParameterized();
    }

    public static boolean isWildcardParameterized(TypeMirror typeMirror) {
        if (TypesUtils.isParameterizedType(typeMirror) && typeMirror.getKind() == TypeKind.DECLARED) {
            for (TypeMirror typeMirror2 : ((DeclaredType)typeMirror).getTypeArguments()) {
                if (typeMirror2.getKind() != TypeKind.WILDCARD) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeMirror createWildcard(TypeMirror lowerBound, TypeMirror upperBound, Types types) {
        TypeMirror nonObjectUpperBound = upperBound;
        if (TypesUtils.isObject(upperBound)) {
            nonObjectUpperBound = null;
        }
        assert (lowerBound == null || nonObjectUpperBound == null);
        WildcardType wildcardType = types.getWildcardType(nonObjectUpperBound, lowerBound);
        return (TypeMirror)List.of((Type)((Object)wildcardType)).head;
    }

    public static boolean canBeNarrowingPrimitiveConversion(TypeMirror type, Types types) {
        TypeMirror unboxedType = TypesUtils.isBoxedPrimitive(type) ? types.unboxedType(type) : type;
        TypeKind unboxedKind = unboxedType.getKind();
        return unboxedKind == TypeKind.BYTE || unboxedKind == TypeKind.SHORT || unboxedKind == TypeKind.CHAR;
    }

    @EqualsMethod
    public static boolean areSame(TypeVariable typeVariable1, TypeVariable typeVariable2) {
        if (typeVariable1 == typeVariable2) {
            return true;
        }
        javax.lang.model.element.Name otherName = typeVariable2.asElement().getSimpleName();
        Element otherEnclosingElement = typeVariable2.asElement().getEnclosingElement();
        return typeVariable1.asElement().getSimpleName().contentEquals(otherName) && otherEnclosingElement.equals(typeVariable1.asElement().getEnclosingElement());
    }
}

