/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.analysis;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicLong;
import javax.lang.model.element.VariableElement;
import org.checkerframework.shaded.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.AbstractValue;
import org.checkerframework.shaded.dataflow.analysis.Analysis;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.analysis.TransferInput;
import org.checkerframework.shaded.dataflow.analysis.TransferResult;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.TreeUtils;
import org.checkerframework.shaded.org.plumelib.util.UniqueId;
import org.checkerframework.shaded.org.plumelib.util.UnmodifiableIdentityHashMap;

public class AnalysisResult<V extends AbstractValue<V>, S extends Store<S>>
implements UniqueId {
    private boolean mapsCopied = false;
    protected IdentityHashMap<Node, V> nodeValues;
    protected IdentityHashMap<Tree, Set<Node>> treeLookup;
    protected IdentityHashMap<UnaryTree, BinaryTree> postfixLookup;
    protected final Map<VariableElement, V> finalLocalValues;
    protected final IdentityHashMap<Block, TransferInput<V, S>> inputs;
    protected final Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches;
    private static final AtomicLong nextUid = new AtomicLong(0L);
    private final transient long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization AnalysisResult<V, S> this) {
        return this.uid;
    }

    protected AnalysisResult(IdentityHashMap<Node, V> nodeValues, IdentityHashMap<Block, TransferInput<V, S>> inputs, IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<UnaryTree, BinaryTree> postfixLookup, Map<VariableElement, V> finalLocalValues, Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        this.nodeValues = UnmodifiableIdentityHashMap.wrap(nodeValues);
        this.treeLookup = UnmodifiableIdentityHashMap.wrap(treeLookup);
        this.postfixLookup = UnmodifiableIdentityHashMap.wrap(postfixLookup);
        this.inputs = inputs;
        this.finalLocalValues = finalLocalValues;
        this.analysisCaches = analysisCaches;
    }

    public AnalysisResult(IdentityHashMap<Node, V> nodeValues, IdentityHashMap<Block, TransferInput<V, S>> inputs, IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<UnaryTree, BinaryTree> postfixLookup, Map<VariableElement, V> finalLocalValues) {
        this(nodeValues, inputs, treeLookup, postfixLookup, finalLocalValues, new IdentityHashMap<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>>());
    }

    public AnalysisResult(Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        this(new IdentityHashMap(), new IdentityHashMap<Block, TransferInput<V, S>>(), new IdentityHashMap<Tree, Set<Node>>(), new IdentityHashMap<UnaryTree, BinaryTree>(), new HashMap(), analysisCaches);
    }

    public void combine(AnalysisResult<V, S> other) {
        this.copyMapsIfNeeded();
        this.nodeValues.putAll(other.nodeValues);
        AnalysisResult.mergeTreeLookup(this.treeLookup, other.treeLookup);
        this.postfixLookup.putAll(other.postfixLookup);
        this.inputs.putAll(other.inputs);
        this.finalLocalValues.putAll(other.finalLocalValues);
    }

    private void copyMapsIfNeeded() {
        if (!this.mapsCopied) {
            this.nodeValues = new IdentityHashMap<Node, V>(this.nodeValues);
            this.treeLookup = new IdentityHashMap<Tree, Set<Node>>(this.treeLookup);
            this.postfixLookup = new IdentityHashMap<UnaryTree, BinaryTree>(this.postfixLookup);
            this.mapsCopied = true;
        }
    }

    private static void mergeTreeLookup(IdentityHashMap<Tree, Set<Node>> treeLookup, IdentityHashMap<Tree, Set<Node>> otherTreeLookup) {
        for (Map.Entry<Tree, Set<Node>> entry : otherTreeLookup.entrySet()) {
            Set<Node> hit = treeLookup.get(entry.getKey());
            if (hit == null) {
                treeLookup.put(entry.getKey(), entry.getValue());
                continue;
            }
            hit.addAll((Collection<Node>)entry.getValue());
        }
    }

    public Map<VariableElement, V> getFinalLocalValues() {
        return this.finalLocalValues;
    }

    public @Nullable V getValue(Node n) {
        return (V)((AbstractValue)this.nodeValues.get(n));
    }

    public @Nullable V getValue(Tree t) {
        Set<Node> nodes = this.treeLookup.get(t);
        if (nodes == null) {
            return null;
        }
        AbstractValue merged = null;
        for (Node aNode : nodes) {
            V a = this.getValue(aNode);
            if (a == null) continue;
            if (merged == null) {
                merged = (AbstractValue)a;
                continue;
            }
            merged = merged.leastUpperBound(a);
        }
        return (V)merged;
    }

    public @Nullable Set<Node> getNodesForTree(Tree tree) {
        return this.treeLookup.get(tree);
    }

    public BinaryTree getPostfixBinaryTree(UnaryTree postfixTree) {
        if (!this.postfixLookup.containsKey(postfixTree)) {
            throw new BugInCF(postfixTree + " is not in postfixLookup");
        }
        return this.postfixLookup.get(postfixTree);
    }

    public @Nullable S getStoreBefore(Tree tree) {
        Set<Node> nodes = this.getNodesForTree(tree);
        if (nodes == null) {
            return null;
        }
        Store merged = null;
        for (Node node : nodes) {
            S s = this.getStoreBefore(node);
            if (merged == null) {
                merged = (Store)s;
                continue;
            }
            if (s == null) continue;
            merged = merged.leastUpperBound(s);
        }
        return (S)merged;
    }

    public @Nullable S getStoreBefore(Node node) {
        return this.runAnalysisFor(node, Analysis.BeforeOrAfter.BEFORE);
    }

    public S getStoreBefore(Block block) {
        TransferInput<V, S> transferInput = this.inputs.get(block);
        assert (transferInput != null) : "@AssumeAssertion(nullness): transferInput should be non-null";
        Analysis<V, S, ?> analysis = transferInput.analysis;
        switch (analysis.getDirection()) {
            case FORWARD: {
                return transferInput.getRegularStore();
            }
            case BACKWARD: {
                List<Node> nodes = block.getNodes();
                if (nodes.isEmpty()) {
                    return transferInput.getRegularStore();
                }
                Node firstNode = nodes.get(0);
                return analysis.runAnalysisFor(firstNode, Analysis.BeforeOrAfter.BEFORE, transferInput, this.nodeValues, this.analysisCaches);
            }
        }
        throw new BugInCF("Unknown direction: " + (Object)((Object)analysis.getDirection()));
    }

    public S getStoreAfter(Block block) {
        TransferInput<V, S> transferInput = this.inputs.get(block);
        assert (transferInput != null) : "@AssumeAssertion(nullness): transferInput should be non-null";
        Analysis<V, S, ?> analysis = transferInput.analysis;
        switch (analysis.getDirection()) {
            case FORWARD: {
                Node lastNode = block.getLastNode();
                if (lastNode == null) {
                    return transferInput.getRegularStore();
                }
                return analysis.runAnalysisFor(lastNode, Analysis.BeforeOrAfter.AFTER, transferInput, this.nodeValues, this.analysisCaches);
            }
            case BACKWARD: {
                return transferInput.getRegularStore();
            }
        }
        throw new BugInCF("Unknown direction: " + (Object)((Object)analysis.getDirection()));
    }

    public @Nullable S getStoreAfter(Tree tree) {
        Set<Node> nodes = this.getNodesForTree(tree);
        if (nodes == null) {
            return null;
        }
        Store merged = null;
        for (Node node : nodes) {
            S s = this.getStoreAfter(node);
            if (merged == null) {
                merged = (Store)s;
                continue;
            }
            if (s == null) continue;
            merged = merged.leastUpperBound(s);
        }
        return (S)merged;
    }

    public @Nullable S getStoreAfter(Node node) {
        return this.runAnalysisFor(node, Analysis.BeforeOrAfter.AFTER);
    }

    protected @Nullable S runAnalysisFor(Node node, Analysis.BeforeOrAfter preOrPost) {
        Block block = node.getBlock();
        assert (block != null) : "@AssumeAssertion(nullness): null block for node " + node;
        TransferInput<V, S> transferInput = this.inputs.get(block);
        if (transferInput == null) {
            return null;
        }
        this.copyMapsIfNeeded();
        return AnalysisResult.runAnalysisFor(node, preOrPost, transferInput, this.nodeValues, this.analysisCaches);
    }

    public static <V extends AbstractValue<V>, S extends Store<S>> S runAnalysisFor(Node node, Analysis.BeforeOrAfter preOrPost, TransferInput<V, S> transferInput, IdentityHashMap<Node, V> nodeValues, @Nullable Map<TransferInput<V, S>, IdentityHashMap<Node, TransferResult<V, S>>> analysisCaches) {
        if (transferInput.analysis == null) {
            throw new BugInCF("Analysis in transferInput cannot be null.");
        }
        return transferInput.analysis.runAnalysisFor(node, preOrPost, transferInput, nodeValues, analysisCaches);
    }

    public @Nullable TransferResult<V, S> lookupResult(Node node) {
        Block block = node.getBlock();
        TransferInput<V, S> blockInput = this.inputs.get(block);
        if (blockInput == null) {
            return null;
        }
        IdentityHashMap<Node, TransferResult<V, S>> cache = this.analysisCaches.get(blockInput);
        if (cache == null) {
            return null;
        }
        TransferResult<V, S> result = cache.get(node);
        return result;
    }

    public String toStringDebug() {
        StringJoiner result = new StringJoiner(String.format("%n  ", new Object[0]), String.format("AnalysisResult{%n  ", new Object[0]), String.format("%n}", new Object[0]));
        result.add("nodeValues = " + AnalysisResult.nodeValuesToString(this.nodeValues));
        result.add("treeLookup = " + AnalysisResult.treeLookupToString(this.treeLookup));
        result.add("postfixLookup = " + this.postfixLookup);
        result.add("finalLocalValues = " + this.finalLocalValues);
        result.add("inputs = " + this.inputs);
        result.add("analysisCaches = " + this.analysisCaches);
        return result.toString();
    }

    public static <V> String nodeValuesToString(Map<Node, V> nodeValues) {
        if (nodeValues.isEmpty()) {
            return "{}";
        }
        StringJoiner result = new StringJoiner(String.format("%n    ", new Object[0]));
        result.add("{");
        for (Map.Entry<Node, V> entry : nodeValues.entrySet()) {
            Node key = entry.getKey();
            result.add(String.format("%s => %s", key.toStringDebug(), entry.getValue()));
        }
        result.add("}");
        return result.toString();
    }

    public static String treeLookupToString(Map<Tree, Set<Node>> treeLookup) {
        if (treeLookup.isEmpty()) {
            return "{}";
        }
        StringJoiner result = new StringJoiner(String.format("%n    ", new Object[0]));
        result.add("{");
        for (Map.Entry<Tree, Set<Node>> entry : treeLookup.entrySet()) {
            Tree key = entry.getKey();
            result.add(TreeUtils.toStringTruncated(key, 65) + " => " + Node.nodeCollectionToString((Collection<? extends Node>)entry.getValue()));
        }
        result.add("}");
        return result.toString();
    }
}

