/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.org.plumelib.util.UtilPlume;
import org.checkerframework.shaded.dataflow.expression.Receiver;

public class ArrayCreation
extends Receiver {
    protected final List<? extends @Nullable Receiver> dimensions;
    protected final List<Receiver> initializers;

    public ArrayCreation(TypeMirror type, List<? extends @Nullable Receiver> dimensions, List<Receiver> initializers) {
        super(type);
        this.dimensions = dimensions;
        this.initializers = initializers;
    }

    public List<? extends @Nullable Receiver> getDimensions() {
        return this.dimensions;
    }

    public List<Receiver> getInitializers() {
        return this.initializers;
    }

    @Override
    public boolean containsOfClass(Class<? extends Receiver> clazz) {
        for (Receiver receiver : this.dimensions) {
            if (receiver == null || receiver.getClass() != clazz) continue;
            return true;
        }
        for (Receiver receiver : this.initializers) {
            if (receiver.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return false;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.initializers, this.getType().toString());
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayCreation)) {
            return false;
        }
        ArrayCreation other = (ArrayCreation)obj;
        return this.dimensions.equals(other.getDimensions()) && this.initializers.equals(other.getInitializers()) && this.getType().toString().equals(other.getType().toString());
    }

    @Override
    public boolean syntacticEquals(Receiver other) {
        return this.equals(other);
    }

    @Override
    public boolean containsSyntacticEqualReceiver(Receiver other) {
        return this.syntacticEquals(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("new " + this.type);
        if (!this.dimensions.isEmpty()) {
            for (Receiver receiver : this.dimensions) {
                sb.append("[");
                sb.append(receiver == null ? "" : receiver);
                sb.append("]");
            }
        }
        if (!this.initializers.isEmpty()) {
            sb.append(" {");
            sb.append(UtilPlume.join((CharSequence)", ", this.initializers));
            sb.append("}");
        }
        return sb.toString();
    }
}

