/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.Pretty;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.shaded.dataflow.expression.Receiver;

public class BinaryOperation
extends Receiver {
    protected final Tree.Kind operationKind;
    protected final JCTree.Tag tag;
    protected final Receiver left;
    protected final Receiver right;

    public BinaryOperation(BinaryOperationNode node, Receiver left, Receiver right) {
        super(node.getType());
        this.operationKind = node.getTree().getKind();
        this.tag = ((JCTree)((Object)node.getTree())).getTag();
        this.left = left;
        this.right = right;
    }

    public Tree.Kind getOperationKind() {
        return this.operationKind;
    }

    public Receiver getLeft() {
        return this.left;
    }

    public Receiver getRight() {
        return this.right;
    }

    @Override
    public boolean containsOfClass(Class<? extends Receiver> clazz) {
        if (this.getClass() == clazz) {
            return true;
        }
        return this.left.containsOfClass(clazz) || this.right.containsOfClass(clazz);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.left.isUnassignableByOtherCode() && this.right.isUnassignableByOtherCode();
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.left.isUnmodifiableByOtherCode() && this.right.isUnmodifiableByOtherCode();
    }

    @Override
    public boolean syntacticEquals(Receiver other) {
        if (!(other instanceof BinaryOperation)) {
            return false;
        }
        BinaryOperation biOp = (BinaryOperation)other;
        if (this.operationKind != biOp.getOperationKind()) {
            return false;
        }
        return this.left.equals(biOp.left) && this.right.equals(biOp.right);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
        return this.left.containsModifiableAliasOf(store, other) || this.right.containsModifiableAliasOf(store, other);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operationKind, this.left, this.right});
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BinaryOperation)) {
            return false;
        }
        BinaryOperation biOp = (BinaryOperation)other;
        if (this.operationKind != biOp.getOperationKind()) {
            return false;
        }
        if (this.isCommutative()) {
            return this.left.equals(biOp.left) && this.right.equals(biOp.right) || this.left.equals(biOp.right) && this.right.equals(biOp.left);
        }
        return this.left.equals(biOp.left) && this.right.equals(biOp.right);
    }

    private boolean isCommutative() {
        switch (this.operationKind) {
            case PLUS: 
            case MULTIPLY: 
            case AND: 
            case OR: 
            case XOR: 
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        Pretty pretty = new Pretty(null, true);
        StringBuilder result = new StringBuilder();
        result.append(this.left.toString());
        result.append(pretty.operatorName(this.tag));
        result.append(this.right.toString());
        return result.toString();
    }
}

