/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.analysis.Store;
import org.checkerframework.shaded.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.shaded.dataflow.expression.Receiver;
import org.checkerframework.shaded.javacutil.TypesUtils;

public class ValueLiteral
extends Receiver {
    protected final @Nullable Object value;

    public ValueLiteral(TypeMirror type, ValueLiteralNode node) {
        super(type);
        this.value = node.getValue();
    }

    public ValueLiteral(TypeMirror type, Object value) {
        super(type);
        this.value = value;
    }

    @Override
    public boolean containsOfClass(Class<? extends Receiver> clazz) {
        return this.getClass() == clazz;
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return true;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return true;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ValueLiteral)) {
            return false;
        }
        ValueLiteral other = (ValueLiteral)obj;
        return this.type.toString().equals(other.type.toString()) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        if (TypesUtils.isString(this.type)) {
            return "\"" + this.value + "\"";
        }
        if (this.type.getKind() == TypeKind.LONG) {
            assert (this.value != null) : "@AssumeAssertion(nullness): invariant";
            return this.value.toString() + "L";
        }
        if (this.type.getKind() == TypeKind.CHAR) {
            return "'" + this.value + "'";
        }
        return this.value == null ? "null" : this.value.toString();
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type.toString());
    }

    @Override
    public boolean syntacticEquals(Receiver other) {
        return this.equals(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, Receiver other) {
        return false;
    }

    public @Nullable Object getValue() {
        return this.value;
    }
}

