/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.dataflow.cfg.node.AssignmentContext;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.InternalUtils;

public class MethodInvocationNode
extends Node {
    protected MethodInvocationTree tree;
    protected MethodAccessNode target;
    protected List<Node> arguments;
    protected TreePath treePath;

    public MethodInvocationNode(MethodInvocationTree tree, MethodAccessNode target, List<Node> arguments, TreePath treePath) {
        super(tree != null ? InternalUtils.typeOf((Tree)tree) : target.getMethod().getReturnType());
        this.tree = tree;
        this.target = target;
        this.arguments = arguments;
        this.treePath = treePath;
        int i = 0;
        for (Node arg : arguments) {
            AssignmentContext.MethodParameterContext ctx = new AssignmentContext.MethodParameterContext(target.getMethod(), i++);
            arg.setAssignmentContext(ctx);
        }
    }

    public MethodInvocationNode(MethodAccessNode target, List<Node> arguments, TreePath treePath) {
        this(null, target, arguments, treePath);
    }

    public MethodAccessNode getTarget() {
        return this.target;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    @Override
    public MethodInvocationTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitMethodInvocation(this, p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.target);
        sb.append("(");
        boolean needComma = false;
        for (Node arg : this.arguments) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(arg);
            needComma = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MethodInvocationNode)) {
            return false;
        }
        MethodInvocationNode other = (MethodInvocationNode)obj;
        return this.getTarget().equals(other.getTarget()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        int hash = 0;
        hash = HashCodeUtils.hash((Object)this.target);
        for (Node arg : this.arguments) {
            hash = HashCodeUtils.hash(hash, arg.hashCode());
        }
        return hash;
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.target);
        list.addAll(this.arguments);
        return list;
    }
}

