/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.Node;

public class AnalysisResult<A extends AbstractValue<A>, S extends Store<S>> {
    protected final IdentityHashMap<Node, A> nodeValues;
    protected final IdentityHashMap<Tree, Node> treeLookup;
    protected final IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup;
    protected final HashMap<Element, A> finalLocalValues;
    protected final IdentityHashMap<Block, TransferInput<A, S>> stores;
    protected final IdentityHashMap<Tree, List<Tree>> generatedTreesLookup;
    protected final Map<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>> analysisCaches;

    public AnalysisResult(Map<Node, A> nodeValues, IdentityHashMap<Block, TransferInput<A, S>> stores, IdentityHashMap<Tree, Node> treeLookup, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookup, HashMap<Element, A> finalLocalValues, IdentityHashMap<Tree, List<Tree>> generatedTreesLookup) {
        this.nodeValues = new IdentityHashMap<Node, A>(nodeValues);
        this.treeLookup = new IdentityHashMap<Tree, Node>(treeLookup);
        this.unaryAssignNodeLookup = new IdentityHashMap<UnaryTree, AssignmentNode>(unaryAssignNodeLookup);
        this.stores = stores;
        this.finalLocalValues = finalLocalValues;
        this.generatedTreesLookup = new IdentityHashMap<Tree, List<Tree>>(generatedTreesLookup);
        this.analysisCaches = new IdentityHashMap<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>>();
    }

    public AnalysisResult() {
        this.nodeValues = new IdentityHashMap();
        this.treeLookup = new IdentityHashMap();
        this.unaryAssignNodeLookup = new IdentityHashMap();
        this.stores = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
        this.generatedTreesLookup = new IdentityHashMap();
        this.analysisCaches = new IdentityHashMap<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>>();
    }

    public AnalysisResult(Map<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>> analysisCaches) {
        this.nodeValues = new IdentityHashMap();
        this.treeLookup = new IdentityHashMap();
        this.unaryAssignNodeLookup = new IdentityHashMap();
        this.stores = new IdentityHashMap();
        this.finalLocalValues = new HashMap();
        this.generatedTreesLookup = new IdentityHashMap();
        this.analysisCaches = analysisCaches;
    }

    public void combine(AnalysisResult<A, S> other) {
        this.nodeValues.putAll(other.nodeValues);
        this.treeLookup.putAll(other.treeLookup);
        this.unaryAssignNodeLookup.putAll(other.unaryAssignNodeLookup);
        this.stores.putAll(other.stores);
        this.finalLocalValues.putAll(other.finalLocalValues);
        this.generatedTreesLookup.putAll(other.generatedTreesLookup);
    }

    public HashMap<Element, A> getFinalLocalValues() {
        return this.finalLocalValues;
    }

    public A getValue(Node n) {
        return (A)((AbstractValue)this.nodeValues.get(n));
    }

    public A getValue(Tree t) {
        A val = this.getValue(this.treeLookup.get(t));
        return val;
    }

    public Node getNodeForTree(Tree tree) {
        return this.treeLookup.get(tree);
    }

    public AssignmentNode getAssignForUnaryTree(UnaryTree tree) {
        assert (this.unaryAssignNodeLookup.containsKey(tree)) : tree + " is not in unaryAssignNodeLookup";
        return this.unaryAssignNodeLookup.get(tree);
    }

    public List<Tree> getGeneratedTrees(Tree tree) {
        if (this.generatedTreesLookup.containsKey(tree)) {
            return this.generatedTreesLookup.get(tree);
        }
        return Collections.emptyList();
    }

    public S getStoreBefore(Tree tree) {
        Node node = this.getNodeForTree(tree);
        if (node == null) {
            return null;
        }
        return this.getStoreBefore(node);
    }

    public S getStoreBefore(Node node) {
        return this.runAnalysisFor(node, true);
    }

    public S getStoreAfter(Tree tree) {
        Node node = this.getNodeForTree(tree);
        if (node == null) {
            return null;
        }
        return this.getStoreAfter(node);
    }

    public S getStoreAfter(Node node) {
        return this.runAnalysisFor(node, false);
    }

    protected S runAnalysisFor(Node node, boolean before) {
        Block block = node.getBlock();
        TransferInput<A, S> transferInput = this.stores.get(block);
        if (transferInput == null) {
            return null;
        }
        return AnalysisResult.runAnalysisFor(node, before, transferInput, this.analysisCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <A extends AbstractValue<A>, S extends Store<S>> S runAnalysisFor(Node node, boolean before, TransferInput<A, S> transferInput, Map<TransferInput<A, S>, IdentityHashMap<Node, TransferResult<A, S>>> analysisCaches) {
        IdentityHashMap<Node, TransferResult<A, S>> cache;
        assert (node != null);
        Block block = node.getBlock();
        assert (transferInput != null);
        Analysis<A, S, ?> analysis = transferInput.analysis;
        Node oldCurrentNode = analysis.currentNode;
        if (analysisCaches != null) {
            cache = analysisCaches.get(transferInput);
            if (cache == null) {
                cache = new IdentityHashMap();
                analysisCaches.put(transferInput, cache);
            }
        } else {
            cache = null;
        }
        if (analysis.isRunning) {
            return analysis.currentInput.getRegularStore();
        }
        analysis.isRunning = true;
        try {
            switch (block.getType()) {
                case REGULAR_BLOCK: {
                    RegularBlock rb = (RegularBlock)block;
                    TransferInput<A, Object> store = transferInput;
                    TransferResult transferResult = null;
                    Iterator<Node> iterator = rb.getContents().iterator();
                    while (iterator.hasNext()) {
                        Node n;
                        analysis.currentNode = n = iterator.next();
                        if (n == node && before) {
                            S s = store.getRegularStore();
                            return s;
                        }
                        if (cache != null && cache.containsKey(n)) {
                            transferResult = cache.get(n);
                        } else {
                            transferResult = analysis.callTransferFunction(n, store.copy());
                            if (cache != null) {
                                cache.put(n, transferResult);
                            }
                        }
                        if (n == node) {
                            Object s = transferResult.getRegularStore();
                            return s;
                        }
                        store = new TransferInput(n, analysis, transferResult);
                    }
                    assert (false);
                    iterator = null;
                    return (S)iterator;
                }
                case EXCEPTION_BLOCK: {
                    ExceptionBlock eb = (ExceptionBlock)block;
                    assert (eb.getNode() == node);
                    if (before) {
                        S store = transferInput.getRegularStore();
                        return store;
                    }
                    analysis.currentNode = node;
                    TransferResult transferResult = analysis.callTransferFunction(node, transferInput);
                    Object s = transferResult.getRegularStore();
                    return s;
                }
            }
            assert (false);
            S s = null;
            return s;
        }
        finally {
            analysis.currentNode = oldCurrentNode;
            analysis.isRunning = false;
        }
    }
}

