/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.analysis;

import java.util.Map;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferResult;

public class ConditionalTransferResult<A extends AbstractValue<A>, S extends Store<S>>
extends TransferResult<A, S> {
    private final boolean storeChanged;
    protected final S thenStore;
    protected final S elseStore;

    public ConditionalTransferResult(@Nullable A value, S thenStore, S elseStore, boolean storeChanged) {
        this(value, thenStore, elseStore, null, storeChanged);
    }

    public ConditionalTransferResult(@Nullable A value, S thenStore, S elseStore) {
        this(value, thenStore, elseStore, false);
    }

    public ConditionalTransferResult(A value, S thenStore, S elseStore, Map<TypeMirror, S> exceptionalStores) {
        this(value, thenStore, elseStore, exceptionalStores, false);
    }

    public ConditionalTransferResult(@Nullable A value, S thenStore, S elseStore, @Nullable Map<TypeMirror, S> exceptionalStores, boolean storeChanged) {
        super(value, exceptionalStores);
        this.thenStore = thenStore;
        this.elseStore = elseStore;
        this.storeChanged = storeChanged;
    }

    @Override
    public S getRegularStore() {
        return this.thenStore.leastUpperBound(this.elseStore);
    }

    @Override
    public S getThenStore() {
        return this.thenStore;
    }

    @Override
    public S getElseStore() {
        return this.elseStore;
    }

    @Override
    public boolean containsTwoStores() {
        return true;
    }

    public String toString() {
        StringJoiner result = new StringJoiner(System.lineSeparator());
        result.add("RegularTransferResult(");
        result.add("  resultValue = " + this.resultValue);
        result.add("  thenStore = " + this.thenStore);
        result.add("  elseStore = " + this.elseStore);
        result.add(")");
        return result.toString();
    }

    @Override
    public boolean storeChanged() {
        return this.storeChanged;
    }
}

