/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.Element;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.javacutil.TreeUtils;

public class LocalVariableNode
extends Node {
    protected final Tree tree;
    protected final @Nullable Node receiver;

    public LocalVariableNode(Tree t) {
        this(t, null);
    }

    public LocalVariableNode(Tree t, @Nullable Node receiver) {
        super(TreeUtils.typeOf((Tree)t));
        assert (t != null);
        assert (t instanceof IdentifierTree || t instanceof VariableTree);
        this.tree = t;
        this.receiver = receiver;
    }

    public Element getElement() {
        Element el;
        if (this.tree instanceof IdentifierTree) {
            IdentifierTree itree = (IdentifierTree)this.tree;
            assert (TreeUtils.isUseOfElement((ExpressionTree)itree)) : "@AssumeAssertion(nullness): tree kind";
            el = TreeUtils.elementFromUse((ExpressionTree)itree);
        } else {
            assert (this.tree instanceof VariableTree);
            el = TreeUtils.elementFromDeclaration((VariableTree)((VariableTree)this.tree));
        }
        return el;
    }

    public @Nullable Node getReceiver() {
        return this.receiver;
    }

    public String getName() {
        if (this.tree instanceof IdentifierTree) {
            return ((IdentifierTree)this.tree).getName().toString();
        }
        return ((VariableTree)this.tree).getName().toString();
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLocalVariable(this, p);
    }

    public String toString() {
        return this.getName().toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LocalVariableNode)) {
            return false;
        }
        LocalVariableNode other = (LocalVariableNode)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

