/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.util.AbstractMostlySingleton;
import org.checkerframework.javacutil.BugInCF;

public final class IdentityMostlySingleton<T>
extends AbstractMostlySingleton<T> {
    public IdentityMostlySingleton() {
        super(AbstractMostlySingleton.State.EMPTY);
    }

    public IdentityMostlySingleton(T value) {
        super(AbstractMostlySingleton.State.SINGLETON, value);
    }

    @Override
    public boolean add(T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingleton.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                this.state = AbstractMostlySingleton.State.ANY;
                this.set = new ArrayList();
                assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
                this.set.add(this.value);
                this.value = null;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    @Override
    public boolean contains(@Nullable Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return o == this.value;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }
}

