/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.AbstractCFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.UserError;

public class DOTCFGVisualizer<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>>
extends AbstractCFGVisualizer<A, S, T> {
    protected String outDir;
    protected @Nullable String checkerName;
    protected Map<String, String> generated;
    protected static final String leftJustifiedTerminator = "\\l";

    @Override
    public void init(Map<String, Object> args) {
        super.init(args);
        this.outDir = (String)args.get("outdir");
        if (this.outDir == null) {
            throw new BugInCF("outDir should never be null, provide it in args when calling DOTCFGVisualizer.init(args).");
        }
        this.checkerName = (String)args.get("checkerName");
        this.generated = new HashMap<String, String>();
    }

    @Override
    public @Nullable Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<A, S, T> analysis) {
        String dotGraph = this.visualizeGraph(cfg, entry, analysis);
        String dotFileName = this.dotOutputFileName(cfg.underlyingAST);
        try {
            FileWriter fStream = new FileWriter(dotFileName);
            BufferedWriter out = new BufferedWriter(fStream);
            out.write(dotGraph);
            out.close();
        }
        catch (IOException e) {
            throw new UserError("Error creating dot file (is the path valid?): " + dotFileName, new Object[]{e});
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("dotFileName", dotFileName);
        return res;
    }

    @Override
    public String visualizeNodes(Set<Block> blocks, ControlFlowGraph cfg, @Nullable Analysis<A, S, T> analysis) {
        StringBuilder sbDotNodes = new StringBuilder();
        sbDotNodes.append(this.lineSeparator);
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        for (Block v : blocks) {
            String strBlock;
            sbDotNodes.append("    ").append(v.getId()).append(" [");
            if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sbDotNodes.append("shape=polygon sides=8 ");
            } else if (v.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sbDotNodes.append("shape=oval ");
            } else {
                sbDotNodes.append("shape=rectangle ");
            }
            sbDotNodes.append("label=\"");
            if (this.verbose) {
                sbDotNodes.append(this.getProcessOrderSimpleString(processOrder.get(v))).append(leftJustifiedTerminator);
            }
            if ((strBlock = this.visualizeBlock(v, analysis)).length() == 0) {
                if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                    sbDotNodes.append("\"];").append(this.lineSeparator);
                    continue;
                }
                sbDotNodes.append("?? empty ??\"];").append(this.lineSeparator);
                continue;
            }
            sbDotNodes.append(strBlock).append("\"];").append(this.lineSeparator);
        }
        return sbDotNodes.toString();
    }

    @Override
    protected String addEdge(long sId, long eId, String flowRule) {
        return "    " + sId + " -> " + eId + " [label=\"" + flowRule + "\"];" + this.lineSeparator;
    }

    @Override
    public String visualizeBlock(Block bb, @Nullable Analysis<A, S, T> analysis) {
        return super.visualizeBlockHelper(bb, analysis, leftJustifiedTerminator);
    }

    @Override
    public String visualizeSpecialBlock(SpecialBlock sbb) {
        return super.visualizeSpecialBlockHelper(sbb, "");
    }

    @Override
    public String visualizeBlockTransferInput(Block bb, Analysis<A, S, T> analysis) {
        return super.visualizeBlockTransferInputHelper(bb, analysis, leftJustifiedTerminator);
    }

    protected String dotOutputFileName(UnderlyingAST ast) {
        StringBuilder srcLoc = new StringBuilder();
        StringBuilder outFile = new StringBuilder(this.outDir);
        outFile.append("/");
        if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            UnderlyingAST.CFGStatement cfgStatement = (UnderlyingAST.CFGStatement)ast;
            String clsName = cfgStatement.getClassTree().getSimpleName().toString();
            outFile.append(clsName);
            outFile.append("-initializer-");
            outFile.append(ast.hashCode());
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::initializer::");
            srcLoc.append(((JCTree)cfgStatement.getCode()).pos);
            srcLoc.append(">");
        } else if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)ast;
            String clsName = cfgMethod.getClassTree().getSimpleName().toString();
            String methodName = cfgMethod.getMethod().getName().toString();
            outFile.append(clsName);
            outFile.append("-");
            outFile.append(methodName);
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::");
            srcLoc.append(methodName);
            srcLoc.append("(");
            srcLoc.append(cfgMethod.getMethod().getParameters());
            srcLoc.append(")::");
            srcLoc.append(((JCTree)((Object)cfgMethod.getMethod())).pos);
            srcLoc.append(">");
        } else {
            throw new BugInCF("Unexpected AST kind: " + (Object)((Object)ast.getKind()) + " value: " + ast);
        }
        if (this.checkerName != null && !this.checkerName.isEmpty()) {
            outFile.append('-');
            outFile.append(this.checkerName);
        }
        outFile.append(".dot");
        String outFileName = outFile.toString().replace("<", "_").replace(">", "");
        this.generated.put(srcLoc.toString(), outFileName);
        return outFileName;
    }

    @Override
    public String visualizeBlockNode(Node t, @Nullable Analysis<A, S, T> analysis) {
        A value;
        StringBuilder sbBlockNode = new StringBuilder();
        sbBlockNode.append(this.escapeDoubleQuotes(t)).append("   [ ").append(this.getNodeSimpleName(t)).append(" ]");
        if (analysis != null && (value = analysis.getValue(t)) != null) {
            sbBlockNode.append("    > ").append(this.escapeDoubleQuotes(value));
        }
        return sbBlockNode.toString();
    }

    @Override
    public String visualizeStoreThisVal(A value) {
        return "  this > " + value + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreLocalVar(FlowExpressions.LocalVariable localVar, A value) {
        return "  " + localVar + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreFieldVals(FlowExpressions.FieldAccess fieldAccess, A value) {
        return "  " + fieldAccess + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreArrayVal(FlowExpressions.ArrayAccess arrayValue, A value) {
        return "  " + arrayValue + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreMethodVals(FlowExpressions.MethodCall methodCall, A value) {
        return "  " + this.escapeDoubleQuotes(methodCall) + " > " + value + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreClassVals(FlowExpressions.ClassName className, A value) {
        return "  " + className + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreKeyVal(String keyName, Object value) {
        return "  " + keyName + " = " + value + leftJustifiedTerminator;
    }

    private String escapeDoubleQuotes(String str) {
        return str.replace("\"", "\\\"");
    }

    private String escapeDoubleQuotes(Object obj) {
        return this.escapeDoubleQuotes(String.valueOf(obj));
    }

    @Override
    public String visualizeStoreHeader(String classCanonicalName) {
        return classCanonicalName + " (" + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreFooter() {
        return ")";
    }

    @Override
    public void shutdown() {
        try {
            FileWriter fstream = new FileWriter(this.outDir + "/methods.txt", true);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Map.Entry<String, String> kv : this.generated.entrySet()) {
                out.write(kv.getKey());
                out.append("\t");
                out.write(kv.getValue());
                out.append(this.lineSeparator);
            }
            out.close();
        }
        catch (IOException e) {
            throw new UserError("Error creating methods.txt file in: " + this.outDir + "; ensure the path is valid", new Object[]{e});
        }
    }

    @Override
    protected String visualizeGraphHeader() {
        return "digraph {" + this.lineSeparator;
    }

    @Override
    protected String visualizeGraphFooter() {
        return "}" + this.lineSeparator;
    }
}

