/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.javacutil.TypesUtils;

public class NarrowingConversionNode
extends Node {
    protected final Tree tree;
    protected final Node operand;

    public NarrowingConversionNode(Tree tree, Node operand, TypeMirror type) {
        super(type);
        assert (TypesUtils.isPrimitive((TypeMirror)type)) : "non-primitive type in narrowing conversion";
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitNarrowingConversion(this, p);
    }

    public String toString() {
        return "NarrowingConversion(" + this.getOperand() + ", " + this.type + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof NarrowingConversionNode)) {
            return false;
        }
        NarrowingConversionNode other = (NarrowingConversionNode)obj;
        return this.getOperand().equals(other.getOperand()) && TypesUtils.areSamePrimitiveTypes((TypeMirror)this.getType(), (TypeMirror)other.getType());
    }

    public int hashCode() {
        return Objects.hash(NarrowingConversionNode.class, this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

