/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.builder;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.builder.CFGBuilder;
import org.checkerframework.dataflow.cfg.builder.ConditionalJump;
import org.checkerframework.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.dataflow.cfg.builder.Label;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ReturnNode;

public class PhaseOneResult {
    final IdentityHashMap<Tree, Set<Node>> treeLookupMap;
    final IdentityHashMap<Tree, Set<Node>> convertedTreeLookupMap;
    final IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookupMap;
    final UnderlyingAST underlyingAST;
    final Map<Label, Integer> bindings;
    final ArrayList<ExtendedNode> nodeList;
    final Set<Integer> leaders;
    final List<ReturnNode> returnNodes;
    final Label regularExitLabel;
    final Label exceptionalExitLabel;
    final List<ClassTree> declaredClasses;
    final List<LambdaExpressionTree> declaredLambdas;

    public PhaseOneResult(UnderlyingAST underlyingAST, IdentityHashMap<Tree, Set<Node>> treeLookupMap, IdentityHashMap<Tree, Set<Node>> convertedTreeLookupMap, IdentityHashMap<UnaryTree, AssignmentNode> unaryAssignNodeLookupMap, ArrayList<ExtendedNode> nodeList, Map<Label, Integer> bindings, Set<Integer> leaders, List<ReturnNode> returnNodes, Label regularExitLabel, Label exceptionalExitLabel, List<ClassTree> declaredClasses, List<LambdaExpressionTree> declaredLambdas) {
        this.underlyingAST = underlyingAST;
        this.treeLookupMap = treeLookupMap;
        this.convertedTreeLookupMap = convertedTreeLookupMap;
        this.unaryAssignNodeLookupMap = unaryAssignNodeLookupMap;
        this.nodeList = nodeList;
        this.bindings = bindings;
        this.leaders = leaders;
        this.returnNodes = returnNodes;
        this.regularExitLabel = regularExitLabel;
        this.exceptionalExitLabel = exceptionalExitLabel;
        this.declaredClasses = declaredClasses;
        this.declaredLambdas = declaredLambdas;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(System.lineSeparator());
        for (ExtendedNode n : this.nodeList) {
            sj.add(this.nodeToString(n));
        }
        return sj.toString();
    }

    protected String nodeToString(ExtendedNode n) {
        if (n.getType() == ExtendedNode.ExtendedNodeType.CONDITIONAL_JUMP) {
            ConditionalJump t = (ConditionalJump)n;
            return "TwoTargetConditionalJump(" + this.resolveLabel(t.getThenLabel()) + ", " + this.resolveLabel(t.getElseLabel()) + ")";
        }
        if (n.getType() == ExtendedNode.ExtendedNodeType.UNCONDITIONAL_JUMP) {
            return "UnconditionalJump(" + this.resolveLabel(n.getLabel()) + ")";
        }
        return n.toString();
    }

    private String resolveLabel(Label label) {
        Integer index = this.bindings.get(label);
        if (index == null) {
            return "unbound label: " + label;
        }
        return this.nodeToString(this.nodeList.get(index));
    }

    public String toStringDebug() {
        StringJoiner result = new StringJoiner(String.format("%n  ", new Object[0]), String.format("PhaseOneResult{%n  ", new Object[0]), String.format("%n  }", new Object[0]));
        result.add("treeLookupMap=" + this.treeLookupMap);
        result.add("convertedTreeLookupMap=" + this.convertedTreeLookupMap);
        result.add("unaryAssignNodeLookupMap=" + this.unaryAssignNodeLookupMap);
        result.add("underlyingAST=" + this.underlyingAST);
        result.add("bindings=" + this.bindings);
        result.add("nodeList=" + CFGBuilder.extendedNodeCollectionToStringDebug(this.nodeList));
        result.add("leaders=" + this.leaders);
        result.add("returnNodes=" + Node.nodeCollectionToString(this.returnNodes));
        result.add("regularExitLabel=" + this.regularExitLabel);
        result.add("exceptionalExitLabel=" + this.exceptionalExitLabel);
        result.add("declaredClasses=" + this.declaredClasses);
        result.add("declaredLambdas=" + this.declaredLambdas);
        return result.toString();
    }
}

