/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.visualize;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGProcessor;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.visualize.DOTCFGVisualizer;
import org.checkerframework.dataflow.cfg.visualize.StringCFGVisualizer;

public class CFGVisualizeLauncher {
    public static void main(String[] args) {
        String input;
        File file;
        CFGVisualizeLauncher cfgVisualizeLauncher = new CFGVisualizeLauncher();
        if (args.length == 0) {
            cfgVisualizeLauncher.printUsage();
            System.exit(1);
        }
        if (!(file = new File(input = args[0])).canRead()) {
            cfgVisualizeLauncher.printError("Cannot read input file: " + file.getAbsolutePath());
            cfgVisualizeLauncher.printUsage();
            System.exit(1);
        }
        String method = "test";
        String clas = "Test";
        String output = ".";
        boolean pdf = false;
        boolean error = false;
        boolean verbose = false;
        boolean string = false;
        block16: for (int i = 1; i < args.length; ++i) {
            switch (args[i]) {
                case "--outputdir": {
                    if (i >= args.length - 1) {
                        cfgVisualizeLauncher.printError("Did not find <outputdir> after --outputdir.");
                        continue block16;
                    }
                    output = args[++i];
                    continue block16;
                }
                case "--pdf": {
                    pdf = true;
                    continue block16;
                }
                case "--method": {
                    if (i >= args.length - 1) {
                        cfgVisualizeLauncher.printError("Did not find <name> after --method.");
                        continue block16;
                    }
                    method = args[++i];
                    continue block16;
                }
                case "--class": {
                    if (i >= args.length - 1) {
                        cfgVisualizeLauncher.printError("Did not find <name> after --class.");
                        continue block16;
                    }
                    clas = args[++i];
                    continue block16;
                }
                case "--verbose": {
                    verbose = true;
                    continue block16;
                }
                case "--string": {
                    string = true;
                    continue block16;
                }
                default: {
                    cfgVisualizeLauncher.printError("Unknown command line argument: " + args[i]);
                    error = true;
                }
            }
        }
        if (error) {
            System.exit(1);
        }
        if (!string) {
            cfgVisualizeLauncher.generateDOTofCFGWithoutAnalysis(input, output, method, clas, pdf, verbose);
        } else {
            String stringGraph = cfgVisualizeLauncher.generateStringOfCFGWithoutAnalysis(input, method, clas, verbose);
            System.out.println(stringGraph);
        }
    }

    protected void generateDOTofCFGWithoutAnalysis(String inputFile, String outputDir, String method, String clas, boolean pdf, boolean verbose) {
        this.generateDOTofCFG(inputFile, outputDir, method, clas, pdf, verbose, null);
    }

    protected String generateStringOfCFGWithoutAnalysis(String inputFile, String method, String clas, boolean verbose) {
        @Nullable Map<String, Object> res = this.generateStringOfCFG(inputFile, method, clas, verbose, null);
        if (res != null) {
            String stringGraph = (String)res.get("stringGraph");
            if (stringGraph == null) {
                return "Unexpected output from generating string control flow graph, shouldn't be null.";
            }
            return stringGraph;
        }
        return "Unexpected output from generating string control flow graph, shouldn't be null.";
    }

    public <V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>> void generateDOTofCFG(String inputFile, String outputDir, String method, String clas, boolean pdf, boolean verbose, @Nullable Analysis<V, S, T> analysis) {
        ControlFlowGraph cfg = this.generateMethodCFG(inputFile, clas, method);
        if (analysis != null) {
            analysis.performAnalysis(cfg);
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("outdir", outputDir);
        args.put("verbose", verbose);
        DOTCFGVisualizer<V, S, T> viz = new DOTCFGVisualizer<V, S, T>();
        viz.init(args);
        Map<String, Object> res = viz.visualize(cfg, cfg.getEntryBlock(), analysis);
        viz.shutdown();
        if (pdf && res != null) {
            assert (res.get("dotFileName") != null) : "@AssumeAssertion(nullness): specification";
            this.producePDF((String)res.get("dotFileName"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ControlFlowGraph generateMethodCFG(String file, String clas, String method) {
        CFGProcessor cfgProcessor = new CFGProcessor(clas, method);
        Context context = new Context();
        Options.instance(context).put("compilePolicy", "ATTR_ONLY");
        JavaCompiler javac = new JavaCompiler(context);
        JavacFileManager fileManager = (JavacFileManager)context.get(JavaFileManager.class);
        JavaFileObject l = fileManager.getJavaFileObjectsFromStrings(List.of(file)).iterator().next();
        PrintStream err = System.err;
        try {
            System.setErr(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            javac.compile(List.of(l), List.of(clas), List.of(cfgProcessor), List.nil());
        }
        catch (Throwable throwable) {
        }
        finally {
            System.setErr(err);
        }
        CFGProcessor.CFGProcessResult res = cfgProcessor.getCFGProcessResult();
        if (res == null) {
            this.printError("internal error in type processor! method typeProcessOver() doesn't get called.");
            System.exit(1);
        }
        if (!res.isSuccess()) {
            this.printError(res.getErrMsg());
            System.exit(1);
        }
        return res.getCFG();
    }

    protected void producePDF(String file) {
        try {
            String command = "dot -Tpdf \"" + file + "\" -o \"" + file + ".pdf\"";
            Process child = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
            child.waitFor();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public <V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>> @Nullable Map<String, Object> generateStringOfCFG(String inputFile, String method, String clas, boolean verbose, @Nullable Analysis<V, S, T> analysis) {
        ControlFlowGraph cfg = this.generateMethodCFG(inputFile, clas, method);
        if (analysis != null) {
            analysis.performAnalysis(cfg);
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("verbose", verbose);
        StringCFGVisualizer<V, S, T> viz = new StringCFGVisualizer<V, S, T>();
        viz.init(args);
        Map<String, Object> res = viz.visualize(cfg, cfg.getEntryBlock(), analysis);
        viz.shutdown();
        return res;
    }

    protected void printUsage() {
        System.out.println("Generate the control flow graph of a Java method, represented as a DOT or String graph.");
        System.out.println("Parameters: <inputfile> [--outputdir <outputdir>] [--method <name>] [--class <name>] [--pdf] [--verbose] [--string]");
        System.out.println("    --outputdir: The output directory for the generated files (defaults to '.').");
        System.out.println("    --method:    The method to generate the CFG for (defaults to 'test').");
        System.out.println("    --class:     The class in which to find the method (defaults to 'Test').");
        System.out.println("    --pdf:       Also generate the PDF by invoking 'dot'.");
        System.out.println("    --verbose:   Show the verbose output (defaults to 'false').");
        System.out.println("    --string:    Print the string representation of the control flow graph (defaults to 'false').");
    }

    protected void printError(@Nullable String string) {
        System.err.println("ERROR: " + string);
    }
}

