/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.ThisNode;
import org.checkerframework.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.expression.ArrayAccess;
import org.checkerframework.dataflow.expression.ArrayCreation;
import org.checkerframework.dataflow.expression.BinaryOperation;
import org.checkerframework.dataflow.expression.ClassName;
import org.checkerframework.dataflow.expression.FieldAccess;
import org.checkerframework.dataflow.expression.LocalVariable;
import org.checkerframework.dataflow.expression.MethodCall;
import org.checkerframework.dataflow.expression.ThisReference;
import org.checkerframework.dataflow.expression.UnaryOperation;
import org.checkerframework.dataflow.expression.Unknown;
import org.checkerframework.dataflow.expression.ValueLiteral;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreePathUtil;
import org.checkerframework.javacutil.TreeUtils;

public abstract class JavaExpression {
    protected final TypeMirror type;

    protected JavaExpression(TypeMirror type) {
        assert (type != null);
        this.type = type;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public abstract boolean containsOfClass(Class<? extends JavaExpression> var1);

    public boolean containsUnknown() {
        return this.containsOfClass(Unknown.class);
    }

    public abstract boolean isUnassignableByOtherCode();

    public abstract boolean isUnmodifiableByOtherCode();

    @EqualsMethod
    public abstract boolean syntacticEquals(JavaExpression var1);

    static boolean syntacticEqualsList(List<? extends @Nullable JavaExpression> lst1, List<? extends @Nullable JavaExpression> lst2) {
        if (lst1.size() != lst2.size()) {
            return false;
        }
        for (int i = 0; i < lst1.size(); ++i) {
            JavaExpression dim1 = lst1.get(i);
            JavaExpression dim2 = lst2.get(i);
            if (dim1 == null && dim2 == null) continue;
            if (dim1 == null || dim2 == null) {
                return false;
            }
            if (dim1.syntacticEquals(dim2)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean containsSyntacticEqualJavaExpression(JavaExpression var1);

    public static boolean listContainsSyntacticEqualJavaExpression(List<? extends @Nullable JavaExpression> list, JavaExpression other) {
        return list.stream().anyMatch(je -> je != null && je.containsSyntacticEqualJavaExpression(other));
    }

    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return this.equals(other) || store.canAlias(this, other);
    }

    public String toStringDebug() {
        return String.format("%s(%s): %s", this.getClass().getSimpleName(), this.type, this.toString());
    }

    public static FieldAccess fromNodeFieldAccess(AnnotationProvider provider, FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        JavaExpression receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : JavaExpression.fromNode(provider, receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess fromArrayAccess(AnnotationProvider provider, ArrayAccessNode node) {
        JavaExpression array = JavaExpression.fromNode(provider, node.getArray());
        JavaExpression index = JavaExpression.fromNode(provider, node.getIndex());
        return new ArrayAccess(node.getType(), array, index);
    }

    public static JavaExpression fromNode(AnnotationProvider provider, Node node) {
        return JavaExpression.fromNode(provider, node, false);
    }

    public static JavaExpression fromNode(AnnotationProvider provider, Node receiverNode, boolean allowNonDeterministic) {
        JavaExpression result = null;
        if (receiverNode instanceof FieldAccessNode) {
            FieldAccessNode fan = (FieldAccessNode)receiverNode;
            result = fan.getFieldName().equals("this") ? new ThisReference(fan.getReceiver().getType()) : (fan.getFieldName().equals("class") ? new ClassName(fan.getReceiver().getType()) : JavaExpression.fromNodeFieldAccess(provider, fan));
        } else if (receiverNode instanceof ExplicitThisNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            result = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            result = JavaExpression.fromArrayAccess(provider, a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return JavaExpression.fromNode(provider, ((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return JavaExpression.fromNode(provider, ((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return JavaExpression.fromNode(provider, ((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof UnaryOperationNode) {
                UnaryOperationNode uopn = (UnaryOperationNode)receiverNode;
                return new UnaryOperation(uopn, JavaExpression.fromNode(provider, uopn.getOperand(), allowNonDeterministic));
            }
            if (receiverNode instanceof BinaryOperationNode) {
                BinaryOperationNode bopn = (BinaryOperationNode)receiverNode;
                return new BinaryOperation(bopn, JavaExpression.fromNode(provider, bopn.getLeftOperand(), allowNonDeterministic), JavaExpression.fromNode(provider, bopn.getRightOperand(), allowNonDeterministic));
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                result = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                result = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof ArrayCreationNode) {
                ArrayCreationNode an = (ArrayCreationNode)receiverNode;
                ArrayList<@Nullable JavaExpression> dimensions = new ArrayList<JavaExpression>();
                for (Node node : an.getDimensions()) {
                    dimensions.add(JavaExpression.fromNode(provider, node, allowNonDeterministic));
                }
                ArrayList<JavaExpression> initializers = new ArrayList<JavaExpression>();
                for (Node initializer : an.getInitializers()) {
                    initializers.add(JavaExpression.fromNode(provider, initializer, allowNonDeterministic));
                }
                result = new ArrayCreation(an.getType(), dimensions, initializers);
            } else if (receiverNode instanceof MethodInvocationNode) {
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                MethodInvocationTree t = mn.getTree();
                if (t == null) {
                    throw new BugInCF("Unexpected null tree for node: " + mn);
                }
                assert (TreeUtils.isUseOfElement((ExpressionTree)t)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement invokedMethod = TreeUtils.elementFromUse((MethodInvocationTree)t);
                if (allowNonDeterministic || PurityUtils.isDeterministic(provider, invokedMethod)) {
                    ArrayList<JavaExpression> arrayList = new ArrayList<JavaExpression>();
                    for (Node p : mn.getArguments()) {
                        arrayList.add(JavaExpression.fromNode(provider, p));
                    }
                    JavaExpression methodReceiver = ElementUtils.isStatic((Element)invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : JavaExpression.fromNode(provider, mn.getTarget().getReceiver());
                    result = new MethodCall(mn.getType(), invokedMethod, methodReceiver, arrayList);
                }
            }
        }
        if (result == null) {
            result = new Unknown(receiverNode.getType());
        }
        return result;
    }

    public static JavaExpression fromTree(AnnotationProvider provider, ExpressionTree tree) {
        return JavaExpression.fromTree(provider, tree, true);
    }

    public static JavaExpression fromTree(AnnotationProvider provider, ExpressionTree tree, boolean allowNonDeterministic) {
        JavaExpression result;
        block0 : switch (tree.getKind()) {
            case ARRAY_ACCESS: {
                ArrayAccessTree a = (ArrayAccessTree)tree;
                JavaExpression arrayAccessExpression = JavaExpression.fromTree(provider, a.getExpression());
                JavaExpression index = JavaExpression.fromTree(provider, a.getIndex());
                result = new ArrayAccess(TreeUtils.typeOf((Tree)a), arrayAccessExpression, index);
                break;
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                LiteralTree vn = (LiteralTree)tree;
                result = new ValueLiteral(TreeUtils.typeOf((Tree)tree), vn.getValue());
                break;
            }
            case NEW_ARRAY: {
                NewArrayTree newArrayTree = (NewArrayTree)tree;
                ArrayList<JavaExpression> dimensions = new ArrayList<JavaExpression>();
                if (newArrayTree.getDimensions() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
                        dimensions.add(JavaExpression.fromTree(provider, expressionTree, allowNonDeterministic));
                    }
                }
                ArrayList<JavaExpression> initializers = new ArrayList<JavaExpression>();
                if (newArrayTree.getInitializers() != null) {
                    for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                        initializers.add(JavaExpression.fromTree(provider, expressionTree, allowNonDeterministic));
                    }
                }
                result = new ArrayCreation(TreeUtils.typeOf((Tree)tree), dimensions, initializers);
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                assert (TreeUtils.isUseOfElement((ExpressionTree)methodInvocationTree)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement executableElement = TreeUtils.elementFromUse((MethodInvocationTree)methodInvocationTree);
                if (PurityUtils.isDeterministic(provider, executableElement) || allowNonDeterministic) {
                    ArrayList<JavaExpression> parameters = new ArrayList<JavaExpression>();
                    for (ExpressionTree expressionTree : methodInvocationTree.getArguments()) {
                        parameters.add(JavaExpression.fromTree(provider, expressionTree));
                    }
                    JavaExpression methodReceiver = ElementUtils.isStatic((Element)executableElement) ? new ClassName(TreeUtils.typeOf((Tree)methodInvocationTree.getMethodSelect())) : JavaExpression.getReceiver(methodInvocationTree, provider);
                    TypeMirror typeMirror = TreeUtils.typeOf((Tree)methodInvocationTree);
                    result = new MethodCall(typeMirror, executableElement, methodReceiver, parameters);
                    break;
                }
                result = null;
                break;
            }
            case MEMBER_SELECT: {
                result = JavaExpression.fromMemberSelect(provider, (MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                IdentifierTree identifierTree = (IdentifierTree)tree;
                TypeMirror typeOfId = TreeUtils.typeOf((Tree)identifierTree);
                if (identifierTree.getName().contentEquals("this") || identifierTree.getName().contentEquals("super")) {
                    result = new ThisReference(typeOfId);
                    break;
                }
                assert (TreeUtils.isUseOfElement((ExpressionTree)identifierTree)) : "@AssumeAssertion(nullness): tree kind";
                Element element = TreeUtils.elementFromUse((ExpressionTree)identifierTree);
                if (ElementUtils.isTypeElement((Element)element)) {
                    result = new ClassName(element.asType());
                    break;
                }
                switch (element.getKind()) {
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: 
                    case EXCEPTION_PARAMETER: 
                    case PARAMETER: {
                        result = new LocalVariable(element);
                        break block0;
                    }
                    case FIELD: {
                        TypeMirror enclosingTypeElement = ElementUtils.enclosingTypeElement((Element)element).asType();
                        JavaExpression fieldAccessExpression = ElementUtils.isStatic((Element)element) ? new ClassName(enclosingTypeElement) : new ThisReference(enclosingTypeElement);
                        result = new FieldAccess(fieldAccessExpression, typeOfId, (VariableElement)element);
                        break block0;
                    }
                }
                result = null;
                break;
            }
            case UNARY_PLUS: {
                return JavaExpression.fromTree(provider, ((UnaryTree)tree).getExpression(), allowNonDeterministic);
            }
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: {
                JavaExpression operand = JavaExpression.fromTree(provider, ((UnaryTree)tree).getExpression(), allowNonDeterministic);
                return new UnaryOperation(TreeUtils.typeOf((Tree)tree), tree.getKind(), operand);
            }
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                BinaryTree binaryTree = (BinaryTree)tree;
                JavaExpression left = JavaExpression.fromTree(provider, binaryTree.getLeftOperand(), allowNonDeterministic);
                JavaExpression right = JavaExpression.fromTree(provider, binaryTree.getRightOperand(), allowNonDeterministic);
                return new BinaryOperation(TreeUtils.typeOf((Tree)tree), tree.getKind(), left, right);
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            result = new Unknown(TreeUtils.typeOf((Tree)tree));
        }
        return result;
    }

    private static JavaExpression fromMemberSelect(AnnotationProvider provider, MemberSelectTree memberSelectTree) {
        TypeMirror expressionType = TreeUtils.typeOf((Tree)memberSelectTree.getExpression());
        if (TreeUtils.isClassLiteral((Tree)memberSelectTree)) {
            return new ClassName(expressionType);
        }
        assert (TreeUtils.isUseOfElement((ExpressionTree)memberSelectTree)) : "@AssumeAssertion(nullness): tree kind";
        Element ele = TreeUtils.elementFromUse((ExpressionTree)memberSelectTree);
        if (ElementUtils.isTypeElement((Element)ele)) {
            TypeMirror selectType = TreeUtils.typeOf((Tree)memberSelectTree);
            return new ClassName(selectType);
        }
        switch (ele.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return JavaExpression.fromTree(provider, memberSelectTree.getExpression());
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror fieldType = TreeUtils.typeOf((Tree)memberSelectTree);
                JavaExpression je = JavaExpression.fromTree(provider, memberSelectTree.getExpression());
                return new FieldAccess(je, fieldType, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected element kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    public static @Nullable List<JavaExpression> getParametersOfEnclosingMethod(AnnotationProvider annotationProvider, TreePath path) {
        MethodTree methodTree = TreePathUtil.enclosingMethod((TreePath)path);
        if (methodTree == null) {
            return null;
        }
        ArrayList<JavaExpression> internalArguments = new ArrayList<JavaExpression>();
        for (VariableTree variableTree : methodTree.getParameters()) {
            internalArguments.add(JavaExpression.fromNode(annotationProvider, new LocalVariableNode(variableTree)));
        }
        return internalArguments;
    }

    public static JavaExpression getReceiver(ExpressionTree accessTree, AnnotationProvider provider) {
        assert (accessTree instanceof MethodInvocationTree || accessTree instanceof NewClassTree);
        ExpressionTree receiverTree = TreeUtils.getReceiverTree((ExpressionTree)accessTree);
        if (receiverTree != null) {
            return JavaExpression.fromTree(provider, receiverTree);
        }
        Element ele = TreeUtils.elementFromUse((ExpressionTree)accessTree);
        if (ele == null) {
            throw new BugInCF("TreeUtils.elementFromUse(" + accessTree + ") => null");
        }
        return JavaExpression.getImplicitReceiver(ele);
    }

    public static JavaExpression getImplicitReceiver(Element ele) {
        TypeElement enclosingClass = ElementUtils.enclosingTypeElement((Element)ele);
        if (enclosingClass == null) {
            throw new BugInCF("getImplicitReceiver's arg has no enclosing class: " + ele);
        }
        TypeMirror enclosingType = enclosingClass.asType();
        if (ElementUtils.isStatic((Element)ele)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public static JavaExpression getPseudoReceiver(TreePath path, TypeMirror enclosingType) {
        if (TreePathUtil.isTreeInStaticScope((TreePath)path)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }
}

