/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.Element;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.javacutil.TreeUtils;

public class PackageNameNode
extends Node {
    protected final Tree tree;
    protected final Element element;
    protected final @Nullable PackageNameNode parent;

    public PackageNameNode(IdentifierTree tree) {
        super(TreeUtils.typeOf((Tree)tree));
        this.tree = tree;
        assert (TreeUtils.isUseOfElement((ExpressionTree)tree)) : "@AssumeAssertion(nullness): tree kind";
        this.element = TreeUtils.elementFromUse((ExpressionTree)tree);
        this.parent = null;
    }

    public PackageNameNode(MemberSelectTree tree, PackageNameNode parent) {
        super(TreeUtils.typeOf((Tree)tree));
        this.tree = tree;
        assert (TreeUtils.isUseOfElement((ExpressionTree)tree)) : "@AssumeAssertion(nullness): tree kind";
        this.element = TreeUtils.elementFromUse((ExpressionTree)tree);
        this.parent = parent;
    }

    public Element getElement() {
        return this.element;
    }

    public @Nullable PackageNameNode getParent() {
        return this.parent;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitPackageName(this, p);
    }

    public String toString() {
        return this.getElement().getSimpleName().toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof PackageNameNode)) {
            return false;
        }
        PackageNameNode other = (PackageNameNode)obj;
        return Objects.equals(this.getParent(), other.getParent()) && this.getElement().equals(other.getElement());
    }

    public int hashCode() {
        return Objects.hash(this.getElement(), this.getParent());
    }

    @Override
    public Collection<Node> getOperands() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.parent);
    }
}

