/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.interning.qual.EqualsMethod;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.ClassNameNode;
import org.checkerframework.dataflow.cfg.node.ExplicitThisNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.NarrowingConversionNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.StringConversionNode;
import org.checkerframework.dataflow.cfg.node.SuperNode;
import org.checkerframework.dataflow.cfg.node.ThisNode;
import org.checkerframework.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.dataflow.cfg.node.ValueLiteralNode;
import org.checkerframework.dataflow.cfg.node.WideningConversionNode;
import org.checkerframework.dataflow.expression.ArrayAccess;
import org.checkerframework.dataflow.expression.ArrayCreation;
import org.checkerframework.dataflow.expression.BinaryOperation;
import org.checkerframework.dataflow.expression.ClassName;
import org.checkerframework.dataflow.expression.FieldAccess;
import org.checkerframework.dataflow.expression.FormalParameter;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.dataflow.expression.LocalVariable;
import org.checkerframework.dataflow.expression.MethodCall;
import org.checkerframework.dataflow.expression.ThisReference;
import org.checkerframework.dataflow.expression.UnaryOperation;
import org.checkerframework.dataflow.expression.Unknown;
import org.checkerframework.dataflow.expression.ValueLiteral;
import org.checkerframework.dataflow.expression.ViewpointAdaptJavaExpression;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreePathUtil;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;
import org.plumelib.util.CollectionsPlume;

public abstract class JavaExpression {
    protected final TypeMirror type;

    protected JavaExpression(TypeMirror type) {
        assert (type != null);
        this.type = type;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public abstract boolean containsOfClass(Class<? extends JavaExpression> var1);

    public boolean containsUnknown() {
        return this.containsOfClass(Unknown.class);
    }

    public abstract boolean isDeterministic(AnnotationProvider var1);

    public static boolean listIsDeterministic(List<? extends @Nullable JavaExpression> list, AnnotationProvider provider) {
        return list.stream().allMatch(je -> je == null || je.isDeterministic(provider));
    }

    public abstract boolean isUnassignableByOtherCode();

    public abstract boolean isUnmodifiableByOtherCode();

    @EqualsMethod
    public abstract boolean syntacticEquals(JavaExpression var1);

    static boolean syntacticEqualsList(List<? extends @Nullable JavaExpression> lst1, List<? extends @Nullable JavaExpression> lst2) {
        if (lst1.size() != lst2.size()) {
            return false;
        }
        for (int i = 0; i < lst1.size(); ++i) {
            JavaExpression dim1 = lst1.get(i);
            JavaExpression dim2 = lst2.get(i);
            if (dim1 == null && dim2 == null) continue;
            if (dim1 == null || dim2 == null) {
                return false;
            }
            if (dim1.syntacticEquals(dim2)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean containsSyntacticEqualJavaExpression(JavaExpression var1);

    public static boolean listContainsSyntacticEqualJavaExpression(List<? extends @Nullable JavaExpression> list, JavaExpression other) {
        return list.stream().anyMatch(je -> je != null && je.containsSyntacticEqualJavaExpression(other));
    }

    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return this.equals(other) || store.canAlias(this, other);
    }

    public String toStringDebug() {
        return String.format("%s(%s): %s", this.getClass().getSimpleName(), this.type, this.toString());
    }

    public static JavaExpression fromNodeFieldAccess(FieldAccessNode node) {
        Node receiverNode = node.getReceiver();
        String fieldName = node.getFieldName();
        if (fieldName.equals("this")) {
            return new ThisReference(receiverNode.getType());
        }
        if (fieldName.equals("class")) {
            return new ClassName(receiverNode.getType());
        }
        JavaExpression receiver = node.isStatic() ? new ClassName(receiverNode.getType()) : JavaExpression.fromNode(receiverNode);
        return new FieldAccess(receiver, node);
    }

    public static ArrayAccess fromArrayAccess(ArrayAccessNode node) {
        JavaExpression array = JavaExpression.fromNode(node.getArray());
        JavaExpression index = JavaExpression.fromNode(node.getIndex());
        return new ArrayAccess(node.getType(), array, index);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static JavaExpression fromNode(Node receiverNode) {
        JavaExpression result = null;
        if (receiverNode instanceof FieldAccessNode) {
            result = JavaExpression.fromNodeFieldAccess((FieldAccessNode)receiverNode);
        } else if (receiverNode instanceof ExplicitThisNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof ThisNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof SuperNode) {
            result = new ThisReference(receiverNode.getType());
        } else if (receiverNode instanceof LocalVariableNode) {
            LocalVariableNode lv = (LocalVariableNode)receiverNode;
            result = new LocalVariable(lv);
        } else if (receiverNode instanceof ArrayAccessNode) {
            ArrayAccessNode a = (ArrayAccessNode)receiverNode;
            result = JavaExpression.fromArrayAccess(a);
        } else {
            if (receiverNode instanceof StringConversionNode) {
                return JavaExpression.fromNode(((StringConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof WideningConversionNode) {
                return JavaExpression.fromNode(((WideningConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof NarrowingConversionNode) {
                return JavaExpression.fromNode(((NarrowingConversionNode)receiverNode).getOperand());
            }
            if (receiverNode instanceof UnaryOperationNode) {
                UnaryOperationNode uopn = (UnaryOperationNode)receiverNode;
                return new UnaryOperation(uopn, JavaExpression.fromNode(uopn.getOperand()));
            }
            if (receiverNode instanceof BinaryOperationNode) {
                BinaryOperationNode bopn = (BinaryOperationNode)receiverNode;
                return new BinaryOperation(bopn, JavaExpression.fromNode(bopn.getLeftOperand()), JavaExpression.fromNode(bopn.getRightOperand()));
            }
            if (receiverNode instanceof ClassNameNode) {
                ClassNameNode cn = (ClassNameNode)receiverNode;
                result = new ClassName(cn.getType());
            } else if (receiverNode instanceof ValueLiteralNode) {
                ValueLiteralNode vn = (ValueLiteralNode)receiverNode;
                result = new ValueLiteral(vn.getType(), vn);
            } else if (receiverNode instanceof ArrayCreationNode) {
                ArrayCreationNode an = (ArrayCreationNode)receiverNode;
                @Nullable List dimensions = CollectionsPlume.mapList(JavaExpression::fromNode, an.getDimensions());
                List initializers = CollectionsPlume.mapList(JavaExpression::fromNode, an.getInitializers());
                result = new ArrayCreation(an.getType(), dimensions, initializers);
            } else if (receiverNode instanceof MethodInvocationNode) {
                MethodInvocationNode mn = (MethodInvocationNode)receiverNode;
                MethodInvocationTree t = mn.getTree();
                if (t == null) {
                    throw new BugInCF("Unexpected null tree for node: " + mn);
                }
                assert (TreeUtils.isUseOfElement((ExpressionTree)t)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement invokedMethod = TreeUtils.elementFromUse((MethodInvocationTree)t);
                List parameters = CollectionsPlume.mapList(JavaExpression::fromNode, mn.getArguments());
                JavaExpression methodReceiver = ElementUtils.isStatic((Element)invokedMethod) ? new ClassName(mn.getTarget().getReceiver().getType()) : JavaExpression.fromNode(mn.getTarget().getReceiver());
                result = new MethodCall(mn.getType(), invokedMethod, methodReceiver, parameters);
            }
        }
        if (result == null) {
            result = new Unknown(receiverNode);
        }
        return result;
    }

    public static JavaExpression fromTree(ExpressionTree tree) {
        JavaExpression result;
        switch (tree.getKind()) {
            case ARRAY_ACCESS: {
                ArrayAccessTree a = (ArrayAccessTree)tree;
                JavaExpression arrayAccessExpression = JavaExpression.fromTree(a.getExpression());
                JavaExpression index = JavaExpression.fromTree(a.getIndex());
                result = new ArrayAccess(TreeUtils.typeOf((Tree)a), arrayAccessExpression, index);
                break;
            }
            case BOOLEAN_LITERAL: 
            case CHAR_LITERAL: 
            case DOUBLE_LITERAL: 
            case FLOAT_LITERAL: 
            case INT_LITERAL: 
            case LONG_LITERAL: 
            case NULL_LITERAL: 
            case STRING_LITERAL: {
                LiteralTree vn = (LiteralTree)tree;
                result = new ValueLiteral(TreeUtils.typeOf((Tree)tree), vn.getValue());
                break;
            }
            case NEW_ARRAY: {
                List<JavaExpression> initializers;
                List<JavaExpression> dimensions;
                NewArrayTree newArrayTree = (NewArrayTree)tree;
                if (newArrayTree.getDimensions() == null) {
                    dimensions = Collections.emptyList();
                } else {
                    dimensions = new ArrayList(newArrayTree.getDimensions().size());
                    for (ExpressionTree expressionTree : newArrayTree.getDimensions()) {
                        dimensions.add(JavaExpression.fromTree(expressionTree));
                    }
                }
                if (newArrayTree.getInitializers() == null) {
                    initializers = Collections.emptyList();
                } else {
                    initializers = new ArrayList(newArrayTree.getInitializers().size());
                    for (ExpressionTree expressionTree : newArrayTree.getInitializers()) {
                        initializers.add(JavaExpression.fromTree(expressionTree));
                    }
                }
                result = new ArrayCreation(TreeUtils.typeOf((Tree)tree), dimensions, initializers);
                break;
            }
            case METHOD_INVOCATION: {
                JavaExpression methodReceiver;
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
                assert (TreeUtils.isUseOfElement((ExpressionTree)methodInvocationTree)) : "@AssumeAssertion(nullness): tree kind";
                ExecutableElement executableElement = TreeUtils.elementFromUse((MethodInvocationTree)methodInvocationTree);
                List parameters = CollectionsPlume.mapList(JavaExpression::fromTree, methodInvocationTree.getArguments());
                if (ElementUtils.isStatic((Element)executableElement)) {
                    @NonNull TypeElement methodType = ElementUtils.enclosingTypeElement((Element)executableElement);
                    methodReceiver = new ClassName(methodType.asType());
                } else {
                    methodReceiver = JavaExpression.getReceiver(methodInvocationTree);
                }
                TypeMirror resultType = TreeUtils.typeOf((Tree)methodInvocationTree);
                result = new MethodCall(resultType, executableElement, methodReceiver, parameters);
                break;
            }
            case MEMBER_SELECT: {
                result = JavaExpression.fromMemberSelect((MemberSelectTree)tree);
                break;
            }
            case IDENTIFIER: {
                IdentifierTree identifierTree = (IdentifierTree)tree;
                TypeMirror typeOfId = TreeUtils.typeOf((Tree)identifierTree);
                Name identifierName = identifierTree.getName();
                if (identifierName.contentEquals("this") || identifierName.contentEquals("super")) {
                    result = new ThisReference(typeOfId);
                    break;
                }
                assert (TreeUtils.isUseOfElement((ExpressionTree)identifierTree)) : "@AssumeAssertion(nullness): tree kind";
                Element ele = TreeUtils.elementFromUse((ExpressionTree)identifierTree);
                if (ElementUtils.isTypeElement((Element)ele)) {
                    result = new ClassName(ele.asType());
                    break;
                }
                result = JavaExpression.fromVariableElement(typeOfId, ele);
                break;
            }
            case UNARY_PLUS: {
                return JavaExpression.fromTree(((UnaryTree)tree).getExpression());
            }
            case BITWISE_COMPLEMENT: 
            case LOGICAL_COMPLEMENT: 
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: 
            case UNARY_MINUS: {
                JavaExpression operand = JavaExpression.fromTree(((UnaryTree)tree).getExpression());
                return new UnaryOperation(TreeUtils.typeOf((Tree)tree), tree.getKind(), operand);
            }
            case CONDITIONAL_AND: 
            case CONDITIONAL_OR: 
            case DIVIDE: 
            case EQUAL_TO: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LEFT_SHIFT: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case MINUS: 
            case MULTIPLY: 
            case NOT_EQUAL_TO: 
            case OR: 
            case PLUS: 
            case REMAINDER: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: 
            case XOR: {
                BinaryTree binaryTree = (BinaryTree)tree;
                JavaExpression left = JavaExpression.fromTree(binaryTree.getLeftOperand());
                JavaExpression right = JavaExpression.fromTree(binaryTree.getRightOperand());
                return new BinaryOperation(TreeUtils.typeOf((Tree)tree), tree.getKind(), left, right);
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            result = new Unknown(tree);
        }
        return result;
    }

    public static JavaExpression fromVariableTree(VariableTree tree) {
        return JavaExpression.fromVariableElement(TreeUtils.typeOf((Tree)tree), TreeUtils.elementFromDeclaration((VariableTree)tree));
    }

    private static JavaExpression fromVariableElement(TypeMirror typeOfEle, Element ele) {
        switch (ele.getKind()) {
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: 
            case EXCEPTION_PARAMETER: 
            case PARAMETER: {
                return new LocalVariable(ele);
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror enclosingTypeElement = ElementUtils.enclosingTypeElement((Element)ele).asType();
                JavaExpression fieldAccessExpression = ElementUtils.isStatic((Element)ele) ? new ClassName(enclosingTypeElement) : new ThisReference(enclosingTypeElement);
                return new FieldAccess(fieldAccessExpression, typeOfEle, (VariableElement)ele);
            }
        }
        if (ElementUtils.isBindingVariable((Element)ele)) {
            return new LocalVariable(ele);
        }
        throw new BugInCF("Unexpected kind of VariableTree: kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    private static JavaExpression fromMemberSelect(MemberSelectTree memberSelectTree) {
        TypeMirror expressionType = TreeUtils.typeOf((Tree)memberSelectTree.getExpression());
        if (TreeUtils.isClassLiteral((Tree)memberSelectTree)) {
            return new ClassName(expressionType);
        }
        if (TreeUtils.isExplicitThisDereference((ExpressionTree)memberSelectTree)) {
            return new ThisReference(expressionType);
        }
        assert (TreeUtils.isUseOfElement((ExpressionTree)memberSelectTree)) : "@AssumeAssertion(nullness): tree kind";
        Element ele = TreeUtils.elementFromUse((ExpressionTree)memberSelectTree);
        if (ElementUtils.isTypeElement((Element)ele)) {
            TypeMirror selectType = TreeUtils.typeOf((Tree)memberSelectTree);
            return new ClassName(selectType);
        }
        switch (ele.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return JavaExpression.fromTree(memberSelectTree.getExpression());
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                TypeMirror fieldType = TreeUtils.typeOf((Tree)memberSelectTree);
                JavaExpression je = JavaExpression.fromTree(memberSelectTree.getExpression());
                return new FieldAccess(je, fieldType, (VariableElement)ele);
            }
        }
        throw new BugInCF("Unexpected element kind: %s element: %s", new Object[]{ele.getKind(), ele});
    }

    public static List<JavaExpression> getParametersAsLocalVariables(ExecutableElement methodEle) {
        return CollectionsPlume.mapList(LocalVariable::new, methodEle.getParameters());
    }

    public static List<FormalParameter> getFormalParameters(ExecutableElement methodEle) {
        ArrayList<FormalParameter> parameters = new ArrayList<FormalParameter>(methodEle.getParameters().size());
        int oneBasedIndex = 1;
        for (VariableElement variableElement : methodEle.getParameters()) {
            parameters.add(new FormalParameter(oneBasedIndex, variableElement));
            ++oneBasedIndex;
        }
        return parameters;
    }

    public static JavaExpression getReceiver(ExpressionTree accessTree) {
        assert (accessTree instanceof MethodInvocationTree || accessTree instanceof NewClassTree);
        ExpressionTree receiverTree = TreeUtils.getReceiverTree((ExpressionTree)accessTree);
        if (receiverTree != null) {
            return JavaExpression.fromTree(receiverTree);
        }
        Element ele = TreeUtils.elementFromUse((ExpressionTree)accessTree);
        if (ele == null) {
            throw new BugInCF("TreeUtils.elementFromUse(" + accessTree + ") => null");
        }
        return JavaExpression.getImplicitReceiver(ele);
    }

    public static JavaExpression getImplicitReceiver(Element ele) {
        TypeElement enclosingTypeElement = ElementUtils.enclosingTypeElement((Element)ele);
        if (enclosingTypeElement == null) {
            throw new BugInCF("getImplicitReceiver's arg has no enclosing type: " + ele);
        }
        TypeMirror enclosingType = enclosingTypeElement.asType();
        if (ElementUtils.isStatic((Element)ele)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public static JavaExpression getPseudoReceiver(TreePath path, TypeMirror enclosingType) {
        if (TreePathUtil.isTreeInStaticScope((TreePath)path)) {
            return new ClassName(enclosingType);
        }
        return new ThisReference(enclosingType);
    }

    public abstract <R, P> R accept(JavaExpressionVisitor<R, P> var1, P var2);

    public JavaExpression atFieldAccess(JavaExpression receiver) {
        return ViewpointAdaptJavaExpression.viewpointAdapt(this, receiver);
    }

    public final JavaExpression atMethodBody(MethodTree methodTree) {
        List parametersJe = CollectionsPlume.mapList(param -> new LocalVariable(TreeUtils.elementFromDeclaration((VariableTree)param)), methodTree.getParameters());
        return ViewpointAdaptJavaExpression.viewpointAdapt(this, parametersJe);
    }

    public final JavaExpression atMethodInvocation(MethodInvocationTree methodInvocationTree) {
        JavaExpression receiverJe = JavaExpression.getReceiver(methodInvocationTree);
        List<JavaExpression> argumentsJe = JavaExpression.argumentTreesToJavaExpressions(TreeUtils.elementFromUse((MethodInvocationTree)methodInvocationTree), methodInvocationTree.getArguments());
        return ViewpointAdaptJavaExpression.viewpointAdapt(this, receiverJe, argumentsJe);
    }

    public final JavaExpression atMethodInvocation(MethodInvocationNode invocationNode) {
        JavaExpression receiverJe = JavaExpression.fromNode(invocationNode.getTarget().getReceiver());
        List argumentsJe = CollectionsPlume.mapList(JavaExpression::fromNode, invocationNode.getArguments());
        return ViewpointAdaptJavaExpression.viewpointAdapt(this, receiverJe, argumentsJe);
    }

    public JavaExpression atConstructorInvocation(NewClassTree newClassTree) {
        JavaExpression receiverJe = JavaExpression.getReceiver(newClassTree);
        List<JavaExpression> argumentsJe = JavaExpression.argumentTreesToJavaExpressions(TreeUtils.elementFromUse((NewClassTree)newClassTree), newClassTree.getArguments());
        return ViewpointAdaptJavaExpression.viewpointAdapt(this, receiverJe, argumentsJe);
    }

    private static List<JavaExpression> argumentTreesToJavaExpressions(ExecutableElement method, List<? extends ExpressionTree> argTrees) {
        if (JavaExpression.isVarArgsInvocation(method, argTrees)) {
            ArrayList<JavaExpression> result = new ArrayList<JavaExpression>(method.getParameters().size());
            for (int i = 0; i < method.getParameters().size() - 1; ++i) {
                result.add(JavaExpression.fromTree(argTrees.get(i)));
            }
            ArrayList<JavaExpression> varargArgs = new ArrayList<JavaExpression>(argTrees.size() - method.getParameters().size() + 1);
            for (int i = method.getParameters().size() - 1; i < argTrees.size(); ++i) {
                varargArgs.add(JavaExpression.fromTree(argTrees.get(i)));
            }
            Element varargsElement = method.getParameters().get(method.getParameters().size() - 1);
            TypeMirror tm = ElementUtils.getType((Element)varargsElement);
            result.add(new ArrayCreation(tm, Collections.emptyList(), varargArgs));
            return result;
        }
        return CollectionsPlume.mapList(JavaExpression::fromTree, argTrees);
    }

    private static boolean isVarArgsInvocation(ExecutableElement method, List<? extends ExpressionTree> args) {
        if (!method.isVarArgs()) {
            return false;
        }
        if (method.getParameters().size() != args.size()) {
            return true;
        }
        TypeMirror lastArgType = TreeUtils.typeOf((Tree)args.get(args.size() - 1));
        if (lastArgType.getKind() != TypeKind.ARRAY) {
            return true;
        }
        List<? extends VariableElement> paramElts = method.getParameters();
        VariableElement lastParamElt = paramElts.get(paramElts.size() - 1);
        return TypesUtils.getArrayDepth((TypeMirror)ElementUtils.getType((Element)lastParamElt)) != TypesUtils.getArrayDepth((TypeMirror)lastArgType);
    }
}

