/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TypesUtils;

public class LocalVariable
extends JavaExpression {
    protected final Element element;

    public LocalVariable(LocalVariableNode localVar) {
        super(localVar.getType());
        this.element = localVar.getElement();
    }

    public LocalVariable(Element element) {
        super(ElementUtils.getType((Element)element));
        this.element = element;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)obj;
        return LocalVariable.sameElement(this.element, other.element);
    }

    protected static boolean sameElement(Element element1, Element element2) {
        Symbol.VarSymbol vs1 = (Symbol.VarSymbol)element1;
        Symbol.VarSymbol vs2 = (Symbol.VarSymbol)element2;
        return vs1.pos == vs2.pos && vs1.name == vs2.name && vs1.owner.equals(vs2.owner);
    }

    public Element getElement() {
        return this.element;
    }

    public int hashCode() {
        Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
        return Objects.hash(vs.pos, vs.name, vs.owner);
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public String toStringDebug() {
        return super.toStringDebug() + " [owner=" + ((Symbol.VarSymbol)this.element).owner + "]";
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        return this.getClass() == clazz;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return true;
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)je;
        return this.equals(other);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return true;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return TypesUtils.isImmutableTypeInJdk((TypeMirror)((Symbol.VarSymbol)this.element).type);
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitLocalVariable(this, p);
    }
}

