/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.builder;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.BlockImpl;
import org.checkerframework.dataflow.cfg.block.ConditionalBlockImpl;
import org.checkerframework.dataflow.cfg.block.ExceptionBlockImpl;
import org.checkerframework.dataflow.cfg.block.RegularBlockImpl;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.javacutil.BugInCF;

public class CFGTranslationPhaseThree {
    public static ControlFlowGraph process(ControlFlowGraph cfg) {
        RegularBlockImpl b;
        Set<Block> worklist = cfg.getAllBlocks();
        HashSet<BlockImpl> dontVisit = new HashSet<BlockImpl>();
        for (Block c : worklist) {
            BlockImpl cur = (BlockImpl)c;
            for (Block pred : new HashSet<Block>(cur.getPredecessors())) {
                if (worklist.contains(pred)) continue;
                cur.removePredecessor((BlockImpl)pred);
            }
        }
        for (Block cur : worklist) {
            if (dontVisit.contains(cur) || cur.getType() != Block.BlockType.REGULAR_BLOCK || !(b = (RegularBlockImpl)cur).isEmpty()) continue;
            HashSet<RegularBlockImpl> emptyBlocks = new HashSet<RegularBlockImpl>();
            LinkedHashSet<PredecessorHolder> predecessors = new LinkedHashSet<PredecessorHolder>();
            BlockImpl succ = CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlock(b, emptyBlocks, predecessors);
            for (RegularBlockImpl e : emptyBlocks) {
                succ.removePredecessor(e);
                dontVisit.add(e);
            }
            for (PredecessorHolder p : predecessors) {
                BlockImpl block = p.getBlock();
                dontVisit.add(block);
                succ.removePredecessor(block);
                p.setSuccessor(succ);
            }
        }
        worklist = cfg.getAllBlocks();
        for (Block cur : worklist) {
            RegularBlockImpl rs;
            BlockImpl succ;
            if (cur.getType() != Block.BlockType.REGULAR_BLOCK || (succ = (b = (RegularBlockImpl)cur).getRegularSuccessor()).getType() != Block.BlockType.REGULAR_BLOCK || (rs = (RegularBlockImpl)succ).getPredecessors().size() != 1) continue;
            b.setSuccessor(rs.getRegularSuccessor());
            b.addNodes(rs.getNodes());
            rs.getRegularSuccessor().removePredecessor(rs);
        }
        return cfg;
    }

    protected static BlockImpl computeNeighborhoodOfEmptyBlock(RegularBlockImpl start, Set<RegularBlockImpl> emptyBlocks, Set<PredecessorHolder> predecessors) {
        RegularBlockImpl cur;
        CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlockBackwards(start, emptyBlocks, predecessors);
        BlockImpl succ = (BlockImpl)start.getSuccessor();
        while (succ.getType() == Block.BlockType.REGULAR_BLOCK && (cur = (RegularBlockImpl)succ).isEmpty()) {
            CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlockBackwards(cur, emptyBlocks, predecessors);
            assert (emptyBlocks.contains(cur)) : "cur ought to be in emptyBlocks";
            succ = (BlockImpl)cur.getSuccessor();
            if (succ != cur) continue;
            break;
        }
        return succ;
    }

    protected static void computeNeighborhoodOfEmptyBlockBackwards(RegularBlockImpl start, Set<RegularBlockImpl> emptyBlocks, Set<PredecessorHolder> predecessors) {
        RegularBlockImpl cur = start;
        emptyBlocks.add(cur);
        for (Block p : cur.getPredecessors()) {
            BlockImpl pred = (BlockImpl)p;
            switch (pred.getType()) {
                case SPECIAL_BLOCK: {
                    predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                    break;
                }
                case CONDITIONAL_BLOCK: {
                    predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                    break;
                }
                case EXCEPTION_BLOCK: {
                    predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                    break;
                }
                case REGULAR_BLOCK: {
                    RegularBlockImpl r = (RegularBlockImpl)pred;
                    if (r.isEmpty()) {
                        if (emptyBlocks.contains(r)) break;
                        CFGTranslationPhaseThree.computeNeighborhoodOfEmptyBlockBackwards(r, emptyBlocks, predecessors);
                        break;
                    }
                    predecessors.add(CFGTranslationPhaseThree.getPredecessorHolder(pred, cur));
                }
            }
        }
    }

    protected static PredecessorHolder getPredecessorHolder(final BlockImpl pred, final BlockImpl cur) {
        switch (pred.getType()) {
            case SPECIAL_BLOCK: {
                SingleSuccessorBlockImpl s = (SingleSuccessorBlockImpl)pred;
                return CFGTranslationPhaseThree.singleSuccessorHolder(s, cur);
            }
            case CONDITIONAL_BLOCK: {
                final ConditionalBlockImpl c = (ConditionalBlockImpl)pred;
                if (c.getThenSuccessor() == cur) {
                    return new PredecessorHolder(){

                        @Override
                        public void setSuccessor(BlockImpl b) {
                            c.setThenSuccessor(b);
                            cur.removePredecessor(pred);
                        }

                        @Override
                        public BlockImpl getBlock() {
                            return c;
                        }
                    };
                }
                assert (c.getElseSuccessor() == cur);
                return new PredecessorHolder(){

                    @Override
                    public void setSuccessor(BlockImpl b) {
                        c.setElseSuccessor(b);
                        cur.removePredecessor(pred);
                    }

                    @Override
                    public BlockImpl getBlock() {
                        return c;
                    }
                };
            }
            case EXCEPTION_BLOCK: {
                final ExceptionBlockImpl e = (ExceptionBlockImpl)pred;
                if (e.getSuccessor() == cur) {
                    return CFGTranslationPhaseThree.singleSuccessorHolder(e, cur);
                }
                Set<Map.Entry<TypeMirror, Set<Block>>> entrySet = e.getExceptionalSuccessors().entrySet();
                for (final Map.Entry<TypeMirror, Set<Block>> entry : entrySet) {
                    if (!entry.getValue().contains(cur)) continue;
                    return new PredecessorHolder(){

                        @Override
                        public void setSuccessor(BlockImpl b) {
                            e.addExceptionalSuccessor(b, (TypeMirror)entry.getKey());
                            cur.removePredecessor(pred);
                        }

                        @Override
                        public BlockImpl getBlock() {
                            return e;
                        }
                    };
                }
                throw new BugInCF("Unreachable");
            }
            case REGULAR_BLOCK: {
                RegularBlockImpl r = (RegularBlockImpl)pred;
                return CFGTranslationPhaseThree.singleSuccessorHolder(r, cur);
            }
        }
        throw new BugInCF("Unexpected block type " + (Object)((Object)pred.getType()));
    }

    protected static PredecessorHolder singleSuccessorHolder(final SingleSuccessorBlockImpl s, final BlockImpl old) {
        return new PredecessorHolder(){

            @Override
            public void setSuccessor(BlockImpl b) {
                s.setSuccessor(b);
                old.removePredecessor(s);
            }

            @Override
            public BlockImpl getBlock() {
                return s;
            }
        };
    }

    protected static interface PredecessorHolder {
        public void setSuccessor(BlockImpl var1);

        public BlockImpl getBlock();
    }
}

