/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.livevariable;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.TernaryExpressionNode;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.dataflow.cfg.node.UnaryOperationNode;
import org.checkerframework.dataflow.cfg.visualize.CFGVisualizer;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.livevariable.LiveVarValue;
import org.checkerframework.javacutil.BugInCF;

public class LiveVarStore
implements Store<LiveVarStore> {
    private final Set<LiveVarValue> liveVarValueSet;

    public LiveVarStore() {
        this.liveVarValueSet = new LinkedHashSet<LiveVarValue>();
    }

    public LiveVarStore(Set<LiveVarValue> liveVarValueSet) {
        this.liveVarValueSet = liveVarValueSet;
    }

    public void putLiveVar(LiveVarValue variable) {
        this.liveVarValueSet.add(variable);
    }

    public void killLiveVar(LiveVarValue variable) {
        this.liveVarValueSet.remove(variable);
    }

    public void addUseInExpression(Node expression) {
        if (expression instanceof LocalVariableNode || expression instanceof FieldAccessNode) {
            LiveVarValue liveVarValue = new LiveVarValue(expression);
            this.putLiveVar(liveVarValue);
        } else if (expression instanceof UnaryOperationNode) {
            UnaryOperationNode unaryNode = (UnaryOperationNode)expression;
            this.addUseInExpression(unaryNode.getOperand());
        } else if (expression instanceof TernaryExpressionNode) {
            TernaryExpressionNode ternaryNode = (TernaryExpressionNode)expression;
            this.addUseInExpression(ternaryNode.getConditionOperand());
            this.addUseInExpression(ternaryNode.getThenOperand());
            this.addUseInExpression(ternaryNode.getElseOperand());
        } else if (expression instanceof TypeCastNode) {
            TypeCastNode typeCastNode = (TypeCastNode)expression;
            this.addUseInExpression(typeCastNode.getOperand());
        } else if (expression instanceof InstanceOfNode) {
            InstanceOfNode instanceOfNode = (InstanceOfNode)expression;
            this.addUseInExpression(instanceOfNode.getOperand());
        } else if (expression instanceof BinaryOperationNode) {
            BinaryOperationNode binaryNode = (BinaryOperationNode)expression;
            this.addUseInExpression(binaryNode.getLeftOperand());
            this.addUseInExpression(binaryNode.getRightOperand());
        }
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LiveVarStore)) {
            return false;
        }
        LiveVarStore other = (LiveVarStore)obj;
        return other.liveVarValueSet.equals(this.liveVarValueSet);
    }

    public int hashCode() {
        return this.liveVarValueSet.hashCode();
    }

    @Override
    public LiveVarStore copy() {
        return new LiveVarStore(new HashSet<LiveVarValue>(this.liveVarValueSet));
    }

    @Override
    public LiveVarStore leastUpperBound(LiveVarStore other) {
        HashSet<LiveVarValue> liveVarValueSetLub = new HashSet<LiveVarValue>(this.liveVarValueSet.size() + other.liveVarValueSet.size());
        liveVarValueSetLub.addAll(this.liveVarValueSet);
        liveVarValueSetLub.addAll(other.liveVarValueSet);
        return new LiveVarStore(liveVarValueSetLub);
    }

    @Override
    public LiveVarStore widenedUpperBound(LiveVarStore previous) {
        throw new BugInCF("wub of LiveVarStore get called!");
    }

    @Override
    public boolean canAlias(JavaExpression a, JavaExpression b) {
        return true;
    }

    @Override
    public String visualize(CFGVisualizer<?, LiveVarStore, ?> viz) {
        String key = "live variables";
        if (this.liveVarValueSet.isEmpty()) {
            return viz.visualizeStoreKeyVal(key, "none");
        }
        StringJoiner sjStoreVal = new StringJoiner(", ");
        for (LiveVarValue liveVarValue : this.liveVarValueSet) {
            sjStoreVal.add(liveVarValue.toString());
        }
        return viz.visualizeStoreKeyVal(key, sjStoreVal.toString());
    }

    public String toString() {
        return this.liveVarValueSet.toString();
    }
}

