/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.livevariable;

import java.util.List;
import org.checkerframework.dataflow.analysis.BackwardTransferFunction;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.StringConcatenateAssignmentNode;
import org.checkerframework.dataflow.livevariable.LiveVarStore;
import org.checkerframework.dataflow.livevariable.LiveVarValue;

public class LiveVarTransfer
extends AbstractNodeVisitor<TransferResult<LiveVarValue, LiveVarStore>, TransferInput<LiveVarValue, LiveVarStore>>
implements BackwardTransferFunction<LiveVarValue, LiveVarStore> {
    @Override
    public LiveVarStore initialNormalExitStore(UnderlyingAST underlyingAST, List<ReturnNode> returnNodes) {
        return new LiveVarStore();
    }

    @Override
    public LiveVarStore initialExceptionalExitStore(UnderlyingAST underlyingAST) {
        return new LiveVarStore();
    }

    @Override
    public RegularTransferResult<LiveVarValue, LiveVarStore> visitNode(Node n, TransferInput<LiveVarValue, LiveVarStore> p) {
        return new RegularTransferResult<Object, LiveVarStore>(null, p.getRegularStore());
    }

    @Override
    public RegularTransferResult<LiveVarValue, LiveVarStore> visitAssignment(AssignmentNode n, TransferInput<LiveVarValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitAssignment(n, p);
        this.processLiveVarInAssignment(n.getTarget(), n.getExpression(), (LiveVarStore)transferResult.getRegularStore());
        return transferResult;
    }

    @Override
    public RegularTransferResult<LiveVarValue, LiveVarStore> visitStringConcatenateAssignment(StringConcatenateAssignmentNode n, TransferInput<LiveVarValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitStringConcatenateAssignment(n, p);
        this.processLiveVarInAssignment(n.getLeftOperand(), n.getRightOperand(), (LiveVarStore)transferResult.getRegularStore());
        return transferResult;
    }

    @Override
    public RegularTransferResult<LiveVarValue, LiveVarStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<LiveVarValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitMethodInvocation(n, p);
        LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<LiveVarValue, LiveVarStore> visitObjectCreation(ObjectCreationNode n, TransferInput<LiveVarValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitObjectCreation(n, p);
        LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<LiveVarValue, LiveVarStore> visitReturn(ReturnNode n, TransferInput<LiveVarValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitReturn(n, p);
        Node result = n.getResult();
        if (result != null) {
            LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
            store.addUseInExpression(result);
        }
        return transferResult;
    }

    private void processLiveVarInAssignment(Node variable, Node expression, LiveVarStore store) {
        store.killLiveVar(new LiveVarValue(variable));
        store.addUseInExpression(expression);
    }
}

