/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.BlockImpl;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.BugInCF;

public class ExceptionBlockImpl
extends SingleSuccessorBlockImpl
implements ExceptionBlock {
    protected @Nullable Node node;
    protected final Map<TypeMirror, Set<Block>> exceptionalSuccessors = new HashMap<TypeMirror, Set<Block>>();

    public ExceptionBlockImpl() {
        super(Block.BlockType.EXCEPTION_BLOCK);
    }

    public void setNode(Node c) {
        this.node = c;
        c.setBlock(this);
    }

    @Override
    public Node getNode() {
        if (this.node == null) {
            throw new BugInCF("Requested node for exception block before initialization");
        }
        return this.node;
    }

    public void addExceptionalSuccessor(BlockImpl b, TypeMirror cause) {
        Set<Block> blocks = this.exceptionalSuccessors.get(cause);
        if (blocks == null) {
            blocks = new HashSet<Block>();
            this.exceptionalSuccessors.put(cause, blocks);
        }
        blocks.add(b);
        b.addPredecessor(this);
    }

    @Override
    public Map<TypeMirror, Set<Block>> getExceptionalSuccessors() {
        if (this.exceptionalSuccessors == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.exceptionalSuccessors);
    }

    public String toString() {
        return "ExceptionBlock(" + this.node + ")";
    }
}

