/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.TreeUtils;

public class StringConcatenateAssignmentNode
extends Node {
    protected final Tree tree;
    protected final Node left;
    protected final Node right;

    public StringConcatenateAssignmentNode(Tree tree, Node left, Node right) {
        super(TreeUtils.typeOf((Tree)tree));
        assert (tree.getKind() == Tree.Kind.PLUS_ASSIGNMENT);
        this.tree = tree;
        this.left = left;
        this.right = right;
    }

    public Node getLeftOperand() {
        return this.left;
    }

    public Node getRightOperand() {
        return this.right;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitStringConcatenateAssignment(this, p);
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Arrays.asList(this.getLeftOperand(), this.getRightOperand());
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " += " + this.getRightOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof StringConcatenateAssignmentNode)) {
            return false;
        }
        StringConcatenateAssignmentNode other = (StringConcatenateAssignmentNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

