/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.TreeUtils;

public class TernaryExpressionNode
extends Node {
    protected final ConditionalExpressionTree tree;
    protected final Node condition;
    protected final Node thenOperand;
    protected final Node elseOperand;
    private final LocalVariableNode ternaryExpressionVar;

    public TernaryExpressionNode(ConditionalExpressionTree tree, Node condition, Node thenOperand, Node elseOperand, LocalVariableNode ternaryExpressionVar) {
        super(TreeUtils.typeOf((Tree)tree));
        assert (tree.getKind() == Tree.Kind.CONDITIONAL_EXPRESSION);
        this.tree = tree;
        this.condition = condition;
        this.thenOperand = thenOperand;
        this.elseOperand = elseOperand;
        this.ternaryExpressionVar = ternaryExpressionVar;
    }

    public Node getConditionOperand() {
        return this.condition;
    }

    public Node getThenOperand() {
        return this.thenOperand;
    }

    public Node getElseOperand() {
        return this.elseOperand;
    }

    public LocalVariableNode getTernaryExpressionVar() {
        return this.ternaryExpressionVar;
    }

    @Override
    public ConditionalExpressionTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitTernaryExpression(this, p);
    }

    public String toString() {
        return "(" + this.getConditionOperand() + " ? " + this.getThenOperand() + " : " + this.getElseOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TernaryExpressionNode)) {
            return false;
        }
        TernaryExpressionNode other = (TernaryExpressionNode)obj;
        return this.getConditionOperand().equals(other.getConditionOperand()) && this.getThenOperand().equals(other.getThenOperand()) && this.getElseOperand().equals(other.getElseOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getConditionOperand(), this.getThenOperand(), this.getElseOperand());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Arrays.asList(this.getConditionOperand(), this.getThenOperand(), this.getElseOperand());
    }
}

