/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.node.BooleanLiteralNode;
import org.checkerframework.dataflow.cfg.node.ConditionalNotNode;
import org.checkerframework.dataflow.cfg.node.ConditionalOrNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.TypeCastNode;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TypesUtils;

public class NodeUtils {
    public static boolean isBooleanTypeNode(Node node) {
        if (node instanceof ConditionalOrNode) {
            return true;
        }
        Tree tree = node.getTree();
        if (tree == null) {
            return false;
        }
        Type type = ((JCTree)tree).type;
        return TypesUtils.isBooleanType((TypeMirror)type);
    }

    public static boolean isArrayLengthFieldAccess(Node node) {
        if (!(node instanceof FieldAccessNode)) {
            return false;
        }
        FieldAccessNode fieldAccess = (FieldAccessNode)node;
        return fieldAccess.getFieldName().equals("length") && fieldAccess.getReceiver().getType().getKind() == TypeKind.ARRAY;
    }

    public static boolean isMethodInvocation(Node node, ExecutableElement method, ProcessingEnvironment env) {
        if (!(node instanceof MethodInvocationNode)) {
            return false;
        }
        ExecutableElement invoked = ((MethodInvocationNode)node).getTarget().getMethod();
        return ElementUtils.isMethod((ExecutableElement)invoked, (ExecutableElement)method, (ProcessingEnvironment)env);
    }

    public static boolean isConstantBoolean(Node n, boolean value) {
        if (n instanceof BooleanLiteralNode) {
            return ((BooleanLiteralNode)n).getValue() == value;
        }
        if (n instanceof ConditionalNotNode) {
            return NodeUtils.isConstantBoolean(((ConditionalNotNode)n).getOperand(), !value);
        }
        return false;
    }

    public static Node removeCasts(Node node) {
        while (node instanceof TypeCastNode) {
            node = ((TypeCastNode)node).getOperand();
        }
        return node;
    }
}

