/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.expression.ClassName;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TypesUtils;

public class FieldAccess
extends JavaExpression {
    protected final JavaExpression receiver;
    protected final VariableElement field;

    public JavaExpression getReceiver() {
        return this.receiver;
    }

    public VariableElement getField() {
        return this.field;
    }

    public FieldAccess(JavaExpression receiver, FieldAccessNode node) {
        this(receiver, node.getType(), node.getElement());
    }

    public FieldAccess(JavaExpression receiver, VariableElement fieldElement) {
        this(receiver, fieldElement.asType(), fieldElement);
    }

    public FieldAccess(JavaExpression receiver, TypeMirror type, VariableElement fieldElement) {
        super(type);
        this.receiver = receiver;
        this.field = fieldElement;
        String fieldName = fieldElement.toString();
        if (fieldName.equals("class") || fieldName.equals("this")) {
            BugInCF e = new BugInCF(String.format("bad field name \"%s\" in new FieldAccess(%s, %s, %s)%n", fieldName, receiver, type, fieldElement));
            e.printStackTrace(System.out);
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public boolean isFinal() {
        return ElementUtils.isFinal((Element)this.field);
    }

    public boolean isStatic() {
        return ElementUtils.isStatic((Element)this.field);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof FieldAccess)) {
            return false;
        }
        FieldAccess fa = (FieldAccess)obj;
        return fa.getField().equals(this.getField()) && fa.getReceiver().equals(this.getReceiver());
    }

    public int hashCode() {
        return Objects.hash(this.getField(), this.getReceiver());
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof FieldAccess)) {
            return false;
        }
        FieldAccess other = (FieldAccess)je;
        return this.receiver.syntacticEquals(other.receiver) && this.field.equals(other.field);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return super.containsModifiableAliasOf(store, other) || this.receiver.containsModifiableAliasOf(store, other);
    }

    public String toString() {
        if (this.receiver instanceof ClassName) {
            return this.receiver.getType() + "." + this.field;
        }
        return this.receiver + "." + this.field;
    }

    @Override
    public String toStringDebug() {
        return String.format("FieldAccess(type=%s, receiver=%s, field=%s [%s] [%s] owner=%s)", this.type, this.receiver.toStringDebug(), this.field, this.field.getClass().getSimpleName(), System.identityHashCode(this.field), ((Symbol)((Object)this.field)).owner);
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        return this.getClass() == clazz || this.receiver.containsOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.receiver.isDeterministic(provider);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return this.isFinal() && this.getReceiver().isUnassignableByOtherCode();
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return this.isUnassignableByOtherCode() && TypesUtils.isImmutableTypeInJdk((TypeMirror)this.getReceiver().type);
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitFieldAccess(this, p);
    }
}

