/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.InstanceOfTree;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.DeconstructorPatternNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.TypesUtils;

public class InstanceOfNode
extends Node {
    protected final Node operand;
    protected final TypeMirror refType;
    protected final InstanceOfTree tree;
    protected final @Nullable Node patternNode;
    protected final Types types;
    @MonotonicNonNull List<LocalVariableNode> bindingVariables = null;

    public InstanceOfNode(InstanceOfTree tree, Node operand, TypeMirror refType, Types types) {
        this(tree, operand, null, refType, types);
    }

    public InstanceOfNode(InstanceOfTree tree, Node operand, @Nullable Node patternNode, TypeMirror refType, Types types) {
        super(types.getPrimitiveType(TypeKind.BOOLEAN));
        this.tree = tree;
        this.operand = operand;
        this.refType = refType;
        this.types = types;
        this.patternNode = patternNode;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Deprecated
    public @Nullable LocalVariableNode getBindingVariable() {
        if (this.patternNode instanceof LocalVariableNode) {
            return (LocalVariableNode)this.patternNode;
        }
        return null;
    }

    public List<LocalVariableNode> getBindingVariables() {
        if (this.bindingVariables == null) {
            this.bindingVariables = this.patternNode instanceof DeconstructorPatternNode ? ((DeconstructorPatternNode)this.patternNode).getBindingVariables() : (this.patternNode instanceof LocalVariableNode ? Collections.singletonList((LocalVariableNode)this.patternNode) : Collections.emptyList());
        }
        return this.bindingVariables;
    }

    public @Nullable Node getPatternNode() {
        return this.patternNode;
    }

    public TypeMirror getRefType() {
        return this.refType;
    }

    @Override
    public InstanceOfTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitInstanceOf(this, p);
    }

    public String toString() {
        return "(" + this.getOperand() + " instanceof " + TypesUtils.simpleTypeName((TypeMirror)this.getRefType()) + (this.patternNode == null ? "" : " " + this.getPatternNode()) + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof InstanceOfNode)) {
            return false;
        }
        InstanceOfNode other = (InstanceOfNode)obj;
        return this.getOperand().equals(other.getOperand()) && this.types.isSameType(this.getRefType(), other.getRefType());
    }

    public int hashCode() {
        return Objects.hash(InstanceOfNode.class, this.getOperand());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

