/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.dataflow.cfg.block.RegularBlock;
import org.checkerframework.dataflow.cfg.block.SingleSuccessorBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.javacutil.BugInCF;

public abstract class AbstractCFGVisualizer<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
implements CFGVisualizer<V, S, T> {
    protected boolean verbose;
    protected final String lineSeparator = System.lineSeparator();
    protected final String storeEntryIndent = "  ";

    @Override
    public void init(Map<String, Object> args) {
        this.verbose = AbstractCFGVisualizer.toBoolean(args.get("verbose"));
    }

    private static boolean toBoolean(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        return (Boolean)o;
    }

    protected String visualizeGraph(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        return this.visualizeGraphHeader() + this.visualizeGraphWithoutHeaderAndFooter(cfg, entry, analysis) + this.visualizeGraphFooter();
    }

    protected String visualizeGraphWithoutHeaderAndFooter(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        LinkedHashSet<Block> visited = new LinkedHashSet<Block>();
        StringBuilder sbGraph = new StringBuilder();
        ArrayDeque<Block> workList = new ArrayDeque<Block>();
        Block cur = entry;
        visited.add(entry);
        while (cur != null) {
            this.handleSuccessorsHelper(cur, visited, workList, sbGraph);
            cur = (Block)workList.poll();
        }
        sbGraph.append(this.visualizeNodes(visited, cfg, analysis));
        return sbGraph.toString();
    }

    protected void handleSuccessorsHelper(Block cur, Set<Block> visited, Queue<Block> workList, StringBuilder sbGraph) {
        if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
            ConditionalBlock ccur = (ConditionalBlock)cur;
            Block thenSuccessor = ccur.getThenSuccessor();
            sbGraph.append(this.addEdge(ccur.getId(), thenSuccessor.getId(), ccur.getThenFlowRule().toString()));
            this.addBlock(thenSuccessor, visited, workList);
            Block elseSuccessor = ccur.getElseSuccessor();
            sbGraph.append(this.addEdge(ccur.getId(), elseSuccessor.getId(), ccur.getElseFlowRule().toString()));
            this.addBlock(elseSuccessor, visited, workList);
        } else {
            SingleSuccessorBlock sscur = (SingleSuccessorBlock)cur;
            Block succ = sscur.getSuccessor();
            if (succ != null) {
                sbGraph.append(this.addEdge(cur.getId(), succ.getId(), sscur.getFlowRule().name()));
                this.addBlock(succ, visited, workList);
            }
        }
        if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
            ExceptionBlock ecur = (ExceptionBlock)cur;
            for (Map.Entry<TypeMirror, Set<Block>> e : ecur.getExceptionalSuccessors().entrySet()) {
                TypeMirror cause = e.getKey();
                String exception = cause.toString();
                if (exception.startsWith("java.lang.")) {
                    exception = exception.replace("java.lang.", "");
                }
                for (Block b : e.getValue()) {
                    sbGraph.append(this.addEdge(cur.getId(), b.getId(), exception));
                    this.addBlock(b, visited, workList);
                }
            }
        }
    }

    protected void addBlock(Block b, Set<Block> visited, Queue<Block> workList) {
        if (!visited.contains(b)) {
            visited.add(b);
            workList.add(b);
        }
    }

    protected String visualizeBlockHelper(Block bb, @Nullable Analysis<V, S, T> analysis, String escapeString) {
        StringBuilder sbBlock = new StringBuilder();
        sbBlock.append(this.loopOverBlockContents(bb, analysis, escapeString));
        if (sbBlock.length() == 0) {
            if (bb.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sbBlock.append(this.visualizeSpecialBlock((SpecialBlock)bb));
            } else if (bb.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sbBlock.append(this.visualizeConditionalBlock((ConditionalBlock)bb));
            } else {
                sbBlock.append("<empty block>");
            }
        }
        if (analysis != null) {
            Node lastNode;
            sbBlock.insert(0, this.visualizeBlockTransferInputBefore(bb, analysis));
            if (this.verbose && (lastNode = this.getLastNode(bb)) != null) {
                sbBlock.append(this.visualizeBlockTransferInputAfter(bb, analysis));
            }
        }
        return sbBlock.toString();
    }

    protected String loopOverBlockContents(Block bb, @Nullable Analysis<V, S, T> analysis, String separator) {
        List<Node> contents = this.addBlockContent(bb);
        StringJoiner sjBlockContents = new StringJoiner(separator, "", separator);
        sjBlockContents.setEmptyValue("");
        for (Node t : contents) {
            sjBlockContents.add(this.visualizeBlockNode(t, analysis));
        }
        return sjBlockContents.toString();
    }

    protected List<Node> addBlockContent(Block bb) {
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                return ((RegularBlock)bb).getContents();
            }
            case EXCEPTION_BLOCK: {
                return Collections.singletonList(((ExceptionBlock)bb).getNode());
            }
            case CONDITIONAL_BLOCK: 
            case SPECIAL_BLOCK: {
                return Collections.emptyList();
            }
        }
        throw new BugInCF("Unrecognized basic block type: " + (Object)((Object)bb.getType()));
    }

    protected abstract String format(Object var1);

    @Override
    public String visualizeBlockNode(Node t, @Nullable Analysis<V, S, T> analysis) {
        V value;
        StringBuilder sbBlockNode = new StringBuilder();
        sbBlockNode.append(this.format(t)).append("   [ ").append(this.getNodeSimpleName(t)).append(" ]");
        if (analysis != null && (value = analysis.getValue(t)) != null) {
            sbBlockNode.append("    > ").append(this.format(value));
        }
        return sbBlockNode.toString();
    }

    protected String visualizeBlockTransferInputBeforeHelper(Block bb, Analysis<V, S, T> analysis, String escapeString) {
        S regularStore;
        if (analysis == null) {
            throw new BugInCF("analysis must be non-null when visualizing the transfer input of a block.");
        }
        S thenStore = null;
        S elseStore = null;
        boolean isTwoStores = false;
        StringBuilder sbStore = new StringBuilder();
        sbStore.append("Before: ");
        Analysis.Direction analysisDirection = analysis.getDirection();
        if (analysisDirection == Analysis.Direction.FORWARD) {
            TransferInput<V, S> input = analysis.getInput(bb);
            assert (input != null) : "@AssumeAssertion(nullness): invariant";
            isTwoStores = input.containsTwoStores();
            regularStore = input.getRegularStore();
            thenStore = input.getThenStore();
            elseStore = input.getElseStore();
        } else {
            regularStore = analysis.getResult().getStoreBefore(bb);
        }
        if (!isTwoStores) {
            sbStore.append(this.visualizeStore(regularStore));
        } else {
            assert (thenStore != null) : "@AssumeAssertion(nullness): invariant";
            assert (elseStore != null) : "@AssumeAssertion(nullness): invariant";
            sbStore.append("then=");
            sbStore.append(this.visualizeStore(thenStore));
            sbStore.append(", else=");
            sbStore.append(this.visualizeStore(elseStore));
        }
        sbStore.append("~~~~~~~~~").append(escapeString);
        return sbStore.toString();
    }

    protected String visualizeBlockTransferInputAfterHelper(Block bb, Analysis<V, S, T> analysis, String escapeString) {
        S regularStore;
        if (analysis == null) {
            throw new BugInCF("analysis should be non-null when visualizing the transfer input of a block.");
        }
        S thenStore = null;
        S elseStore = null;
        boolean isTwoStores = false;
        StringBuilder sbStore = new StringBuilder();
        sbStore.append("After: ");
        Analysis.Direction analysisDirection = analysis.getDirection();
        if (analysisDirection == Analysis.Direction.FORWARD) {
            regularStore = analysis.getResult().getStoreAfter(bb);
        } else {
            TransferInput<V, S> input = analysis.getInput(bb);
            assert (input != null) : "@AssumeAssertion(nullness): invariant";
            isTwoStores = input.containsTwoStores();
            regularStore = input.getRegularStore();
            thenStore = input.getThenStore();
            elseStore = input.getElseStore();
        }
        if (!isTwoStores) {
            sbStore.append(this.visualizeStore(regularStore));
        } else {
            assert (thenStore != null) : "@AssumeAssertion(nullness): invariant";
            assert (elseStore != null) : "@AssumeAssertion(nullness): invariant";
            sbStore.append("then=");
            sbStore.append(this.visualizeStore(thenStore));
            sbStore.append(", else=");
            sbStore.append(this.visualizeStore(elseStore));
        }
        sbStore.insert(0, "~~~~~~~~~" + escapeString);
        return sbStore.toString();
    }

    protected String visualizeSpecialBlockHelper(SpecialBlock sbb, String separator) {
        switch (sbb.getSpecialType()) {
            case ENTRY: {
                return "<entry>" + separator;
            }
            case EXIT: {
                return "<exit>" + separator;
            }
            case EXCEPTIONAL_EXIT: {
                return "<exceptional-exit>" + separator;
            }
        }
        throw new BugInCF("Unrecognized special block type: " + (Object)((Object)sbb.getType()));
    }

    protected @Nullable Node getLastNode(Block bb) {
        switch (bb.getType()) {
            case REGULAR_BLOCK: {
                List<Node> blockContents = ((RegularBlock)bb).getContents();
                return blockContents.get(blockContents.size() - 1);
            }
            case CONDITIONAL_BLOCK: 
            case SPECIAL_BLOCK: {
                return null;
            }
            case EXCEPTION_BLOCK: {
                return ((ExceptionBlock)bb).getNode();
            }
        }
        throw new Error("Unrecognized block type: " + (Object)((Object)bb.getType()));
    }

    protected IdentityHashMap<Block, List<Integer>> getProcessOrder(ControlFlowGraph cfg) {
        IdentityHashMap<Block, List<Integer>> depthFirstOrder = new IdentityHashMap<Block, List<Integer>>();
        int count = 1;
        for (Block b : cfg.getDepthFirstOrderedBlocks()) {
            depthFirstOrder.computeIfAbsent(b, k -> new ArrayList());
            @NonNull List<Integer> blockIds = depthFirstOrder.get(b);
            blockIds.add(count++);
        }
        return depthFirstOrder;
    }

    @Override
    public String visualizeStore(S store) {
        return store.visualize(this);
    }

    protected abstract String visualizeNodes(Set<Block> var1, ControlFlowGraph var2, @Nullable Analysis<V, S, T> var3);

    protected abstract String addEdge(Object var1, Object var2, String var3);

    protected abstract String visualizeGraphHeader();

    protected abstract String visualizeGraphFooter();

    protected String getProcessOrderSimpleString(List<Integer> order) {
        String orderString = order.toString();
        return "Process order: " + orderString.substring(1, orderString.length() - 1);
    }

    protected String getNodeSimpleName(Node t) {
        String name = t.getClass().getSimpleName();
        return name.replace("Node", "");
    }
}

