/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.JCTree;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.AbstractCFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.UserError;

public class DOTCFGVisualizer<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
extends AbstractCFGVisualizer<V, S, T> {
    protected String outDir;
    protected @Nullable String checkerName;
    protected Map<String, String> generated;
    protected static final String leftJustifiedTerminator = "\\l";

    @Override
    public void init(Map<String, Object> args) {
        super.init(args);
        this.outDir = (String)args.get("outdir");
        if (this.outDir == null) {
            throw new BugInCF("outDir should never be null, provide it in args when calling DOTCFGVisualizer.init(args).");
        }
        this.checkerName = (String)args.get("checkerName");
        this.generated = new HashMap<String, String>();
    }

    @Override
    public @Nullable Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        String dotGraph = this.visualizeGraph(cfg, entry, analysis);
        String dotFileName = this.dotOutputFileName(cfg.underlyingAST);
        try {
            FileWriter fStream = new FileWriter(dotFileName);
            BufferedWriter out = new BufferedWriter(fStream);
            out.write(dotGraph);
            out.close();
        }
        catch (IOException e) {
            throw new UserError("Error creating dot file (is the path valid?): " + dotFileName, new Object[]{e});
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("dotFileName", dotFileName);
        return res;
    }

    @Override
    public String visualizeNodes(Set<Block> blocks, ControlFlowGraph cfg, @Nullable Analysis<V, S, T> analysis) {
        StringBuilder sbDotNodes = new StringBuilder();
        sbDotNodes.append(this.lineSeparator);
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        for (Block v : blocks) {
            String strBlock;
            sbDotNodes.append("    ").append(v.getId()).append(" [");
            if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sbDotNodes.append("shape=polygon sides=8 ");
            } else if (v.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sbDotNodes.append("shape=oval ");
            } else {
                sbDotNodes.append("shape=rectangle ");
            }
            sbDotNodes.append("label=\"");
            if (this.verbose) {
                sbDotNodes.append(this.getProcessOrderSimpleString(processOrder.get(v))).append(leftJustifiedTerminator);
            }
            if ((strBlock = this.visualizeBlock(v, analysis)).length() == 0) {
                if (v.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                    sbDotNodes.append("\"];").append(this.lineSeparator);
                    continue;
                }
                sbDotNodes.append("?? empty ??\"];").append(this.lineSeparator);
                continue;
            }
            sbDotNodes.append(strBlock).append("\"];").append(this.lineSeparator);
        }
        return sbDotNodes.toString();
    }

    @Override
    protected String addEdge(Object sId, Object eId, String flowRule) {
        return "    " + this.format(sId) + " -> " + this.format(eId) + " [label=\"" + flowRule + "\"];" + this.lineSeparator;
    }

    @Override
    public String visualizeBlock(Block bb, @Nullable Analysis<V, S, T> analysis) {
        return super.visualizeBlockHelper(bb, analysis, leftJustifiedTerminator);
    }

    @Override
    public String visualizeSpecialBlock(SpecialBlock sbb) {
        return super.visualizeSpecialBlockHelper(sbb, "\\n");
    }

    @Override
    public String visualizeConditionalBlock(ConditionalBlock cbb) {
        return "";
    }

    @Override
    public String visualizeBlockTransferInputBefore(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputBeforeHelper(bb, analysis, leftJustifiedTerminator);
    }

    @Override
    public String visualizeBlockTransferInputAfter(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputAfterHelper(bb, analysis, leftJustifiedTerminator);
    }

    protected String dotOutputFileName(UnderlyingAST ast) {
        StringBuilder srcLoc = new StringBuilder();
        StringBuilder outFile = new StringBuilder(this.outDir);
        outFile.append("/");
        if (ast.getKind() == UnderlyingAST.Kind.ARBITRARY_CODE) {
            UnderlyingAST.CFGStatement cfgStatement = (UnderlyingAST.CFGStatement)ast;
            String clsName = cfgStatement.getClassTree().getSimpleName().toString();
            outFile.append(clsName);
            outFile.append("-initializer-");
            outFile.append(ast.hashCode());
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::initializer::");
            srcLoc.append(((JCTree)cfgStatement.getCode()).pos);
            srcLoc.append(">");
        } else if (ast.getKind() == UnderlyingAST.Kind.METHOD) {
            UnderlyingAST.CFGMethod cfgMethod = (UnderlyingAST.CFGMethod)ast;
            String clsName = cfgMethod.getClassTree().getSimpleName().toString();
            String methodName = cfgMethod.getMethod().getName().toString();
            StringJoiner params = new StringJoiner(",");
            for (VariableTree variableTree : cfgMethod.getMethod().getParameters()) {
                params.add(variableTree.getType().toString());
            }
            outFile.append(clsName);
            outFile.append("-");
            outFile.append(methodName);
            if (params.length() != 0) {
                outFile.append("-");
                outFile.append(params);
            }
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::");
            srcLoc.append(methodName);
            srcLoc.append("(");
            srcLoc.append(params);
            srcLoc.append(")::");
            srcLoc.append(((JCTree)((Object)cfgMethod.getMethod())).pos);
            srcLoc.append(">");
        } else if (ast.getKind() == UnderlyingAST.Kind.LAMBDA) {
            UnderlyingAST.CFGLambda cfgLambda = (UnderlyingAST.CFGLambda)ast;
            String clsName = cfgLambda.getClassTree().getSimpleName().toString();
            String methodName = cfgLambda.getMethod().getName().toString();
            int hashCode = cfgLambda.getCode().hashCode();
            outFile.append(clsName);
            outFile.append("-");
            outFile.append(methodName);
            outFile.append("-");
            outFile.append(hashCode);
            srcLoc.append("<");
            srcLoc.append(clsName);
            srcLoc.append("::");
            srcLoc.append(methodName);
            srcLoc.append("(");
            srcLoc.append(cfgLambda.getMethod().getParameters());
            srcLoc.append(")::");
            srcLoc.append(((JCTree)cfgLambda.getCode()).pos);
            srcLoc.append(">");
        } else {
            throw new BugInCF("Unexpected AST kind: " + (Object)((Object)ast.getKind()) + " value: " + ast);
        }
        if (this.checkerName != null && !this.checkerName.isEmpty()) {
            outFile.append('-');
            outFile.append(this.checkerName);
        }
        outFile.append(".dot");
        String outFileName = outFile.toString().replace("<", "_").replace(">", "");
        this.generated.put(srcLoc.toString(), outFileName);
        return outFileName;
    }

    @Override
    protected String format(Object obj) {
        return this.escapeDoubleQuotes(obj);
    }

    @Override
    public String visualizeStoreThisVal(V value) {
        return "  this > " + value + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreLocalVar(FlowExpressions.LocalVariable localVar, V value) {
        return "  " + localVar + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreFieldVals(FlowExpressions.FieldAccess fieldAccess, V value) {
        return "  " + fieldAccess + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreArrayVal(FlowExpressions.ArrayAccess arrayValue, V value) {
        return "  " + arrayValue + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreMethodVals(FlowExpressions.MethodCall methodCall, V value) {
        return "  " + this.escapeDoubleQuotes(methodCall) + " > " + value + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreClassVals(FlowExpressions.ClassName className, V value) {
        return "  " + className + " > " + this.escapeDoubleQuotes(value) + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreKeyVal(String keyName, Object value) {
        return "  " + keyName + " = " + value + leftJustifiedTerminator;
    }

    private String escapeDoubleQuotes(String str) {
        return str.replace("\"", "\\\"");
    }

    private String escapeDoubleQuotes(Object obj) {
        return this.escapeDoubleQuotes(String.valueOf(obj));
    }

    @Override
    public String visualizeStoreHeader(String classCanonicalName) {
        return classCanonicalName + " (" + leftJustifiedTerminator;
    }

    @Override
    public String visualizeStoreFooter() {
        return ")\\l";
    }

    @Override
    public void shutdown() {
        try {
            FileWriter fstream = new FileWriter(this.outDir + "/methods.txt", true);
            BufferedWriter out = new BufferedWriter(fstream);
            for (Map.Entry<String, String> kv : this.generated.entrySet()) {
                out.write(kv.getKey());
                out.append("\t");
                out.write(kv.getValue());
                out.append(this.lineSeparator);
            }
            out.close();
        }
        catch (IOException e) {
            throw new UserError("Error creating methods.txt file in: " + this.outDir + "; ensure the path is valid", new Object[]{e});
        }
    }

    @Override
    protected String visualizeGraphHeader() {
        return "digraph {" + this.lineSeparator;
    }

    @Override
    protected String visualizeGraphFooter() {
        return "}" + this.lineSeparator;
    }
}

