/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.constantpropagation;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.cfg.CFGVisualizer;
import org.checkerframework.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.constantpropagation.Constant;

public class ConstantPropagationStore
implements Store<ConstantPropagationStore> {
    Map<Node, Constant> contents;

    public ConstantPropagationStore() {
        this.contents = new HashMap<Node, Constant>();
    }

    protected ConstantPropagationStore(Map<Node, Constant> contents) {
        this.contents = contents;
    }

    public Constant getInformation(Node n) {
        if (this.contents.containsKey(n)) {
            return this.contents.get(n);
        }
        return new Constant(Constant.Type.TOP);
    }

    public void mergeInformation(Node n, Constant val) {
        Constant value = this.contents.containsKey(n) ? val.leastUpperBound(this.contents.get(n)) : val;
        assert (n instanceof IntegerLiteralNode || n instanceof LocalVariableNode);
        this.contents.put(n, value);
    }

    public void setInformation(Node n, Constant val) {
        assert (n instanceof IntegerLiteralNode || n instanceof LocalVariableNode);
        this.contents.put(n, val);
    }

    @Override
    public ConstantPropagationStore copy() {
        return new ConstantPropagationStore(new HashMap<Node, Constant>(this.contents));
    }

    @Override
    public ConstantPropagationStore leastUpperBound(ConstantPropagationStore other) {
        Node n;
        HashMap<Node, Constant> newContents = new HashMap<Node, Constant>();
        for (Map.Entry<Node, Constant> e : other.contents.entrySet()) {
            n = e.getKey();
            Constant otherVal = e.getValue();
            if (this.contents.containsKey(n)) {
                newContents.put(n, otherVal.leastUpperBound(this.contents.get(n)));
                continue;
            }
            newContents.put(n, otherVal);
        }
        for (Map.Entry<Node, Constant> e : this.contents.entrySet()) {
            n = e.getKey();
            Constant thisVal = e.getValue();
            if (other.contents.containsKey(n)) continue;
            newContents.put(n, thisVal);
        }
        return new ConstantPropagationStore(newContents);
    }

    @Override
    public ConstantPropagationStore widenedUpperBound(ConstantPropagationStore previous) {
        return this.leastUpperBound(previous);
    }

    public boolean equals(@Nullable Object o) {
        Node n;
        if (o == null) {
            return false;
        }
        if (!(o instanceof ConstantPropagationStore)) {
            return false;
        }
        ConstantPropagationStore other = (ConstantPropagationStore)o;
        for (Map.Entry<Node, Constant> e : other.contents.entrySet()) {
            n = e.getKey();
            Constant otherVal = e.getValue();
            if (otherVal.isBottom()) continue;
            if (this.contents.containsKey(n)) {
                if (otherVal.equals(this.contents.get(n))) continue;
                return false;
            }
            return false;
        }
        for (Map.Entry<Node, Constant> e : this.contents.entrySet()) {
            n = e.getKey();
            Constant thisVal = e.getValue();
            if (thisVal.isBottom() || other.contents.containsKey(n)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int s = 0;
        for (Map.Entry<Node, Constant> e : this.contents.entrySet()) {
            if (e.getValue().isBottom()) continue;
            s += e.hashCode();
        }
        return s;
    }

    public String toString() {
        HashMap<Node, Constant> smallerContents = new HashMap<Node, Constant>();
        for (Map.Entry<Node, Constant> e : this.contents.entrySet()) {
            if (!(e.getKey() instanceof LocalVariableNode)) continue;
            smallerContents.put(e.getKey(), e.getValue());
        }
        return ((Object)smallerContents).toString();
    }

    @Override
    public boolean canAlias(FlowExpressions.Receiver a, FlowExpressions.Receiver b) {
        return true;
    }

    @Override
    public String visualize(CFGVisualizer<?, ConstantPropagationStore, ?> viz) {
        return viz.visualizeStoreKeyVal("constant propagation", null);
    }
}

