/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.test.TestUtilities;

public class SimpleOptionMap {
    private final Map<String, @Nullable String> options = new LinkedHashMap<String, String>();

    public void setOptions(Map<String, @Nullable String> options) {
        this.options.clear();
        this.options.putAll(options);
    }

    public void addToPathOption(String key, String toAppend) {
        if (toAppend == null) {
            throw new IllegalArgumentException("Null string appended to sourcePath.");
        }
        String path = this.options.get(key);
        path = toAppend.startsWith(File.pathSeparator) ? (path == null || path.isEmpty() ? toAppend.substring(1, toAppend.length()) : path + toAppend) : (path == null || path.isEmpty() ? toAppend : path + File.pathSeparator + toAppend);
        this.addOption(key, path);
    }

    public void addOption(String option) {
        this.options.put(option, null);
    }

    public void addOption(String option, String value) {
        this.options.put(option, value);
    }

    public void addOptionIfValueNonEmpty(String option, String value) {
        if (value != null && !value.isEmpty()) {
            this.addOption(option, value);
        }
    }

    public void addOptions(Map<String, @Nullable String> options) {
        this.options.putAll(options);
    }

    public void addOptions(Iterable<String> newOptions) {
        Iterator<String> optIter = newOptions.iterator();
        while (optIter.hasNext()) {
            String opt = optIter.next();
            if (this.options.get(opt) != null) {
                if (!optIter.hasNext()) {
                    throw new RuntimeException("Expected a value for option: " + opt + " in option list: " + String.join((CharSequence)", ", newOptions));
                }
                this.options.put(opt, optIter.next());
                continue;
            }
            this.options.put(opt, null);
        }
    }

    public Map<String, @Nullable String> getOptions() {
        return this.options;
    }

    public List<String> getOptionsAsList() {
        return TestUtilities.optionMapToList(this.options);
    }
}

