/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import org.checkerframework.common.value.qual.StringVal;
import org.checkerframework.framework.test.AinferGeneratePerDirectoryTest;
import org.checkerframework.framework.test.CheckerFrameworkWPIPerDirectoryTest;

public class AinferValidatePerDirectoryTest
extends CheckerFrameworkWPIPerDirectoryTest {
    private final Class<? extends AinferGeneratePerDirectoryTest> generationTest;
    private final String CHECKER_SHORT_NAME;
    private static final int DOT_JAVA_LETTER_COUNT = ".java".length();

    protected AinferValidatePerDirectoryTest(List<File> testFiles, Class<? extends AbstractProcessor> checker, String checkerShortName, String testDir, Class<? extends AinferGeneratePerDirectoryTest> generationTest, String ... checkerOptions) {
        super(testFiles, checker, testDir, checkerOptions);
        this.generationTest = generationTest;
        this.CHECKER_SHORT_NAME = checkerShortName;
    }

    private static String getInferenceBaseDir(String checkerShortName) {
        return "tests/ainfer-" + checkerShortName + "/inference-output/";
    }

    protected static String ajavaArgFromFiles(List<File> sourceFiles, String checkerShortName) {
        return AinferValidatePerDirectoryTest.annotationArgFromFiles(sourceFiles, AinferValidatePerDirectoryTest.getInferenceBaseDir(checkerShortName), ".ajava");
    }

    protected static String astubsArgFromFiles(List<File> sourceFiles, String checkerShortName) {
        return AinferValidatePerDirectoryTest.annotationArgFromFiles(sourceFiles, AinferValidatePerDirectoryTest.getInferenceBaseDir(checkerShortName), ".astub");
    }

    private static String annotationArgFromFiles(List<File> sourceFiles, String inferenceBaseDir, @StringVal(value={".astub", ".ajava"}) String extension) {
        String checkerArg = extension.equals(".astub") ? "-Astubs=" : "-Aajava=";
        return checkerArg + sourceFiles.stream().map(f -> AinferValidatePerDirectoryTest.annotationFilenameFromSourceFile(f, inferenceBaseDir, extension)).filter(s -> !s.isEmpty()).collect(Collectors.joining(":"));
    }

    private static String annotationFilenameFromSourceFile(File sourceFile, String inferenceBaseDir, @StringVal(value={".astub", ".ajava"}) String extension) {
        String fileBaseName = sourceFile.getName().substring(0, sourceFile.getName().length() - DOT_JAVA_LETTER_COUNT);
        StringBuilder sb = new StringBuilder();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(inferenceBaseDir, new String[0]), "*" + fileBaseName + "{-,$}*" + extension);){
            dirStream.forEach(f -> sb.append(f).append(":"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public void run() {
        if (this.generationTest != null && !new File("tests/ainfer-" + this.CHECKER_SHORT_NAME + "/annotated/").exists()) {
            throw new RuntimeException(this.generationTest + " must be run before this test.");
        }
        super.run();
    }
}

