/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.AbstractProcessor;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.framework.test.CheckerFrameworkRootedTest;
import org.checkerframework.framework.test.PerDirectorySuite;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestConfigurationBuilder;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.TypecheckExecutor;
import org.checkerframework.framework.test.TypecheckResult;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PerDirectorySuite.class)
public abstract class CheckerFrameworkPerDirectoryTest
extends CheckerFrameworkRootedTest {
    protected final List<File> testFiles;
    protected final List<@BinaryName String> checkerNames;
    protected final String testDir;
    protected final List<String> checkerOptions;
    protected final List<String> classpathExtra;

    protected CheckerFrameworkPerDirectoryTest(List<File> testFiles, Class<? extends AbstractProcessor> checker, String testDir, String ... checkerOptions) {
        this(testFiles, checker, testDir, Collections.emptyList(), checkerOptions);
    }

    protected CheckerFrameworkPerDirectoryTest(List<File> testFiles, Class<? extends AbstractProcessor> checker, String testDir, List<String> classpathExtra, String ... checkerOptions) {
        this(testFiles, Collections.singletonList(checker.getName()), testDir, classpathExtra, checkerOptions);
    }

    protected CheckerFrameworkPerDirectoryTest(List<File> testFiles, List<@BinaryName String> checkerNames, String testDir, List<String> classpathExtra, String ... checkerOptions) {
        this.testFiles = testFiles;
        this.checkerNames = checkerNames;
        this.testDir = testDir;
        this.classpathExtra = classpathExtra;
        this.checkerOptions = new ArrayList<String>(Arrays.asList(checkerOptions));
        this.checkerOptions.add("-AajavaChecks");
        this.checkerOptions.add("-AconvertTypeArgInferenceCrashToWarning=false");
    }

    @Test
    public void run() {
        if (this.testFiles.isEmpty()) {
            return;
        }
        boolean shouldEmitDebugInfo = TestUtilities.getShouldEmitDebugInfo();
        List<String> customizedOptions = this.customizeOptions(Collections.unmodifiableList(this.checkerOptions));
        TestConfiguration config = TestConfigurationBuilder.buildDefaultConfiguration(new File(this.resolveTestDirectory(), this.testDir).getPath(), this.testFiles, this.classpathExtra, this.checkerNames, customizedOptions, shouldEmitDebugInfo);
        TypecheckResult testResult = new TypecheckExecutor().runTest(config);
        TypecheckResult adjustedTestResult = this.adjustTypecheckResult(testResult);
        this.checkResult(adjustedTestResult);
    }

    public TypecheckResult adjustTypecheckResult(TypecheckResult testResult) {
        return testResult;
    }

    public List<String> customizeOptions(List<String> previousOptions) {
        return previousOptions;
    }
}

