/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.BinaryName;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestUtilities;
import org.plumelib.util.UtilPlume;

public class ImmutableTestConfiguration
implements TestConfiguration {
    private final Map<String, @Nullable String> options;
    private final List<File> diagnosticFiles;
    private final List<File> testSourceFiles;
    private final List<@BinaryName String> processors;
    private final boolean shouldEmitDebugInfo;

    public ImmutableTestConfiguration(List<File> diagnosticFiles, List<File> testSourceFiles, List<@BinaryName String> processors, Map<String, @Nullable String> options, boolean shouldEmitDebugInfo) {
        this.diagnosticFiles = Collections.unmodifiableList(diagnosticFiles);
        this.testSourceFiles = Collections.unmodifiableList(new ArrayList<File>(testSourceFiles));
        this.processors = new ArrayList<String>(processors);
        this.options = Collections.unmodifiableMap(new LinkedHashMap<String, String>(options));
        this.shouldEmitDebugInfo = shouldEmitDebugInfo;
    }

    @Override
    public List<File> getTestSourceFiles() {
        return this.testSourceFiles;
    }

    @Override
    public List<File> getDiagnosticFiles() {
        return this.diagnosticFiles;
    }

    @Override
    public List<@BinaryName String> getProcessors() {
        return this.processors;
    }

    @Override
    public Map<String, @Nullable String> getOptions() {
        return this.options;
    }

    @Override
    public List<String> getFlatOptions() {
        return TestUtilities.optionMapToList(this.options);
    }

    @Override
    public boolean shouldEmitDebugInfo() {
        return this.shouldEmitDebugInfo;
    }

    public String toString() {
        return UtilPlume.joinLines((Object[])new String[]{"TestConfigurationBuilder:", "testSourceFiles=" + UtilPlume.join((CharSequence)" ", this.testSourceFiles), "processors=" + String.join((CharSequence)", ", this.processors), "options=" + String.join((CharSequence)", ", this.getFlatOptions()), "shouldEmitDebugInfo=" + this.shouldEmitDebugInfo});
    }
}

