/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class AnnotationUtils {
    private AnnotationUtils() {
        throw new AssertionError((Object)"Class AnnotationUtils cannot be instantiated.");
    }

    public static final String annotationName(AnnotationMirror annotation) {
        if (annotation instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror) {
            return ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)annotation).annotationName;
        }
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        String name = elm.getQualifiedName().toString();
        return name;
    }

    public static boolean areSame(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == a2) {
            return true;
        }
        if (!AnnotationUtils.areSameByName(a1, a2)) {
            return false;
        }
        return AnnotationUtils.sameElementValues(a1, a2);
    }

    public static boolean areSameByName(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null) {
            throw new BugInCF("Unexpected null first argument to areSameByName");
        }
        if (a2 == null) {
            throw new BugInCF("Unexpected null second argument to areSameByName");
        }
        if (a1 instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror && a2 instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror) {
            return ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)a1).annotationName == ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)a2).annotationName;
        }
        return AnnotationUtils.annotationName(a1).equals(AnnotationUtils.annotationName(a2));
    }

    public static boolean areSameByName(AnnotationMirror am, String aname) {
        return aname.equals(AnnotationUtils.annotationName(am));
    }

    public static boolean areSameByClass(AnnotationMirror am, Class<? extends Annotation> annoClass) {
        String canonicalName = annoClass.getCanonicalName();
        assert (canonicalName != null) : "@AssumeAssertion(nullness): assumption";
        return AnnotationUtils.areSameByName(am, canonicalName);
    }

    public static boolean areSame(Collection<? extends AnnotationMirror> c1, Collection<? extends AnnotationMirror> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.size() == 1) {
            return AnnotationUtils.areSame(c1.iterator().next(), c2.iterator().next());
        }
        SortedSet<AnnotationMirror> s1 = AnnotationUtils.createAnnotationSet();
        SortedSet<AnnotationMirror> s2 = AnnotationUtils.createAnnotationSet();
        s1.addAll(c1);
        s2.addAll(c2);
        Iterator iter1 = s1.iterator();
        Iterator iter2 = s2.iterator();
        while (iter1.hasNext()) {
            AnnotationMirror anno2;
            AnnotationMirror anno1 = (AnnotationMirror)iter1.next();
            if (AnnotationUtils.areSame(anno1, anno2 = (AnnotationMirror)iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSame(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSame(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        return AnnotationUtils.getAnnotationByClass(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getAnnotationByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByName(Collection<? extends AnnotationMirror> c, String anno) {
        return AnnotationUtils.getAnnotationByName(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getAnnotationByName(Collection<? extends AnnotationMirror> c, String anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByName(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByName(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSameByName(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getSameByName(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByName(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static int compareAnnotationMirrors(AnnotationMirror a1, AnnotationMirror a2) {
        if (!AnnotationUtils.areSameByName(a1, a2)) {
            return AnnotationUtils.annotationName(a1).compareTo(AnnotationUtils.annotationName(a2));
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals1 = a1.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals2 = a2.getElementValues();
        TreeSet<ExecutableElement> sortedElements = new TreeSet<ExecutableElement>(Comparator.comparing(ElementUtils::getSimpleName));
        sortedElements.addAll(ElementFilter.methodsIn(a1.getAnnotationType().asElement().getEnclosedElements()));
        for (ExecutableElement meth : sortedElements) {
            int result;
            AnnotationValue aval1 = vals1.get(meth);
            AnnotationValue aval2 = vals2.get(meth);
            if (aval1 == null) {
                aval1 = meth.getDefaultValue();
            }
            if (aval2 == null) {
                aval2 = meth.getDefaultValue();
            }
            if ((result = AnnotationUtils.compareAnnotationValue(aval1, aval2)) == 0) continue;
            return result;
        }
        return 0;
    }

    private static int compareAnnotationValue(AnnotationValue av1, AnnotationValue av2) {
        if (av1 == av2) {
            return 0;
        }
        if (av1 == null) {
            return -1;
        }
        if (av2 == null) {
            return 1;
        }
        return AnnotationUtils.compareAnnotationValueValue(av1.getValue(), av2.getValue());
    }

    private static int compareAnnotationValueValue(@Nullable Object val1, @Nullable Object val2) {
        if (val1 == val2) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        if (val1 instanceof List && val2 instanceof List) {
            List list1 = (List)val1;
            List list2 = (List)val2;
            if (list1.size() != list2.size()) {
                return list1.size() - list2.size();
            }
            for (int i = 0; i < list1.size(); ++i) {
                Object v2;
                Object v1 = list1.get(i);
                int result = AnnotationUtils.compareAnnotationValueValue(v1, v2 = list2.get(i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        if (val1 instanceof AnnotationMirror && val2 instanceof AnnotationMirror) {
            return AnnotationUtils.compareAnnotationMirrors((AnnotationMirror)val1, (AnnotationMirror)val2);
        }
        if (val1 instanceof AnnotationValue && val2 instanceof AnnotationValue) {
            return AnnotationUtils.compareAnnotationValue((AnnotationValue)val1, (AnnotationValue)val2);
        }
        if (val1 instanceof Type.ClassType && val2 instanceof Type.ClassType && TypesUtils.areSameDeclaredTypes((Type.ClassType)val1, (Type.ClassType)val2)) {
            return 0;
        }
        if (Objects.equals(val1, val2)) {
            return 0;
        }
        int result = val1.toString().compareTo(val2.toString());
        if (result == 0) {
            result = -1;
        }
        return result;
    }

    @Deprecated
    public static Comparator<AnnotationMirror> annotationOrdering() {
        return AnnotationUtils::compareAnnotationMirrors;
    }

    public static <V> Map<AnnotationMirror, V> createAnnotationMap() {
        return new TreeMap(AnnotationUtils::compareAnnotationMirrors);
    }

    public static SortedSet<AnnotationMirror> createAnnotationSet() {
        return new TreeSet<AnnotationMirror>(AnnotationUtils::compareAnnotationMirrors);
    }

    public static boolean hasInheritedMeta(AnnotationMirror anno) {
        return anno.getAnnotationType().asElement().getAnnotation(Inherited.class) != null;
    }

    public static EnumSet<ElementKind> getElementKindsForTarget(@Nullable Target target) {
        if (target == null) {
            return EnumSet.allOf(ElementKind.class);
        }
        EnumSet<ElementKind> eleKinds = EnumSet.noneOf(ElementKind.class);
        for (ElementType elementType : target.value()) {
            eleKinds.addAll(AnnotationUtils.getElementKindsForElementType(elementType));
        }
        return eleKinds;
    }

    public static EnumSet<ElementKind> getElementKindsForElementType(ElementType elementType) {
        switch (elementType) {
            case TYPE: {
                return EnumSet.copyOf(ElementUtils.classElementKinds());
            }
            case FIELD: {
                return EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT);
            }
            case METHOD: {
                return EnumSet.of(ElementKind.METHOD);
            }
            case PARAMETER: {
                return EnumSet.of(ElementKind.PARAMETER);
            }
            case CONSTRUCTOR: {
                return EnumSet.of(ElementKind.CONSTRUCTOR);
            }
            case LOCAL_VARIABLE: {
                return EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER);
            }
            case ANNOTATION_TYPE: {
                return EnumSet.of(ElementKind.ANNOTATION_TYPE);
            }
            case PACKAGE: {
                return EnumSet.of(ElementKind.PACKAGE);
            }
            case TYPE_PARAMETER: {
                return EnumSet.of(ElementKind.TYPE_PARAMETER);
            }
            case TYPE_USE: {
                return EnumSet.noneOf(ElementKind.class);
            }
        }
        if (elementType.name().contentEquals("MODULE")) {
            return EnumSet.noneOf(ElementKind.class);
        }
        if (elementType.name().equals("RECORD_COMPONENT")) {
            return EnumSet.of(ElementKind.valueOf("RECORD_COMPONENT"));
        }
        throw new BugInCF("Unrecognized ElementType: " + (Object)((Object)elementType));
    }

    public static Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror ad) {
        HashMap<? extends ExecutableElement, ? extends AnnotationValue> valMap = new HashMap<ExecutableElement, AnnotationValue>();
        if (ad.getElementValues() != null) {
            valMap.putAll(ad.getElementValues());
        }
        for (ExecutableElement meth : ElementFilter.methodsIn(ad.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = meth.getDefaultValue();
            if (defaultValue == null || valMap.containsKey(meth)) continue;
            valMap.put(meth, defaultValue);
        }
        return valMap;
    }

    public static boolean sameElementValues(AnnotationMirror am1, AnnotationMirror am2) {
        if (am1 == am2) {
            return true;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals1 = am1.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals2 = am2.getElementValues();
        for (ExecutableElement meth : ElementFilter.methodsIn(am1.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue aval1 = vals1.get(meth);
            AnnotationValue aval2 = vals2.get(meth);
            if (aval1 == null) {
                aval1 = meth.getDefaultValue();
            }
            if (aval2 == null) {
                aval2 = meth.getDefaultValue();
            }
            if (AnnotationUtils.sameAnnotationValue(aval1, aval2)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameAnnotationValue(AnnotationValue av1, AnnotationValue av2) {
        return AnnotationUtils.compareAnnotationValue(av1, av2) == 0;
    }

    public static boolean hasElementValue(AnnotationMirror anno, CharSequence elementName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(elementName)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getElementValue(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = useDefaults ? AnnotationUtils.getElementValuesWithDefaults(anno) : anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(elementName)) continue;
            AnnotationValue val = valmap.get(executableElement);
            return expectedType.cast(val.getValue());
        }
        throw new NoSuchElementException(String.format("No element with name '%s' in annotation %s; useDefaults=%s, valmap.keySet()=%s", elementName, anno, useDefaults, valmap.keySet()));
    }

    public static <T> @Nullable T getElementValueOrNull(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        try {
            return AnnotationUtils.getElementValue(anno, elementName, expectedType, useDefaults);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        Symbol.VarSymbol vs = AnnotationUtils.getElementValue(anno, elementName, Symbol.VarSymbol.class, useDefaults);
        T value = Enum.valueOf(expectedType, ((Name)vs.getSimpleName()).toString());
        return value;
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, elementName, List.class, useDefaults);
        ArrayList<T> result = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            result.add(expectedType.cast(a.getValue()));
        }
        return result;
    }

    public static <T extends Enum<T>> List<T> getElementValueEnumArray(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, elementName, List.class, useDefaults);
        ArrayList<T> result = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            T value = Enum.valueOf(expectedType, a.getValue().toString());
            result.add(value);
        }
        return result;
    }

    public static @DotSeparatedIdentifiers javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, CharSequence elementName, boolean useDefaults) {
        Type.ClassType ct = AnnotationUtils.getElementValue(anno, elementName, Type.ClassType.class, useDefaults);
        return ((Symbol)ct.asElement()).getQualifiedName();
    }

    public static List<javax.lang.model.element.Name> getElementValueClassNames(AnnotationMirror anno, CharSequence annoElement, boolean useDefaults) {
        List<Type.ClassType> la = AnnotationUtils.getElementValueArray(anno, annoElement, Type.ClassType.class, useDefaults);
        ArrayList<javax.lang.model.element.Name> names = new ArrayList<javax.lang.model.element.Name>();
        for (Type.ClassType classType : la) {
            names.add(((Symbol)classType.asElement()).getQualifiedName());
        }
        return names;
    }

    public static <T> void updateMappingToImmutableSet(Map<T, Set<AnnotationMirror>> map, T key, Set<AnnotationMirror> newQual) {
        SortedSet<AnnotationMirror> result = AnnotationUtils.createAnnotationSet();
        if (!map.containsKey(key)) {
            result.addAll(newQual);
        } else {
            result.addAll((Collection<AnnotationMirror>)map.get(key));
            result.addAll(newQual);
        }
        map.put(key, Collections.unmodifiableSet(result));
    }

    public static Set<AnnotationMirror> getExplicitAnnotationsOnConstructorResult(MethodTree constructorDeclaration) {
        SortedSet<AnnotationMirror> annotationSet = AnnotationUtils.createAnnotationSet();
        ModifiersTree modifiersTree = constructorDeclaration.getModifiers();
        if (modifiersTree != null) {
            List<? extends AnnotationTree> annotationTrees = modifiersTree.getAnnotations();
            annotationSet.addAll(TreeUtils.annotationsFromTypeAnnotationTrees(annotationTrees));
        }
        return annotationSet;
    }

    public static boolean isDeclarationAnnotation(AnnotationMirror anno) {
        TypeElement elem = (TypeElement)anno.getAnnotationType().asElement();
        Target t = elem.getAnnotation(Target.class);
        if (t == null) {
            return true;
        }
        for (ElementType elementType : t.value()) {
            if (elementType != ElementType.TYPE_USE) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeQualifierElementTypes(ElementType[] elements, Class<?> cls) {
        boolean hasTypeUse = false;
        ElementType otherElementType = null;
        for (ElementType element : elements) {
            if (element == ElementType.TYPE_USE) {
                hasTypeUse = true;
            } else if (element != ElementType.TYPE_PARAMETER) {
                otherElementType = element;
            }
            if (!hasTypeUse || otherElementType == null) continue;
            throw new BugInCF("@Target meta-annotation should not contain both TYPE_USE and " + (Object)((Object)otherElementType) + ", for annotation " + cls.getName());
        }
        return hasTypeUse;
    }

    private static class NoSuchElementException
    extends BugInCF {
        public NoSuchElementException(String message) {
            super(message);
        }
    }
}

