/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.tools.javac.code.Symbol;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.TypesUtils;

public class ElementUtils {
    private static final Set<ElementKind> classElementKinds = EnumSet.noneOf(ElementKind.class);

    private ElementUtils() {
        throw new AssertionError((Object)"Class ElementUtils cannot be instantiated.");
    }

    public static TypeElement enclosingClass(Element elem) {
        Element result = elem;
        while (result != null && !ElementUtils.isClassElement(result)) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (TypeElement)result;
    }

    public static PackageElement enclosingPackage(Element elem) {
        Element result = elem;
        while (result != null && result.getKind() != ElementKind.PACKAGE) {
            Element encl;
            result = encl = result.getEnclosingElement();
        }
        return (PackageElement)result;
    }

    public static @Nullable PackageElement parentPackage(PackageElement elem, Elements e) {
        String fqnstart = elem.getQualifiedName().toString();
        String fqn = fqnstart;
        if (fqn != null && !fqn.isEmpty() && fqn.contains(".")) {
            fqn = fqn.substring(0, fqn.lastIndexOf(46));
            return e.getPackageElement(fqn);
        }
        return null;
    }

    public static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Element element) {
        return element.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isEffectivelyFinal(Element element) {
        Symbol sym = (Symbol)element;
        if (sym.getEnclosingElement().getKind() == ElementKind.METHOD && (sym.getEnclosingElement().flags() & 0x400L) != 0L) {
            return true;
        }
        return (sym.flags() & 0x20000000010L) != 0L;
    }

    public static TypeMirror getType(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            return ((ExecutableElement)element).getReturnType();
        }
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            return ElementUtils.enclosingClass(element).asType();
        }
        return element.asType();
    }

    public static @Nullable Name getQualifiedClassName(Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            PackageElement elem = (PackageElement)element;
            return elem.getQualifiedName();
        }
        TypeElement elem = ElementUtils.enclosingClass(element);
        if (elem == null) {
            return null;
        }
        return elem.getQualifiedName();
    }

    public static String getVerboseName(Element elt) {
        Name n = ElementUtils.getQualifiedClassName(elt);
        if (n == null) {
            return "Unexpected element: " + elt;
        }
        if (elt.getKind() == ElementKind.PACKAGE || ElementUtils.isClassElement(elt)) {
            return n.toString();
        }
        return n + "." + elt;
    }

    public static String getSimpleName(ExecutableElement element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getSimpleName());
        sb.append("(");
        Iterator<? extends VariableElement> i = element.getParameters().iterator();
        while (i.hasNext()) {
            sb.append(ElementUtils.simpleTypeName(i.next().asType()));
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String simpleTypeName(TypeMirror type) {
        switch (type.getKind()) {
            case ARRAY: {
                return ElementUtils.simpleTypeName(((ArrayType)type).getComponentType()) + "[]";
            }
            case TYPEVAR: {
                return ((TypeVariable)type).asElement().getSimpleName().toString();
            }
            case DECLARED: {
                return ((DeclaredType)type).asElement().getSimpleName().toString();
            }
        }
        if (type.getKind().isPrimitive()) {
            return type.toString();
        }
        throw new BugInCF("ElementUtils: unhandled type kind: %s, type: %s", new Object[]{type.getKind(), type});
    }

    public static boolean isObject(TypeElement element) {
        return element.getQualifiedName().contentEquals("java.lang.Object");
    }

    public static boolean isCompileTimeConstant(Element elt) {
        return elt != null && (elt.getKind() == ElementKind.FIELD || elt.getKind() == ElementKind.LOCAL_VARIABLE) && ((VariableElement)elt).getConstantValue() != null;
    }

    public static boolean isElementFromByteCode(Element elt) {
        if (elt == null) {
            return false;
        }
        if (elt instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clss = (Symbol.ClassSymbol)elt;
            if (null != clss.classfile) {
                return clss.classfile.getName().endsWith(".class");
            }
            return false;
        }
        return ElementUtils.isElementFromByteCodeHelper(elt.getEnclosingElement());
    }

    private static boolean isElementFromByteCodeHelper(Element elt) {
        if (elt == null) {
            return false;
        }
        if (elt instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clss = (Symbol.ClassSymbol)elt;
            if (null != clss.classfile) {
                return clss.classfile.getName().endsWith(".class") || clss.classfile.getName().endsWith(".class)") || clss.classfile.getName().endsWith(".class)]");
            }
            return false;
        }
        return ElementUtils.isElementFromByteCodeHelper(elt.getEnclosingElement());
    }

    public static @Nullable VariableElement findFieldInType(TypeElement type, String name) {
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!field.getSimpleName().contentEquals(name)) continue;
            return field;
        }
        return null;
    }

    public static Set<VariableElement> findFieldsInType(TypeElement type, Collection<String> names) {
        HashSet<VariableElement> results = new HashSet<VariableElement>();
        for (VariableElement field : ElementFilter.fieldsIn(type.getEnclosedElements())) {
            if (!names.contains(field.getSimpleName().toString())) continue;
            results.add(field);
        }
        return results;
    }

    public static Set<VariableElement> findFieldsInTypeOrSuperType(TypeMirror type, Collection<String> names) {
        int origCardinality = names.size();
        HashSet<VariableElement> elements = new HashSet<VariableElement>();
        ElementUtils.findFieldsInTypeOrSuperType(type, names, elements);
        if (origCardinality != names.size() + elements.size()) {
            throw new BugInCF(String.format("Bad sizes: %d != %d + %d", origCardinality, names.size(), elements.size()));
        }
        return elements;
    }

    private static void findFieldsInTypeOrSuperType(TypeMirror type, Collection<String> notFound, Set<VariableElement> foundFields) {
        if (TypesUtils.isObject(type)) {
            return;
        }
        TypeElement elt = TypesUtils.getTypeElement(type);
        assert (elt != null) : "@AssumeAssertion(nullness): assumption";
        Set<VariableElement> fieldElts = ElementUtils.findFieldsInType(elt, notFound);
        for (VariableElement field : new HashSet<VariableElement>(fieldElts)) {
            if (!field.getModifiers().contains((Object)Modifier.PRIVATE)) {
                notFound.remove(field.getSimpleName().toString());
                continue;
            }
            fieldElts.remove(field);
        }
        foundFields.addAll(fieldElts);
        if (!notFound.isEmpty()) {
            ElementUtils.findFieldsInTypeOrSuperType(elt.getSuperclass(), notFound, foundFields);
        }
    }

    public static boolean isError(Element element) {
        return element.getClass().getName() == "com.sun.tools.javac.comp.Resolve$SymbolNotFoundError";
    }

    public static boolean hasReceiver(Element element) {
        return (element.getKind().isField() || element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) && !ElementUtils.isStatic(element);
    }

    public static List<TypeElement> getSuperTypes(TypeElement type, Elements elements) {
        ArrayList<TypeElement> superelems = new ArrayList<TypeElement>();
        if (type == null) {
            return superelems;
        }
        ArrayDeque<TypeElement> stack = new ArrayDeque<TypeElement>();
        stack.push(type);
        while (!stack.isEmpty()) {
            TypeElement supercls;
            TypeMirror supertypecls;
            TypeElement current = (TypeElement)stack.pop();
            try {
                supertypecls = current.getSuperclass();
            }
            catch (Symbol.CompletionFailure cf) {
                supertypecls = null;
            }
            if (supertypecls != null && supertypecls.getKind() != TypeKind.NONE && !superelems.contains(supercls = (TypeElement)((DeclaredType)supertypecls).asElement())) {
                stack.push(supercls);
                superelems.add(supercls);
            }
            for (TypeMirror typeMirror : current.getInterfaces()) {
                TypeElement superitf = (TypeElement)((DeclaredType)typeMirror).asElement();
                if (superelems.contains(superitf)) continue;
                stack.push(superitf);
                superelems.add(superitf);
            }
        }
        TypeElement jlobject = elements.getTypeElement("java.lang.Object");
        if (!superelems.contains(jlobject)) {
            superelems.add(jlobject);
        }
        return Collections.unmodifiableList(superelems);
    }

    public static List<VariableElement> getAllFieldsIn(TypeElement type, Elements elements) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        fields.addAll(ElementFilter.fieldsIn(type.getEnclosedElements()));
        List<TypeElement> alltypes = ElementUtils.getSuperTypes(type, elements);
        for (TypeElement atype : alltypes) {
            fields.addAll(ElementFilter.fieldsIn(atype.getEnclosedElements()));
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<ExecutableElement> getAllMethodsIn(TypeElement type, Elements elements) {
        ArrayList<ExecutableElement> meths = new ArrayList<ExecutableElement>();
        meths.addAll(ElementFilter.methodsIn(type.getEnclosedElements()));
        List<TypeElement> alltypes = ElementUtils.getSuperTypes(type, elements);
        for (TypeElement atype : alltypes) {
            meths.addAll(ElementFilter.methodsIn(atype.getEnclosedElements()));
        }
        return Collections.unmodifiableList(meths);
    }

    public static List<TypeElement> getAllTypeElementsIn(TypeElement type) {
        ArrayList<TypeElement> types = new ArrayList<TypeElement>();
        types.addAll(ElementFilter.typesIn(type.getEnclosedElements()));
        return types;
    }

    public static Set<ElementKind> classElementKinds() {
        return classElementKinds;
    }

    public static boolean isClassElement(Element element) {
        return ElementUtils.classElementKinds().contains((Object)element.getKind());
    }

    public static boolean isTypeDeclaration(Element elt) {
        return ElementUtils.isClassElement(elt) || elt.getKind() == ElementKind.TYPE_PARAMETER;
    }

    public static boolean matchesElement(ExecutableElement method, String methodName, Class<?> ... parameters) {
        if (!method.getSimpleName().contentEquals(methodName)) {
            return false;
        }
        if (method.getParameters().size() != parameters.length) {
            return false;
        }
        for (int i = 0; i < method.getParameters().size(); ++i) {
            if (method.getParameters().get(i).asType().toString().equals(parameters[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean isMethod(ExecutableElement questioned, ExecutableElement method, ProcessingEnvironment env) {
        TypeElement enclosing = (TypeElement)questioned.getEnclosingElement();
        return questioned.equals(method) || env.getElementUtils().overrides(questioned, method, enclosing);
    }

    static {
        for (ElementKind kind : ElementKind.values()) {
            if (!kind.isClass() && !kind.isInterface()) continue;
            classElementKinds.add(kind);
        }
    }
}

