/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.BugInCF;

public abstract class AbstractTypeProcessor
extends AbstractProcessor {
    private final Set<Name> elements = new HashSet<Name>();
    private boolean hasInvokedTypeProcessingStart = false;
    private static boolean hasInvokedTypeProcessingOver = false;
    private final AttributionTaskListener listener = new AttributionTaskListener();

    protected AbstractTypeProcessor() {
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        JavacTask.instance(env).addTaskListener(this.listener);
        Context ctx = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        JavaCompiler compiler = JavaCompiler.instance(ctx);
        compiler.shouldStopPolicyIfNoError = CompileStates.CompileState.max(compiler.shouldStopPolicyIfNoError, CompileStates.CompileState.FLOW);
        compiler.shouldStopPolicyIfError = CompileStates.CompileState.max(compiler.shouldStopPolicyIfError, CompileStates.CompileState.FLOW);
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement elem : ElementFilter.typesIn(roundEnv.getRootElements())) {
            this.elements.add(elem.getQualifiedName());
        }
        return false;
    }

    public void typeProcessingStart() {
    }

    public abstract void typeProcess(TypeElement var1, TreePath var2);

    public void typeProcessingOver() {
    }

    @SideEffectFree
    public Log getCompilerLog() {
        return Log.instance(((JavacProcessingEnvironment)this.processingEnv).getContext());
    }

    private final class AttributionTaskListener
    implements TaskListener {
        private AttributionTaskListener() {
        }

        @Override
        public void finished(TaskEvent e) {
            if (e.getKind() != TaskEvent.Kind.ANALYZE) {
                return;
            }
            if (!AbstractTypeProcessor.this.hasInvokedTypeProcessingStart) {
                AbstractTypeProcessor.this.typeProcessingStart();
                AbstractTypeProcessor.this.hasInvokedTypeProcessingStart = true;
            }
            if (!hasInvokedTypeProcessingOver && AbstractTypeProcessor.this.elements.isEmpty()) {
                AbstractTypeProcessor.this.typeProcessingOver();
                hasInvokedTypeProcessingOver = true;
            }
            if (e.getTypeElement() == null) {
                throw new BugInCF("event task without a type element");
            }
            if (e.getCompilationUnit() == null) {
                throw new BugInCF("event task without compilation unit");
            }
            if (!AbstractTypeProcessor.this.elements.remove(e.getTypeElement().getQualifiedName())) {
                return;
            }
            TypeElement elem = e.getTypeElement();
            TreePath p = Trees.instance(AbstractTypeProcessor.this.processingEnv).getPath(elem);
            AbstractTypeProcessor.this.typeProcess(elem, p);
            if (!hasInvokedTypeProcessingOver && AbstractTypeProcessor.this.elements.isEmpty()) {
                AbstractTypeProcessor.this.typeProcessingOver();
                hasInvokedTypeProcessingOver = true;
            }
        }

        @Override
        public void started(TaskEvent e) {
        }
    }
}

