/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.SecureRandom;
import jdk.Profile+Annotation;
import jdk.internal.util.StaticProperty;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.javari.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.javari.qual.ThisMutable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;
import sun.misc.Unsafe;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@Profile+Annotation(value=1)
public class File
implements Serializable,
Comparable<File> {
    private static final @ThisMutable FileSystem fs;
    private final String path;
    private transient PathStatus status;
    private final transient int prefixLength;
    public static final @UnknownKeyFor @NonNull @Initialized @Mutable char separatorChar;
    public static final @UnknownKeyFor @NonNull @Initialized @ReadOnly String separator;
    public static final @UnknownKeyFor @NonNull @Initialized @Mutable char pathSeparatorChar;
    public static final @UnknownKeyFor @NonNull @Initialized @ReadOnly String pathSeparator;
    private static final long PATH_OFFSET;
    private static final long PREFIX_LENGTH_OFFSET;
    private static final Unsafe UNSAFE;
    private static final @UnknownKeyFor @NonNull @Initialized @Mutable long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    final boolean isInvalid();

    int getPrefixLength();

    private File(String var1, int var2);

    private File(String var1, File var2);

    @FromByteCode
    @FromByteCode
    public File(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var1);

    @FromByteCode
    @FromByteCode
    public File(@Nullable @UnknownKeyFor @Initialized @ReadOnly String var1, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var2);

    @FromByteCode
    @FromByteCode
    public @PolyRead File(@Nullable @UnknownKeyFor @Initialized @PolyRead File var1, @UnknownKeyFor @NonNull @Initialized @ReadOnly String var2);

    @FromByteCode
    @FromByteCode
    public File(@UnknownKeyFor @NonNull @Initialized @ReadOnly URI var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String getName(@ReadOnly File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @ReadOnly String getParent(@ReadOnly File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @PolyRead File getParentFile(@PolyRead File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String getPath(@ReadOnly File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean isAbsolute(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String getAbsolutePath(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead File getAbsoluteFile(@PolyRead File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String getCanonicalPath(@ReadOnly File this) throws IOException;

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead File getCanonicalFile(@PolyRead File this) throws IOException;

    private static String slashify(String var0, boolean var1);

    @Deprecated
    @FromByteCode
    @Deprecated
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead URL toURL(@PolyRead File this) throws MalformedURLException;

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead URI toURI(@PolyRead File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean canRead(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean canWrite(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean exists(@ReadOnly File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean isDirectory(@ReadOnly File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean isFile(@ReadOnly File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean isHidden(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable long lastModified(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable long length(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean createNewFile() throws IOException;

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean delete();

    @FromByteCode
    @FromByteCode
    public void deleteOnExit();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String @Nullable @UnknownKeyFor @Initialized @Mutable [] list(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String @Nullable @UnknownKeyFor @Initialized @Mutable [] list(@ReadOnly File this, @Nullable @UnknownKeyFor @Initialized @Mutable FilenameFilter var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead File @Nullable @UnknownKeyFor @Initialized @Mutable [] listFiles(@PolyRead File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead File @Nullable @UnknownKeyFor @Initialized @Mutable [] listFiles(@PolyRead File this, @Nullable @UnknownKeyFor @Initialized @Mutable FilenameFilter var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @PolyRead File @Nullable @UnknownKeyFor @Initialized @Mutable [] listFiles(@PolyRead File this, @Nullable @UnknownKeyFor @Initialized @Mutable FileFilter var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean mkdir();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean mkdirs();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean renameTo(@UnknownKeyFor @NonNull @Initialized @Mutable File var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setLastModified(@UnknownKeyFor @NonNull @Initialized @Mutable long var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setReadOnly();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setWritable(@UnknownKeyFor @NonNull @Initialized @Mutable boolean var1, @UnknownKeyFor @NonNull @Initialized @Mutable boolean var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setWritable(@UnknownKeyFor @NonNull @Initialized @Mutable boolean var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setReadable(@UnknownKeyFor @NonNull @Initialized @Mutable boolean var1, @UnknownKeyFor @NonNull @Initialized @Mutable boolean var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setReadable(@UnknownKeyFor @NonNull @Initialized @Mutable boolean var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setExecutable(@UnknownKeyFor @NonNull @Initialized @Mutable boolean var1, @UnknownKeyFor @NonNull @Initialized @Mutable boolean var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean setExecutable(@UnknownKeyFor @NonNull @Initialized @Mutable boolean var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean canExecute(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @Mutable File @Nullable @UnknownKeyFor @Initialized @Mutable [] listRoots();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable long getTotalSpace(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable long getFreeSpace(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable long getUsableSpace(@ReadOnly File this);

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @Mutable File createTempFile(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @Nullable @UnknownKeyFor @Initialized @ReadOnly String var1, @Nullable @UnknownKeyFor @Initialized @Mutable File var2) throws IOException;

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @Mutable File createTempFile(@UnknownKeyFor @NonNull @Initialized @ReadOnly String var0, @Nullable @UnknownKeyFor @Initialized @ReadOnly String var1) throws IOException;

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable int compareTo(@ReadOnly File this, @UnknownKeyFor @NonNull @Initialized @ReadOnly File var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable boolean equals(@ReadOnly File this, @Nullable @UnknownKeyFor @Initialized @ReadOnly Object var1);

    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @Mutable int hashCode(@ReadOnly File this);

    @SideEffectFree
    @FromByteCode
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @ReadOnly String toString(@ReadOnly File this);

    private synchronized void writeObject(ObjectOutputStream var1) throws IOException;

    private synchronized void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public Path toPath();

    static;

    private static enum PathStatus {
        INVALID,
        CHECKED;

    }

    private static class TempDirectory {
        private static final File TMPDIR = new File(StaticProperty.javaIoTmpDir());
        private static final SecureRandom RANDOM = new SecureRandom();

        private TempDirectory() {
        }

        static File location() {
            return TMPDIR;
        }

        private static int shortenSubName(int subNameLength, int excess, int nameMin) {
            int newLength = Math.max(nameMin, subNameLength - excess);
            if (newLength < subNameLength) {
                return newLength;
            }
            return subNameLength;
        }

        static File generateFile(String prefix, String suffix, File dir) throws IOException {
            String name;
            int nameMax;
            int suffixLength;
            int nusLength;
            long n = RANDOM.nextLong();
            String nus = Long.toUnsignedString(n);
            int prefixLength = (prefix = new File(prefix).getName()).length();
            int excess = prefixLength + (nusLength = nus.length()) + (suffixLength = suffix.length()) - (nameMax = FS.getNameMax(dir.getPath()));
            if (excess <= 0) {
                name = prefix + nus + suffix;
            } else {
                if ((excess = (prefixLength = TempDirectory.shortenSubName(prefixLength, excess, 3)) + nusLength + suffixLength - nameMax) > 0) {
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, suffix.indexOf(".") == 0 ? 4 : 0);
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, 3);
                    excess = prefixLength + nusLength + suffixLength - nameMax;
                }
                if (excess > 0 && excess <= nusLength - 5) {
                    nusLength = TempDirectory.shortenSubName(nusLength, excess, 5);
                }
                StringBuilder sb = new StringBuilder(prefixLength + nusLength + suffixLength);
                sb.append(prefixLength < prefix.length() ? prefix.substring(0, prefixLength) : prefix);
                sb.append(nusLength < nus.length() ? nus.substring(0, nusLength) : nus);
                sb.append(suffixLength < suffix.length() ? suffix.substring(0, suffixLength) : suffix);
                name = sb.toString();
            }
            name = FS.normalize(name);
            File f = new File(dir, name);
            if (!name.equals(f.getName()) || f.isInvalid()) {
                if (System.getSecurityManager() != null) {
                    throw new IOException("Unable to create temporary file");
                }
                throw new IOException("Unable to create temporary file, " + name);
            }
            return f;
        }
    }
}

